"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationDeployStackSetAction = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const action_1 = require("../action");
const common_1 = require("../common");
const singleton_policy_1 = require("./private/singleton-policy");
const stackset_types_1 = require("./stackset-types");
/**
 * CodePipeline action to deploy a stackset.
 *
 * CodePipeline offers the ability to perform AWS CloudFormation StackSets
 * operations as part of your CI/CD process. You use a stack set to create
 * stacks in AWS accounts across AWS Regions by using a single AWS
 * CloudFormation template. All the resources included in each stack are defined
 * by the stack set’s AWS CloudFormation template. When you create the stack
 * set, you specify the template to use, as well as any parameters and
 * capabilities that the template requires.
 *
 * For more information about concepts for AWS CloudFormation StackSets, see
 * [StackSets
 * concepts](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html)
 * in the AWS CloudFormation User Guide.
 *
 * If you use this action to make an update that includes adding stack
 * instances, the new instances are deployed first and the update is completed
 * last. The new instances first receive the old version, and then the update is
 * applied to all instances.
 *
 * As a best practice, you should construct your pipeline so that the stack set
 * is created and initially deploys to a subset or a single instance. After you
 * test your deployment and view the generated stack set, then add the
 * CloudFormationStackInstances action so that the remaining instances are
 * created and updated.
 */
class CloudFormationDeployStackSetAction extends action_1.Action {
    constructor(props) {
        var _b, _c, _d, _e, _f, _g;
        super({
            ...props,
            region: props.stackSetRegion,
            provider: 'CloudFormationStackSet',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 3,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [
                ...(_b = props.template._artifactsReferenced) !== null && _b !== void 0 ? _b : [],
                ...(_d = (_c = props.parameters) === null || _c === void 0 ? void 0 : _c._artifactsReferenced) !== null && _d !== void 0 ? _d : [],
                ...(_f = (_e = props.stackInstances) === null || _e === void 0 ? void 0 : _e._artifactsReferenced) !== null && _f !== void 0 ? _f : [],
            ],
        });
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_actions_CloudFormationDeployStackSetActionProps(props);
        this.props = props;
        this.deploymentModel = (_g = props.deploymentModel) !== null && _g !== void 0 ? _g : stackset_types_1.StackSetDeploymentModel.selfManaged();
        common_1.validatePercentage('failureTolerancePercentage', props.failureTolerancePercentage);
        common_1.validatePercentage('maxAccountConcurrencyPercentage', props.maxAccountConcurrencyPercentage);
    }
    bound(scope, _stage, options) {
        var _b, _c, _d, _e;
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(_stage);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        const singletonPolicy = singleton_policy_1.SingletonPolicy.forRole(options.role);
        singletonPolicy.grantCreateUpdateStackSet(this.props);
        const instancesResult = (_b = this.props.stackInstances) === null || _b === void 0 ? void 0 : _b._bind(scope);
        const permissionModelBind = (_c = this.deploymentModel) === null || _c === void 0 ? void 0 : _c._bind(scope);
        for (const role of (_d = permissionModelBind === null || permissionModelBind === void 0 ? void 0 : permissionModelBind.passedRoles) !== null && _d !== void 0 ? _d : []) {
            singletonPolicy.grantPassRole(role);
        }
        if ((this.actionProperties.inputs || []).length > 0) {
            options.bucket.grantRead(singletonPolicy);
        }
        return {
            configuration: {
                StackSetName: this.props.stackSetName,
                Description: this.props.description,
                TemplatePath: this.props.template._render(),
                Parameters: (_e = this.props.parameters) === null || _e === void 0 ? void 0 : _e._render(),
                Capabilities: singleton_policy_1.parseCapabilities(this.props.cfnCapabilities),
                FailureTolerancePercentage: this.props.failureTolerancePercentage,
                MaxConcurrentPercentage: this.props.maxAccountConcurrencyPercentage,
                ...instancesResult === null || instancesResult === void 0 ? void 0 : instancesResult.stackSetConfiguration,
                ...permissionModelBind === null || permissionModelBind === void 0 ? void 0 : permissionModelBind.stackSetConfiguration,
            },
        };
    }
}
exports.CloudFormationDeployStackSetAction = CloudFormationDeployStackSetAction;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationDeployStackSetAction[_a] = { fqn: "monocdk.aws_codepipeline_actions.CloudFormationDeployStackSetAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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