"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../aws-codepipeline");
/**
 * Low-level class for generic CodePipeline Actions.
 * If you're implementing your own IAction,
 * prefer to use the Action class from the codepipeline module.
 */
class Action extends codepipeline.Action {
    constructor(actionProperties) {
        super();
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionProperties(actionProperties);
        this.providedActionProperties = actionProperties;
    }
}
exports.Action = Action;
_a = JSII_RTTI_SYMBOL_1;
Action[_a] = { fqn: "monocdk.aws_codepipeline_actions.Action", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYWN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHVEQUF1RDtBQUV2RDs7OztHQUlHO0FBQ0gsTUFBc0IsTUFBTyxTQUFRLFlBQVksQ0FBQyxNQUFNO0lBR3RELFlBQXNCLGdCQUErQztRQUNuRSxLQUFLLEVBQUUsQ0FBQzs7UUFDUixJQUFJLENBQUMsd0JBQXdCLEdBQUcsZ0JBQWdCLENBQUM7S0FDbEQ7O0FBTkgsd0JBT0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjb2RlcGlwZWxpbmUgZnJvbSAnLi4vLi4vYXdzLWNvZGVwaXBlbGluZSc7XG5cbi8qKlxuICogTG93LWxldmVsIGNsYXNzIGZvciBnZW5lcmljIENvZGVQaXBlbGluZSBBY3Rpb25zLlxuICogSWYgeW91J3JlIGltcGxlbWVudGluZyB5b3VyIG93biBJQWN0aW9uLFxuICogcHJlZmVyIHRvIHVzZSB0aGUgQWN0aW9uIGNsYXNzIGZyb20gdGhlIGNvZGVwaXBlbGluZSBtb2R1bGUuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBBY3Rpb24gZXh0ZW5kcyBjb2RlcGlwZWxpbmUuQWN0aW9uIHtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHByb3ZpZGVkQWN0aW9uUHJvcGVydGllczogY29kZXBpcGVsaW5lLkFjdGlvblByb3BlcnRpZXM7XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKGFjdGlvblByb3BlcnRpZXM6IGNvZGVwaXBlbGluZS5BY3Rpb25Qcm9wZXJ0aWVzKSB7XG4gICAgc3VwZXIoKTtcbiAgICB0aGlzLnByb3ZpZGVkQWN0aW9uUHJvcGVydGllcyA9IGFjdGlvblByb3BlcnRpZXM7XG4gIH1cbn1cbiJdfQ==