import * as cdk from '../../../core';
import { Construct } from 'constructs';
import { CfnDeploymentConfig } from '../codedeploy.generated';
/**
 * The Deployment Configuration of an EC2/on-premise Deployment Group.
 * The default, pre-defined Configurations are available as constants on the {@link ServerDeploymentConfig} class
 * (`ServerDeploymentConfig.HALF_AT_A_TIME`, `ServerDeploymentConfig.ALL_AT_ONCE`, etc.).
 * To create a custom Deployment Configuration,
 * instantiate the {@link ServerDeploymentConfig} Construct.
 */
export interface IServerDeploymentConfig {
    /**
     * @attribute
     */
    readonly deploymentConfigName: string;
    /**
     * @attribute
     */
    readonly deploymentConfigArn: string;
}
/**
 * Minimum number of healthy hosts for a server deployment.
 */
export declare class MinimumHealthyHosts {
    private readonly json;
    /**
     * The minimum healhty hosts threshold expressed as an absolute number.
     */
    static count(value: number): MinimumHealthyHosts;
    /**
     * The minmum healhty hosts threshold expressed as a percentage of the fleet.
     */
    static percentage(value: number): MinimumHealthyHosts;
    private constructor();
    /**
     * @internal
     */
    get _json(): CfnDeploymentConfig.MinimumHealthyHostsProperty;
}
/**
 * Construction properties of {@link ServerDeploymentConfig}.
 */
export interface ServerDeploymentConfigProps {
    /**
     * The physical, human-readable name of the Deployment Configuration.
     *
     * @default a name will be auto-generated
     */
    readonly deploymentConfigName?: string;
    /**
     * Minimum number of healthy hosts.
     */
    readonly minimumHealthyHosts: MinimumHealthyHosts;
}
/**
 * A custom Deployment Configuration for an EC2/on-premise Deployment Group.
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
export declare class ServerDeploymentConfig extends cdk.Resource implements IServerDeploymentConfig {
    static readonly ONE_AT_A_TIME: IServerDeploymentConfig;
    static readonly HALF_AT_A_TIME: IServerDeploymentConfig;
    static readonly ALL_AT_ONCE: IServerDeploymentConfig;
    /**
     * Import a custom Deployment Configuration for an EC2/on-premise Deployment Group defined either outside the CDK app,
     * or in a different region.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param serverDeploymentConfigName the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromServerDeploymentConfigName(scope: Construct, id: string, serverDeploymentConfigName: string): IServerDeploymentConfig;
    readonly deploymentConfigName: string;
    readonly deploymentConfigArn: string;
    constructor(scope: Construct, id: string, props: ServerDeploymentConfigProps);
}
