"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Code = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const assets = require("../../aws-s3-assets");
/**
 * Represents the contents to initialize the repository with.
 */
class Code {
    /**
     * Code from directory.
     * @param directoryPath the path to the local directory containing the contents to initialize the repository with
     * @param branch the name of the branch to create in the repository. Default is "main"
     */
    static fromDirectory(directoryPath, branch) {
        const resolvedPath = path.resolve(directoryPath);
        const statResult = fs.statSync(resolvedPath);
        if (!statResult || !statResult.isDirectory()) {
            throw new Error(`'${directoryPath}' needs to be a path to a directory (resolved to: '${resolvedPath}')`);
        }
        return new PathResolvedCode(resolvedPath, branch);
    }
    /**
     * Code from preexisting ZIP file.
     * @param filePath the path to the local ZIP file containing the contents to initialize the repository with
     * @param branch the name of the branch to create in the repository. Default is "main"
     */
    static fromZipFile(filePath, branch) {
        const resolvedPath = path.resolve(filePath);
        const statResult = fs.statSync(resolvedPath);
        if (!statResult || !statResult.isFile()) {
            throw new Error(`'${filePath}' needs to be a path to a ZIP file (resolved to: '${resolvedPath}')`);
        }
        return new PathResolvedCode(resolvedPath, branch);
    }
    /**
     * Code from user-supplied asset.
     * @param asset pre-existing asset
     * @param branch the name of the branch to create in the repository. Default is "main"
     */
    static fromAsset(asset, branch) {
        jsiiDeprecationWarnings.monocdk_aws_s3_assets_Asset(asset);
        return new AssetCode(asset, branch);
    }
}
exports.Code = Code;
_a = JSII_RTTI_SYMBOL_1;
Code[_a] = { fqn: "monocdk.aws_codecommit.Code", version: "1.149.0" };
class PathResolvedCode extends Code {
    constructor(resolvedPath, branch) {
        super();
        this.resolvedPath = resolvedPath;
        this.branch = branch;
    }
    bind(scope) {
        const asset = new assets.Asset(scope, 'PathResolvedCodeAsset', {
            path: this.resolvedPath,
        });
        return (new AssetCode(asset, this.branch)).bind(scope);
    }
}
class AssetCode extends Code {
    constructor(asset, branch) {
        super();
        this.asset = asset;
        this.branch = branch;
    }
    bind(_scope) {
        if (!this.asset.isZipArchive) {
            throw new Error('Asset must be a .zip file or a directory (resolved to: ' + this.asset.assetPath + ' )');
        }
        return {
            code: {
                branchName: this.branch,
                s3: {
                    bucket: this.asset.s3BucketName,
                    key: this.asset.s3ObjectKey,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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