"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportGroupArnComponents = exports.renderReportGroupArn = void 0;
const cdk = require("../../core");
// this file contains a bunch of functions shared
// between Project and ResourceGroup,
// which we don't want to make part of the public API of this module
function renderReportGroupArn(scope, reportGroupName) {
    return cdk.Stack.of(scope).formatArn(reportGroupArnComponents(reportGroupName));
}
exports.renderReportGroupArn = renderReportGroupArn;
function reportGroupArnComponents(reportGroupName) {
    return {
        service: 'codebuild',
        resource: 'report-group',
        resourceName: reportGroupName,
    };
}
exports.reportGroupArnComponents = reportGroupArnComponents;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVwb3J0LWdyb3VwLXV0aWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVwb3J0LWdyb3VwLXV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGtDQUFrQztBQUdsQyxpREFBaUQ7QUFDakQscUNBQXFDO0FBQ3JDLG9FQUFvRTtBQUVwRSxTQUFnQixvQkFBb0IsQ0FBQyxLQUFnQixFQUFFLGVBQXVCO0lBQzVFLE9BQU8sR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsU0FBUyxDQUFDLHdCQUF3QixDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7QUFDbEYsQ0FBQztBQUZELG9EQUVDO0FBRUQsU0FBZ0Isd0JBQXdCLENBQUMsZUFBdUI7SUFDOUQsT0FBTztRQUNMLE9BQU8sRUFBRSxXQUFXO1FBQ3BCLFFBQVEsRUFBRSxjQUFjO1FBQ3hCLFlBQVksRUFBRSxlQUFlO0tBQzlCLENBQUM7QUFDSixDQUFDO0FBTkQsNERBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLy8gdGhpcyBmaWxlIGNvbnRhaW5zIGEgYnVuY2ggb2YgZnVuY3Rpb25zIHNoYXJlZFxuLy8gYmV0d2VlbiBQcm9qZWN0IGFuZCBSZXNvdXJjZUdyb3VwLFxuLy8gd2hpY2ggd2UgZG9uJ3Qgd2FudCB0byBtYWtlIHBhcnQgb2YgdGhlIHB1YmxpYyBBUEkgb2YgdGhpcyBtb2R1bGVcblxuZXhwb3J0IGZ1bmN0aW9uIHJlbmRlclJlcG9ydEdyb3VwQXJuKHNjb3BlOiBDb25zdHJ1Y3QsIHJlcG9ydEdyb3VwTmFtZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgcmV0dXJuIGNkay5TdGFjay5vZihzY29wZSkuZm9ybWF0QXJuKHJlcG9ydEdyb3VwQXJuQ29tcG9uZW50cyhyZXBvcnRHcm91cE5hbWUpKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHJlcG9ydEdyb3VwQXJuQ29tcG9uZW50cyhyZXBvcnRHcm91cE5hbWU6IHN0cmluZyk6IGNkay5Bcm5Db21wb25lbnRzIHtcbiAgcmV0dXJuIHtcbiAgICBzZXJ2aWNlOiAnY29kZWJ1aWxkJyxcbiAgICByZXNvdXJjZTogJ3JlcG9ydC1ncm91cCcsXG4gICAgcmVzb3VyY2VOYW1lOiByZXBvcnRHcm91cE5hbWUsXG4gIH07XG59XG4iXX0=