"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystemLocation = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * FileSystemLocation provider definition for a CodeBuild Project.
 */
class FileSystemLocation {
    /**
     * EFS file system provider.
     * @param props the EFS File System location property.
     */
    static efs(props) {
        jsiiDeprecationWarnings.monocdk_aws_codebuild_EfsFileSystemLocationProps(props);
        return new EfsFileSystemLocation(props);
    }
}
exports.FileSystemLocation = FileSystemLocation;
_a = JSII_RTTI_SYMBOL_1;
FileSystemLocation[_a] = { fqn: "monocdk.aws_codebuild.FileSystemLocation", version: "1.149.0" };
/**
 * EfsFileSystemLocation definition for a CodeBuild project.
 */
class EfsFileSystemLocation {
    constructor(props) {
        this.props = props;
    }
    bind(_scope, _project) {
        return {
            location: {
                identifier: this.props.identifier,
                location: this.props.location,
                mountOptions: this.props.mountOptions,
                mountPoint: this.props.mountPoint,
                type: 'EFS',
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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