"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Artifacts = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Artifacts definition for a CodeBuild Project.
 */
class Artifacts {
    constructor(props) {
        jsiiDeprecationWarnings.monocdk_aws_codebuild_ArtifactsProps(props);
        this.identifier = props.identifier;
    }
    static s3(props) {
        jsiiDeprecationWarnings.monocdk_aws_codebuild_S3ArtifactsProps(props);
        return new S3Artifacts(props);
    }
    bind(_scope, _project) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_codebuild_IProject(_project);
        return {
            artifactsProperty: {
                artifactIdentifier: this.identifier,
                type: this.type,
            },
        };
    }
}
exports.Artifacts = Artifacts;
_a = JSII_RTTI_SYMBOL_1;
Artifacts[_a] = { fqn: "monocdk.aws_codebuild.Artifacts", version: "1.149.0" };
/**
 * S3 Artifact definition for a CodeBuild Project.
 */
class S3Artifacts extends Artifacts {
    constructor(props) {
        super(props);
        this.props = props;
        this.type = 'S3';
    }
    bind(_scope, project) {
        this.props.bucket.grantReadWrite(project);
        const superConfig = super.bind(_scope, project);
        return {
            artifactsProperty: {
                ...superConfig.artifactsProperty,
                location: this.props.bucket.bucketName,
                path: this.props.path,
                namespaceType: this.props.includeBuildId === false ? 'NONE' : 'BUILD_ID',
                name: this.props.name == null ? undefined : this.props.name,
                packaging: this.props.packageZip === false ? 'NONE' : 'ZIP',
                encryptionDisabled: this.props.encryption === false ? true : undefined,
                overrideArtifactName: this.props.name == null ? true : undefined,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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