"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Unit = exports.Statistic = void 0;
/**
 * Statistic to use over the aggregation period
 */
var Statistic;
(function (Statistic) {
    /**
     * The count (number) of data points used for the statistical calculation.
     */
    Statistic["SAMPLE_COUNT"] = "SampleCount";
    /**
     * The value of Sum / SampleCount during the specified period.
     */
    Statistic["AVERAGE"] = "Average";
    /**
     * All values submitted for the matching metric added together.
     * This statistic can be useful for determining the total volume of a metric.
     */
    Statistic["SUM"] = "Sum";
    /**
     * The lowest value observed during the specified period.
     * You can use this value to determine low volumes of activity for your application.
     */
    Statistic["MINIMUM"] = "Minimum";
    /**
     * The highest value observed during the specified period.
     * You can use this value to determine high volumes of activity for your application.
     */
    Statistic["MAXIMUM"] = "Maximum";
})(Statistic = exports.Statistic || (exports.Statistic = {}));
/**
 * Unit for metric
 */
var Unit;
(function (Unit) {
    /**
     * Seconds
     */
    Unit["SECONDS"] = "Seconds";
    /**
     * Microseconds
     */
    Unit["MICROSECONDS"] = "Microseconds";
    /**
     * Milliseconds
     */
    Unit["MILLISECONDS"] = "Milliseconds";
    /**
     * Bytes
     */
    Unit["BYTES"] = "Bytes";
    /**
     * Kilobytes
     */
    Unit["KILOBYTES"] = "Kilobytes";
    /**
     * Megabytes
     */
    Unit["MEGABYTES"] = "Megabytes";
    /**
     * Gigabytes
     */
    Unit["GIGABYTES"] = "Gigabytes";
    /**
     * Terabytes
     */
    Unit["TERABYTES"] = "Terabytes";
    /**
     * Bits
     */
    Unit["BITS"] = "Bits";
    /**
     * Kilobits
     */
    Unit["KILOBITS"] = "Kilobits";
    /**
     * Megabits
     */
    Unit["MEGABITS"] = "Megabits";
    /**
     * Gigabits
     */
    Unit["GIGABITS"] = "Gigabits";
    /**
     * Terabits
     */
    Unit["TERABITS"] = "Terabits";
    /**
     * Percent
     */
    Unit["PERCENT"] = "Percent";
    /**
     * Count
     */
    Unit["COUNT"] = "Count";
    /**
     * Bytes/second (B/s)
     */
    Unit["BYTES_PER_SECOND"] = "Bytes/Second";
    /**
     * Kilobytes/second (kB/s)
     */
    Unit["KILOBYTES_PER_SECOND"] = "Kilobytes/Second";
    /**
     * Megabytes/second (MB/s)
     */
    Unit["MEGABYTES_PER_SECOND"] = "Megabytes/Second";
    /**
     * Gigabytes/second (GB/s)
     */
    Unit["GIGABYTES_PER_SECOND"] = "Gigabytes/Second";
    /**
     * Terabytes/second (TB/s)
     */
    Unit["TERABYTES_PER_SECOND"] = "Terabytes/Second";
    /**
     * Bits/second (b/s)
     */
    Unit["BITS_PER_SECOND"] = "Bits/Second";
    /**
     * Kilobits/second (kb/s)
     */
    Unit["KILOBITS_PER_SECOND"] = "Kilobits/Second";
    /**
     * Megabits/second (Mb/s)
     */
    Unit["MEGABITS_PER_SECOND"] = "Megabits/Second";
    /**
     * Gigabits/second (Gb/s)
     */
    Unit["GIGABITS_PER_SECOND"] = "Gigabits/Second";
    /**
     * Terabits/second (Tb/s)
     */
    Unit["TERABITS_PER_SECOND"] = "Terabits/Second";
    /**
     * Count/second
     */
    Unit["COUNT_PER_SECOND"] = "Count/Second";
    /**
     * No unit
     */
    Unit["NONE"] = "None";
})(Unit = exports.Unit || (exports.Unit = {}));
//# sourceMappingURL=data:application/json;base64,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