"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an SNS topic as an alarm action
 */
class SnsAction {
    constructor(topic) {
        this.topic = topic;
        jsiiDeprecationWarnings.monocdk_aws_sns_ITopic(topic);
    }
    /**
     * Returns an alarm action configuration to use an SNS topic as an alarm action
     */
    bind(_scope, _alarm) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(_alarm);
        return { alarmActionArn: this.topic.topicArn };
    }
}
exports.SnsAction = SnsAction;
_a = JSII_RTTI_SYMBOL_1;
SnsAction[_a] = { fqn: "monocdk.aws_cloudwatch_actions.SnsAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUlBOztHQUVHO0FBQ0gsTUFBYSxTQUFTO0lBQ3BCLFlBQTZCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7O0tBQzdDO0lBRUQ7O09BRUc7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxNQUF5Qjs7O1FBQ3RELE9BQU8sRUFBRSxjQUFjLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztLQUNoRDs7QUFUSCw4QkFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNsb3Vkd2F0Y2ggZnJvbSAnLi4vLi4vYXdzLWNsb3Vkd2F0Y2gnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJy4uLy4uL2F3cy1zbnMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnLi4vLi4vY29yZSc7XG5cbi8qKlxuICogVXNlIGFuIFNOUyB0b3BpYyBhcyBhbiBhbGFybSBhY3Rpb25cbiAqL1xuZXhwb3J0IGNsYXNzIFNuc0FjdGlvbiBpbXBsZW1lbnRzIGNsb3Vkd2F0Y2guSUFsYXJtQWN0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYW4gYWxhcm0gYWN0aW9uIGNvbmZpZ3VyYXRpb24gdG8gdXNlIGFuIFNOUyB0b3BpYyBhcyBhbiBhbGFybSBhY3Rpb25cbiAgICovXG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBfYWxhcm06IGNsb3Vkd2F0Y2guSUFsYXJtKTogY2xvdWR3YXRjaC5BbGFybUFjdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHsgYWxhcm1BY3Rpb25Bcm46IHRoaXMudG9waWMudG9waWNBcm4gfTtcbiAgfVxufVxuIl19