"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2Action = exports.Ec2InstanceAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Types of EC2 actions available
 */
var Ec2InstanceAction;
(function (Ec2InstanceAction) {
    /**
     * Stop the instance
     */
    Ec2InstanceAction["STOP"] = "stop";
    /**
     * Terminatethe instance
     */
    Ec2InstanceAction["TERMINATE"] = "terminate";
    /**
     * Recover the instance
     */
    Ec2InstanceAction["RECOVER"] = "recover";
    /**
     * Reboot the instance
     */
    Ec2InstanceAction["REBOOT"] = "reboot";
})(Ec2InstanceAction = exports.Ec2InstanceAction || (exports.Ec2InstanceAction = {}));
/**
 * Use an EC2 action as an Alarm action
 */
class Ec2Action {
    constructor(instanceAction) {
        jsiiDeprecationWarnings.monocdk_aws_cloudwatch_actions_Ec2InstanceAction(instanceAction);
        this.ec2Action = instanceAction;
    }
    /**
     * Returns an alarm action configuration to use an EC2 action as an alarm action
     */
    bind(_scope, _alarm) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(_alarm);
        return { alarmActionArn: `arn:aws:automate:${core_1.Stack.of(_scope).region}:ec2:${this.ec2Action}` };
    }
}
exports.Ec2Action = Ec2Action;
_a = JSII_RTTI_SYMBOL_1;
Ec2Action[_a] = { fqn: "monocdk.aws_cloudwatch_actions.Ec2Action", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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