"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an AutoScaling StepScalingAction as an Alarm Action
 */
class AutoScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_StepScalingAction(stepScalingAction);
    }
    /**
     * Returns an alarm action configuration to use an AutoScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(_alarm);
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
exports.AutoScalingAction = AutoScalingAction;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingAction[_a] = { fqn: "monocdk.aws_cloudwatch_actions.AutoScalingAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0b3NjYWxpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhdXRvc2NhbGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFPQTs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQzVCLFlBQTZCLGlCQUFnRDtRQUFoRCxzQkFBaUIsR0FBakIsaUJBQWlCLENBQStCOztLQUM1RTtJQUVEOzs7T0FHRztJQUNJLElBQUksQ0FBQyxNQUFpQixFQUFFLE1BQXlCOzs7UUFDdEQsT0FBTyxFQUFFLGNBQWMsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztLQUNwRTs7QUFWSCw4Q0FXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGF1dG9zY2FsaW5nIGZyb20gJy4uLy4uL2F3cy1hdXRvc2NhbGluZyc7XG5pbXBvcnQgKiBhcyBjbG91ZHdhdGNoIGZyb20gJy4uLy4uL2F3cy1jbG91ZHdhdGNoJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJy4uLy4uL2NvcmUnO1xuXG4vKipcbiAqIFVzZSBhbiBBdXRvU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvbiBhcyBhbiBBbGFybSBBY3Rpb25cbiAqL1xuZXhwb3J0IGNsYXNzIEF1dG9TY2FsaW5nQWN0aW9uIGltcGxlbWVudHMgY2xvdWR3YXRjaC5JQWxhcm1BY3Rpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHN0ZXBTY2FsaW5nQWN0aW9uOiBhdXRvc2NhbGluZy5TdGVwU2NhbGluZ0FjdGlvbikge1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYW4gYWxhcm0gYWN0aW9uIGNvbmZpZ3VyYXRpb24gdG8gdXNlIGFuIEF1dG9TY2FsaW5nIFN0ZXBTY2FsaW5nQWN0aW9uXG4gICAqIGFzIGFuIGFsYXJtIGFjdGlvblxuICAgKi9cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIF9hbGFybTogY2xvdWR3YXRjaC5JQWxhcm0pOiBjbG91ZHdhdGNoLkFsYXJtQWN0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4geyBhbGFybUFjdGlvbkFybjogdGhpcy5zdGVwU2NhbGluZ0FjdGlvbi5zY2FsaW5nUG9saWN5QXJuIH07XG4gIH1cbn1cbiJdfQ==