"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationScalingAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an ApplicationAutoScaling StepScalingAction as an Alarm Action
 */
class ApplicationScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_StepScalingAction(stepScalingAction);
    }
    /**
     * Returns an alarm action configuration to use an ApplicationScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(_alarm);
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
exports.ApplicationScalingAction = ApplicationScalingAction;
_a = JSII_RTTI_SYMBOL_1;
ApplicationScalingAction[_a] = { fqn: "monocdk.aws_cloudwatch_actions.ApplicationScalingAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwc2NhbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcHNjYWxpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBT0E7O0dBRUc7QUFDSCxNQUFhLHdCQUF3QjtJQUNuQyxZQUE2QixpQkFBK0M7UUFBL0Msc0JBQWlCLEdBQWpCLGlCQUFpQixDQUE4Qjs7S0FDM0U7SUFFRDs7O09BR0c7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxNQUF5Qjs7O1FBQ3RELE9BQU8sRUFBRSxjQUFjLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLENBQUM7S0FDcEU7O0FBVkgsNERBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhcHBzY2FsaW5nIGZyb20gJy4uLy4uL2F3cy1hcHBsaWNhdGlvbmF1dG9zY2FsaW5nJztcbmltcG9ydCAqIGFzIGNsb3Vkd2F0Y2ggZnJvbSAnLi4vLi4vYXdzLWNsb3Vkd2F0Y2gnO1xuXG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnLi4vLi4vY29yZSc7XG5cbi8qKlxuICogVXNlIGFuIEFwcGxpY2F0aW9uQXV0b1NjYWxpbmcgU3RlcFNjYWxpbmdBY3Rpb24gYXMgYW4gQWxhcm0gQWN0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBBcHBsaWNhdGlvblNjYWxpbmdBY3Rpb24gaW1wbGVtZW50cyBjbG91ZHdhdGNoLklBbGFybUFjdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc3RlcFNjYWxpbmdBY3Rpb246IGFwcHNjYWxpbmcuU3RlcFNjYWxpbmdBY3Rpb24pIHtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGFuIGFsYXJtIGFjdGlvbiBjb25maWd1cmF0aW9uIHRvIHVzZSBhbiBBcHBsaWNhdGlvblNjYWxpbmcgU3RlcFNjYWxpbmdBY3Rpb25cbiAgICogYXMgYW4gYWxhcm0gYWN0aW9uXG4gICAqL1xuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgX2FsYXJtOiBjbG91ZHdhdGNoLklBbGFybSk6IGNsb3Vkd2F0Y2guQWxhcm1BY3Rpb25Db25maWcge1xuICAgIHJldHVybiB7IGFsYXJtQWN0aW9uQXJuOiB0aGlzLnN0ZXBTY2FsaW5nQWN0aW9uLnNjYWxpbmdQb2xpY3lBcm4gfTtcbiAgfVxufVxuIl19