"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam");
const lambda = require("../../aws-lambda");
const s3 = require("../../aws-s3");
const cdk = require("../../core");
const cloudtrail = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-cloudtrail');
const bucket = new s3.Bucket(stack, 'Bucket', { removalPolicy: cdk.RemovalPolicy.DESTROY });
const lambdaFunction = new lambda.Function(stack, 'LambdaFunction', {
    runtime: lambda.Runtime.NODEJS_10_X,
    handler: 'hello.handler',
    code: lambda.Code.fromInline('exports.handler = {}'),
});
// using exctecy the same code as inside the cloudtrail class to produce the supplied bucket and policy
const cloudTrailPrincipal = new iam.ServicePrincipal('cloudtrail.amazonaws.com');
const Trailbucket = new s3.Bucket(stack, 'S3', { encryption: s3.BucketEncryption.UNENCRYPTED });
Trailbucket.addToResourcePolicy(new iam.PolicyStatement({
    resources: [Trailbucket.bucketArn],
    actions: ['s3:GetBucketAcl'],
    principals: [cloudTrailPrincipal],
}));
Trailbucket.addToResourcePolicy(new iam.PolicyStatement({
    resources: [Trailbucket.arnForObjects(`AWSLogs/${cdk.Stack.of(stack).account}/*`)],
    actions: ['s3:PutObject'],
    principals: [cloudTrailPrincipal],
    conditions: {
        StringEquals: { 's3:x-amz-acl': 'bucket-owner-full-control' },
    },
}));
const trail = new cloudtrail.Trail(stack, 'Trail', { bucket: Trailbucket });
trail.addLambdaEventSelector([lambdaFunction]);
trail.addS3EventSelector([{ bucket }]);
app.synth();
//# sourceMappingURL=data:application/json;base64,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