"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloneRepository = exports.Ec2Environment = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const cdk = require("../../core");
const cloud9_generated_1 = require("../lib/cloud9.generated");
/**
 * A Cloud9 Environment with Amazon EC2
 * @resource AWS::Cloud9::EnvironmentEC2
 */
class Ec2Environment extends cdk.Resource {
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_cloud9_Ec2EnvironmentProps(props);
        this.vpc = props.vpc;
        if (!props.subnetSelection && this.vpc.publicSubnets.length === 0) {
            throw new Error('no subnetSelection specified and no public subnet found in the vpc, please specify subnetSelection');
        }
        const vpcSubnets = (_c = props.subnetSelection) !== null && _c !== void 0 ? _c : { subnetType: ec2.SubnetType.PUBLIC };
        const c9env = new cloud9_generated_1.CfnEnvironmentEC2(this, 'Resource', {
            name: props.ec2EnvironmentName,
            description: props.description,
            instanceType: (_e = (_d = props.instanceType) === null || _d === void 0 ? void 0 : _d.toString()) !== null && _e !== void 0 ? _e : ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE2, ec2.InstanceSize.MICRO).toString(),
            subnetId: this.vpc.selectSubnets(vpcSubnets).subnetIds[0],
            repositories: props.clonedRepositories ? props.clonedRepositories.map(r => ({
                repositoryUrl: r.repositoryUrl,
                pathComponent: r.pathComponent,
            })) : undefined,
        });
        this.environmentId = c9env.ref;
        this.ec2EnvironmentArn = c9env.getAtt('Arn').toString();
        this.ec2EnvironmentName = c9env.getAtt('Name').toString();
        this.ideUrl = `https://${this.stack.region}.console.aws.amazon.com/cloud9/ide/${this.environmentId}`;
    }
    /**
     * import from EnvironmentEc2Name
     */
    static fromEc2EnvironmentName(scope, id, ec2EnvironmentName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.ec2EnvironmentName = ec2EnvironmentName;
                this.ec2EnvironmentArn = cdk.Stack.of(this).formatArn({
                    service: 'cloud9',
                    resource: 'environment',
                    resourceName: this.ec2EnvironmentName,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.Ec2Environment = Ec2Environment;
_a = JSII_RTTI_SYMBOL_1;
Ec2Environment[_a] = { fqn: "monocdk.aws_cloud9.Ec2Environment", version: "1.149.0" };
/**
 * The class for different repository providers
 */
class CloneRepository {
    constructor(repositoryUrl, pathComponent) {
        this.repositoryUrl = repositoryUrl;
        this.pathComponent = pathComponent;
    }
    /**
     * import repository to cloud9 environment from AWS CodeCommit
     *
     * @param repository the codecommit repository to clone from
     * @param path  the target path in cloud9 environment
     */
    static fromCodeCommit(repository, path) {
        jsiiDeprecationWarnings.monocdk_aws_codecommit_IRepository(repository);
        return {
            repositoryUrl: repository.repositoryCloneUrlHttp,
            pathComponent: path,
        };
    }
}
exports.CloneRepository = CloneRepository;
_b = JSII_RTTI_SYMBOL_1;
CloneRepository[_b] = { fqn: "monocdk.aws_cloud9.CloneRepository", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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