"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateCertificate = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const certificate_base_1 = require("./certificate-base");
const certificatemanager_generated_1 = require("./certificatemanager.generated");
/**
 * A private certificate managed by AWS Certificate Manager
 *
 * @resource AWS::CertificateManager::Certificate
 */
class PrivateCertificate extends certificate_base_1.CertificateBase {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_certificatemanager_PrivateCertificateProps(props);
        const cert = new certificatemanager_generated_1.CfnCertificate(this, 'Resource', {
            domainName: props.domainName,
            subjectAlternativeNames: props.subjectAlternativeNames,
            certificateAuthorityArn: props.certificateAuthority.certificateAuthorityArn,
        });
        this.certificateArn = cert.ref;
    }
    /**
     * Import a certificate
     */
    static fromCertificateArn(scope, id, certificateArn) {
        class Import extends certificate_base_1.CertificateBase {
            constructor() {
                super(...arguments);
                this.certificateArn = certificateArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.PrivateCertificate = PrivateCertificate;
_a = JSII_RTTI_SYMBOL_1;
PrivateCertificate[_a] = { fqn: "monocdk.aws_certificatemanager.PrivateCertificate", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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