"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateBase = void 0;
const cloudwatch = require("../../aws-cloudwatch");
const aws_cloudwatch_1 = require("../../aws-cloudwatch");
const core_1 = require("../../core");
/**
 * Shared implementation details of ICertificate implementations.
 *
 * @internal
 */
class CertificateBase extends core_1.Resource {
    metricDaysToExpiry(props) {
        return new cloudwatch.Metric({
            period: core_1.Duration.days(1),
            ...props,
            dimensionsMap: { CertificateArn: this.certificateArn },
            metricName: 'DaysToExpiry',
            namespace: 'AWS/CertificateManager',
            region: this.region,
            statistic: aws_cloudwatch_1.Statistic.MINIMUM,
        });
    }
}
exports.CertificateBase = CertificateBase;
//# sourceMappingURL=data:application/json;base64,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