"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTable = exports.CfnKeyspace = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:31:26.676Z","fingerprint":"CgqkchHtAvM/3KsC8qUsP7/pjUE8BP65emKR6x9J9U8="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnKeyspaceProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeyspaceProps`
 *
 * @returns the result of the validation.
 */
function CfnKeyspacePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('keyspaceName', cdk.validateString)(properties.keyspaceName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnKeyspaceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cassandra::Keyspace` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeyspaceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cassandra::Keyspace` resource.
 */
// @ts-ignore TS6133
function cfnKeyspacePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeyspacePropsValidator(properties).assertSuccess();
    return {
        KeyspaceName: cdk.stringToCloudFormation(properties.keyspaceName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnKeyspacePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyspaceName', 'KeyspaceName', properties.KeyspaceName != null ? cfn_parse.FromCloudFormation.getString(properties.KeyspaceName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cassandra::Keyspace`
 *
 * The `AWS::Cassandra::Keyspace` resource allows you to create a new keyspace in Amazon Keyspaces (for Apache Cassandra). For more information, see [Create a keyspace and a table](https://docs.aws.amazon.com/keyspaces/latest/devguide/getting-started.ddl.html) in the *Amazon Keyspaces Developer Guide* .
 *
 * @cloudformationResource AWS::Cassandra::Keyspace
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html
 */
class CfnKeyspace extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cassandra::Keyspace`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnKeyspace.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_cassandra_CfnKeyspaceProps(props);
        this.keyspaceName = props.keyspaceName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Cassandra::Keyspace", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeyspacePropsFromCloudFormation(resourceProperties);
        const ret = new CfnKeyspace(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKeyspace.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyspaceName: this.keyspaceName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnKeyspacePropsToCloudFormation(props);
    }
}
exports.CfnKeyspace = CfnKeyspace;
_a = JSII_RTTI_SYMBOL_1;
CfnKeyspace[_a] = { fqn: "monocdk.aws_cassandra.CfnKeyspace", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKeyspace.CFN_RESOURCE_TYPE_NAME = "AWS::Cassandra::Keyspace";
/**
 * Determine whether the given properties match those of a `CfnTableProps`
 *
 * @param properties - the TypeScript properties of a `CfnTableProps`
 *
 * @returns the result of the validation.
 */
function CfnTablePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('billingMode', CfnTable_BillingModePropertyValidator)(properties.billingMode));
    errors.collect(cdk.propertyValidator('clusteringKeyColumns', cdk.listValidator(CfnTable_ClusteringKeyColumnPropertyValidator))(properties.clusteringKeyColumns));
    errors.collect(cdk.propertyValidator('defaultTimeToLive', cdk.validateNumber)(properties.defaultTimeToLive));
    errors.collect(cdk.propertyValidator('encryptionSpecification', CfnTable_EncryptionSpecificationPropertyValidator)(properties.encryptionSpecification));
    errors.collect(cdk.propertyValidator('keyspaceName', cdk.requiredValidator)(properties.keyspaceName));
    errors.collect(cdk.propertyValidator('keyspaceName', cdk.validateString)(properties.keyspaceName));
    errors.collect(cdk.propertyValidator('partitionKeyColumns', cdk.requiredValidator)(properties.partitionKeyColumns));
    errors.collect(cdk.propertyValidator('partitionKeyColumns', cdk.listValidator(CfnTable_ColumnPropertyValidator))(properties.partitionKeyColumns));
    errors.collect(cdk.propertyValidator('pointInTimeRecoveryEnabled', cdk.validateBoolean)(properties.pointInTimeRecoveryEnabled));
    errors.collect(cdk.propertyValidator('regularColumns', cdk.listValidator(CfnTable_ColumnPropertyValidator))(properties.regularColumns));
    errors.collect(cdk.propertyValidator('tableName', cdk.validateString)(properties.tableName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnTableProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cassandra::Table` resource
 *
 * @param properties - the TypeScript properties of a `CfnTableProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cassandra::Table` resource.
 */
// @ts-ignore TS6133
function cfnTablePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTablePropsValidator(properties).assertSuccess();
    return {
        KeyspaceName: cdk.stringToCloudFormation(properties.keyspaceName),
        PartitionKeyColumns: cdk.listMapper(cfnTableColumnPropertyToCloudFormation)(properties.partitionKeyColumns),
        BillingMode: cfnTableBillingModePropertyToCloudFormation(properties.billingMode),
        ClusteringKeyColumns: cdk.listMapper(cfnTableClusteringKeyColumnPropertyToCloudFormation)(properties.clusteringKeyColumns),
        DefaultTimeToLive: cdk.numberToCloudFormation(properties.defaultTimeToLive),
        EncryptionSpecification: cfnTableEncryptionSpecificationPropertyToCloudFormation(properties.encryptionSpecification),
        PointInTimeRecoveryEnabled: cdk.booleanToCloudFormation(properties.pointInTimeRecoveryEnabled),
        RegularColumns: cdk.listMapper(cfnTableColumnPropertyToCloudFormation)(properties.regularColumns),
        TableName: cdk.stringToCloudFormation(properties.tableName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnTablePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyspaceName', 'KeyspaceName', cfn_parse.FromCloudFormation.getString(properties.KeyspaceName));
    ret.addPropertyResult('partitionKeyColumns', 'PartitionKeyColumns', cfn_parse.FromCloudFormation.getArray(CfnTableColumnPropertyFromCloudFormation)(properties.PartitionKeyColumns));
    ret.addPropertyResult('billingMode', 'BillingMode', properties.BillingMode != null ? CfnTableBillingModePropertyFromCloudFormation(properties.BillingMode) : undefined);
    ret.addPropertyResult('clusteringKeyColumns', 'ClusteringKeyColumns', properties.ClusteringKeyColumns != null ? cfn_parse.FromCloudFormation.getArray(CfnTableClusteringKeyColumnPropertyFromCloudFormation)(properties.ClusteringKeyColumns) : undefined);
    ret.addPropertyResult('defaultTimeToLive', 'DefaultTimeToLive', properties.DefaultTimeToLive != null ? cfn_parse.FromCloudFormation.getNumber(properties.DefaultTimeToLive) : undefined);
    ret.addPropertyResult('encryptionSpecification', 'EncryptionSpecification', properties.EncryptionSpecification != null ? CfnTableEncryptionSpecificationPropertyFromCloudFormation(properties.EncryptionSpecification) : undefined);
    ret.addPropertyResult('pointInTimeRecoveryEnabled', 'PointInTimeRecoveryEnabled', properties.PointInTimeRecoveryEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PointInTimeRecoveryEnabled) : undefined);
    ret.addPropertyResult('regularColumns', 'RegularColumns', properties.RegularColumns != null ? cfn_parse.FromCloudFormation.getArray(CfnTableColumnPropertyFromCloudFormation)(properties.RegularColumns) : undefined);
    ret.addPropertyResult('tableName', 'TableName', properties.TableName != null ? cfn_parse.FromCloudFormation.getString(properties.TableName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cassandra::Table`
 *
 * The `AWS::Cassandra::Table` resource allows you to create a new table in Amazon Keyspaces (for Apache Cassandra). For more information, see [Create a keyspace and a table](https://docs.aws.amazon.com/keyspaces/latest/devguide/getting-started.ddl.html) in the *Amazon Keyspaces Developer Guide* .
 *
 * @cloudformationResource AWS::Cassandra::Table
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html
 */
class CfnTable extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cassandra::Table`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTable.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_cassandra_CfnTableProps(props);
        cdk.requireProperty(props, 'keyspaceName', this);
        cdk.requireProperty(props, 'partitionKeyColumns', this);
        this.keyspaceName = props.keyspaceName;
        this.partitionKeyColumns = props.partitionKeyColumns;
        this.billingMode = props.billingMode;
        this.clusteringKeyColumns = props.clusteringKeyColumns;
        this.defaultTimeToLive = props.defaultTimeToLive;
        this.encryptionSpecification = props.encryptionSpecification;
        this.pointInTimeRecoveryEnabled = props.pointInTimeRecoveryEnabled;
        this.regularColumns = props.regularColumns;
        this.tableName = props.tableName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Cassandra::Table", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTablePropsFromCloudFormation(resourceProperties);
        const ret = new CfnTable(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTable.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyspaceName: this.keyspaceName,
            partitionKeyColumns: this.partitionKeyColumns,
            billingMode: this.billingMode,
            clusteringKeyColumns: this.clusteringKeyColumns,
            defaultTimeToLive: this.defaultTimeToLive,
            encryptionSpecification: this.encryptionSpecification,
            pointInTimeRecoveryEnabled: this.pointInTimeRecoveryEnabled,
            regularColumns: this.regularColumns,
            tableName: this.tableName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnTablePropsToCloudFormation(props);
    }
}
exports.CfnTable = CfnTable;
_b = JSII_RTTI_SYMBOL_1;
CfnTable[_b] = { fqn: "monocdk.aws_cassandra.CfnTable", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTable.CFN_RESOURCE_TYPE_NAME = "AWS::Cassandra::Table";
/**
 * Determine whether the given properties match those of a `BillingModeProperty`
 *
 * @param properties - the TypeScript properties of a `BillingModeProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_BillingModePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mode', cdk.requiredValidator)(properties.mode));
    errors.collect(cdk.propertyValidator('mode', cdk.validateString)(properties.mode));
    errors.collect(cdk.propertyValidator('provisionedThroughput', CfnTable_ProvisionedThroughputPropertyValidator)(properties.provisionedThroughput));
    return errors.wrap('supplied properties not correct for "BillingModeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cassandra::Table.BillingMode` resource
 *
 * @param properties - the TypeScript properties of a `BillingModeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cassandra::Table.BillingMode` resource.
 */
// @ts-ignore TS6133
function cfnTableBillingModePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_BillingModePropertyValidator(properties).assertSuccess();
    return {
        Mode: cdk.stringToCloudFormation(properties.mode),
        ProvisionedThroughput: cfnTableProvisionedThroughputPropertyToCloudFormation(properties.provisionedThroughput),
    };
}
// @ts-ignore TS6133
function CfnTableBillingModePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mode', 'Mode', cfn_parse.FromCloudFormation.getString(properties.Mode));
    ret.addPropertyResult('provisionedThroughput', 'ProvisionedThroughput', properties.ProvisionedThroughput != null ? CfnTableProvisionedThroughputPropertyFromCloudFormation(properties.ProvisionedThroughput) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusteringKeyColumnProperty`
 *
 * @param properties - the TypeScript properties of a `ClusteringKeyColumnProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_ClusteringKeyColumnPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('column', cdk.requiredValidator)(properties.column));
    errors.collect(cdk.propertyValidator('column', CfnTable_ColumnPropertyValidator)(properties.column));
    errors.collect(cdk.propertyValidator('orderBy', cdk.validateString)(properties.orderBy));
    return errors.wrap('supplied properties not correct for "ClusteringKeyColumnProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cassandra::Table.ClusteringKeyColumn` resource
 *
 * @param properties - the TypeScript properties of a `ClusteringKeyColumnProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cassandra::Table.ClusteringKeyColumn` resource.
 */
// @ts-ignore TS6133
function cfnTableClusteringKeyColumnPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_ClusteringKeyColumnPropertyValidator(properties).assertSuccess();
    return {
        Column: cfnTableColumnPropertyToCloudFormation(properties.column),
        OrderBy: cdk.stringToCloudFormation(properties.orderBy),
    };
}
// @ts-ignore TS6133
function CfnTableClusteringKeyColumnPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('column', 'Column', CfnTableColumnPropertyFromCloudFormation(properties.Column));
    ret.addPropertyResult('orderBy', 'OrderBy', properties.OrderBy != null ? cfn_parse.FromCloudFormation.getString(properties.OrderBy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ColumnProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_ColumnPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('columnName', cdk.requiredValidator)(properties.columnName));
    errors.collect(cdk.propertyValidator('columnName', cdk.validateString)(properties.columnName));
    errors.collect(cdk.propertyValidator('columnType', cdk.requiredValidator)(properties.columnType));
    errors.collect(cdk.propertyValidator('columnType', cdk.validateString)(properties.columnType));
    return errors.wrap('supplied properties not correct for "ColumnProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cassandra::Table.Column` resource
 *
 * @param properties - the TypeScript properties of a `ColumnProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cassandra::Table.Column` resource.
 */
// @ts-ignore TS6133
function cfnTableColumnPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_ColumnPropertyValidator(properties).assertSuccess();
    return {
        ColumnName: cdk.stringToCloudFormation(properties.columnName),
        ColumnType: cdk.stringToCloudFormation(properties.columnType),
    };
}
// @ts-ignore TS6133
function CfnTableColumnPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('columnName', 'ColumnName', cfn_parse.FromCloudFormation.getString(properties.ColumnName));
    ret.addPropertyResult('columnType', 'ColumnType', cfn_parse.FromCloudFormation.getString(properties.ColumnType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EncryptionSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `EncryptionSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_EncryptionSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('encryptionType', cdk.requiredValidator)(properties.encryptionType));
    errors.collect(cdk.propertyValidator('encryptionType', cdk.validateString)(properties.encryptionType));
    errors.collect(cdk.propertyValidator('kmsKeyIdentifier', cdk.validateString)(properties.kmsKeyIdentifier));
    return errors.wrap('supplied properties not correct for "EncryptionSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cassandra::Table.EncryptionSpecification` resource
 *
 * @param properties - the TypeScript properties of a `EncryptionSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cassandra::Table.EncryptionSpecification` resource.
 */
// @ts-ignore TS6133
function cfnTableEncryptionSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_EncryptionSpecificationPropertyValidator(properties).assertSuccess();
    return {
        EncryptionType: cdk.stringToCloudFormation(properties.encryptionType),
        KmsKeyIdentifier: cdk.stringToCloudFormation(properties.kmsKeyIdentifier),
    };
}
// @ts-ignore TS6133
function CfnTableEncryptionSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('encryptionType', 'EncryptionType', cfn_parse.FromCloudFormation.getString(properties.EncryptionType));
    ret.addPropertyResult('kmsKeyIdentifier', 'KmsKeyIdentifier', properties.KmsKeyIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyIdentifier) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProvisionedThroughputProperty`
 *
 * @param properties - the TypeScript properties of a `ProvisionedThroughputProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_ProvisionedThroughputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('readCapacityUnits', cdk.requiredValidator)(properties.readCapacityUnits));
    errors.collect(cdk.propertyValidator('readCapacityUnits', cdk.validateNumber)(properties.readCapacityUnits));
    errors.collect(cdk.propertyValidator('writeCapacityUnits', cdk.requiredValidator)(properties.writeCapacityUnits));
    errors.collect(cdk.propertyValidator('writeCapacityUnits', cdk.validateNumber)(properties.writeCapacityUnits));
    return errors.wrap('supplied properties not correct for "ProvisionedThroughputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cassandra::Table.ProvisionedThroughput` resource
 *
 * @param properties - the TypeScript properties of a `ProvisionedThroughputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cassandra::Table.ProvisionedThroughput` resource.
 */
// @ts-ignore TS6133
function cfnTableProvisionedThroughputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_ProvisionedThroughputPropertyValidator(properties).assertSuccess();
    return {
        ReadCapacityUnits: cdk.numberToCloudFormation(properties.readCapacityUnits),
        WriteCapacityUnits: cdk.numberToCloudFormation(properties.writeCapacityUnits),
    };
}
// @ts-ignore TS6133
function CfnTableProvisionedThroughputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('readCapacityUnits', 'ReadCapacityUnits', cfn_parse.FromCloudFormation.getNumber(properties.ReadCapacityUnits));
    ret.addPropertyResult('writeCapacityUnits', 'WriteCapacityUnits', cfn_parse.FromCloudFormation.getNumber(properties.WriteCapacityUnits));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2Fzc2FuZHJhLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNhc3NhbmRyYS5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsK0VBQStFO0FBQy9FLCtEQUErRDtBQUMvRCw4RkFBOEY7QUFDOUYsc0hBQXNIO0FBRXRILDRCQUE0QixDQUFDLGlFQUFpRTtBQUU5RixrQ0FBa0M7QUFDbEMsc0RBQXNEO0FBK0J0RDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHlCQUF5QixDQUFDLFVBQWU7SUFDOUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHdEQUF3RCxDQUFDLENBQUM7QUFDakYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdDQUFnQyxDQUFDLFVBQWU7SUFDckQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHlCQUF5QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3RELE9BQU87UUFDSCxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLGtDQUFrQyxDQUFDLFVBQWU7SUFDdkQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBb0IsQ0FBQztJQUMvRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSxVQUFVLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBYSxXQUFZLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUEyQzVDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsUUFBMEIsRUFBRTtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxXQUFXLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7OztRQUVsRixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQzdIO0lBakREOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyxrQ0FBa0MsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzNFLE1BQU0sR0FBRyxHQUFHLElBQUksV0FBVyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzFELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQWtDRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0Qjs7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxXQUFXLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUMxRixTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtTQUMvQixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLGdDQUFnQyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ2xEOztBQTdFTCxrQ0E4RUM7OztBQTdFRzs7R0FFRztBQUNvQixrQ0FBc0IsR0FBRywwQkFBMEIsQ0FBQztBQW1ML0U7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzQkFBc0IsQ0FBQyxVQUFlO0lBQzNDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUscUNBQXFDLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLDZDQUE2QyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ2pLLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLGlEQUFpRCxDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQztJQUN4SixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ3BILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsZ0NBQWdDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDbEosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNEJBQTRCLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDeEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMscURBQXFELENBQUMsQ0FBQztBQUM5RSxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNkJBQTZCLENBQUMsVUFBZTtJQUNsRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsc0JBQXNCLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbkQsT0FBTztRQUNILFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxtQkFBbUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLHNDQUFzQyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQzNHLFdBQVcsRUFBRSwyQ0FBMkMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQ2hGLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsbURBQW1ELENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDMUgsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRSx1QkFBdUIsRUFBRSx1REFBdUQsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUM7UUFDcEgsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQztRQUM5RixjQUFjLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDakcsU0FBUyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNELElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrQkFBK0IsQ0FBQyxVQUFlO0lBQ3BELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWlCLENBQUM7SUFDNUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUN2SCxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUscUJBQXFCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDckwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsVUFBVSxDQUFDLFdBQVcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLDZDQUE2QyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDeEssR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFVBQVUsQ0FBQyxvQkFBb0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMscURBQXFELENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDM1AsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSx5QkFBeUIsRUFBRSxVQUFVLENBQUMsdUJBQXVCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyx5REFBeUQsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDcE8sR0FBRyxDQUFDLGlCQUFpQixDQUFDLDRCQUE0QixFQUFFLDRCQUE0QixFQUFFLFVBQVUsQ0FBQywwQkFBMEIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdE4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsVUFBVSxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SixHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEsUUFBUyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBcUh6Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQW9CO1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFFBQVEsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7O1FBQy9FLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNqRCxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxxQkFBcUIsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUV4RCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsdUJBQXVCLENBQUM7UUFDN0QsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQywwQkFBMEIsQ0FBQztRQUNuRSxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLHVCQUF1QixFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsRUFBRSxlQUFlLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUMxSDtJQXJJRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcsK0JBQStCLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN4RSxNQUFNLEdBQUcsR0FBRyxJQUFJLFFBQVEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN2RCxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUFzSEQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7O1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsUUFBUSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDdkYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QjtZQUNyRCwwQkFBMEIsRUFBRSxJQUFJLENBQUMsMEJBQTBCO1lBQzNELGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1NBQy9CLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sNkJBQTZCLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDL0M7O0FBektMLDRCQTBLQzs7O0FBektHOztHQUVHO0FBQ29CLCtCQUFzQixHQUFHLHVCQUF1QixDQUFDO0FBd001RTs7Ozs7O0dBTUc7QUFDSCxTQUFTLHFDQUFxQyxDQUFDLFVBQWU7SUFDMUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLCtDQUErQyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNsSixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsMkRBQTJELENBQUMsQ0FBQztBQUNwRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMkNBQTJDLENBQUMsVUFBZTtJQUNoRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQscUNBQXFDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbEUsT0FBTztRQUNILElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRCxxQkFBcUIsRUFBRSxxREFBcUQsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7S0FDakgsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFnQyxDQUFDO0lBQzNGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLHVCQUF1QixFQUFFLFVBQVUsQ0FBQyxxQkFBcUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHVEQUF1RCxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxTixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBOEJEOzs7Ozs7R0FNRztBQUNILFNBQVMsNkNBQTZDLENBQUMsVUFBZTtJQUNsRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzFGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxnQ0FBZ0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG1FQUFtRSxDQUFDLENBQUM7QUFDNUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLG1EQUFtRCxDQUFDLFVBQWU7SUFDeEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDZDQUE2QyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzFFLE9BQU87UUFDSCxNQUFNLEVBQUUsc0NBQXNDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUNqRSxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7S0FDMUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxxREFBcUQsQ0FBQyxVQUFlO0lBQzFFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUF3QyxDQUFDO0lBQ25HLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsUUFBUSxFQUFFLHdDQUF3QyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakosR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTJCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdDQUFnQyxDQUFDLFVBQWU7SUFDckQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNsRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNsRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO0FBQy9FLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxzQ0FBc0MsQ0FBQyxVQUFlO0lBQzNELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM3RCxPQUFPO1FBQ0gsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELFVBQVUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztLQUNoRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHdDQUF3QyxDQUFDLFVBQWU7SUFDN0QsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQTJCLENBQUM7SUFDdEYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNqSCxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2pILEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFrQ0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpREFBaUQsQ0FBQyxVQUFlO0lBQ3RFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUMxRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDdkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHVFQUF1RSxDQUFDLENBQUM7QUFDaEcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHVEQUF1RCxDQUFDLFVBQWU7SUFDNUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGlEQUFpRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzlFLE9BQU87UUFDSCxjQUFjLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztLQUM1RSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHlEQUF5RCxDQUFDLFVBQWU7SUFDOUUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQTRDLENBQUM7SUFDdkcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDN0gsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JMLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUywrQ0FBK0MsQ0FBQyxVQUFlO0lBQ3BFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDbEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDL0csT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHFFQUFxRSxDQUFDLENBQUM7QUFDOUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHFEQUFxRCxDQUFDLFVBQWU7SUFDMUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELCtDQUErQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzVFLE9BQU87UUFDSCxpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNFLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7S0FDaEYsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx1REFBdUQsQ0FBQyxVQUFlO0lBQzVFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEwQyxDQUFDO0lBQ3JHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDdEksR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUN6SSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTItMjAyMiBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG4vLyBTZWU6IGRvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tcmVzb3VyY2Utc3BlY2lmaWNhdGlvbi5odG1sXG4vLyBAY2ZuMnRzOm1ldGFAIHtcImdlbmVyYXRlZFwiOlwiMjAyMi0wMy0xN1QxMTozMToyNi42NzZaXCIsXCJmaW5nZXJwcmludFwiOlwiQ2dxa2NoSHRBdk0vM0tzQzhxVXNQNy9walVFOEJQNjVlbUtSNng5SjlVOD1cIn1cblxuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiAqLyAvLyBUaGlzIGlzIGdlbmVyYXRlZCBjb2RlIC0gbGluZSBsZW5ndGhzIGFyZSBkaWZmaWN1bHQgdG8gY29udHJvbFxuXG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgKiBhcyBjZm5fcGFyc2UgZnJvbSAnLi4vLi4vY29yZS9saWIvY2ZuLXBhcnNlJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5LZXlzcGFjZWBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLWtleXNwYWNlLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5LZXlzcGFjZVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBrZXlzcGFjZSB0byBiZSBjcmVhdGVkLiBUaGUga2V5c3BhY2UgbmFtZSBpcyBjYXNlIHNlbnNpdGl2ZS4gSWYgeW91IGRvbid0IHNwZWNpZnkgYSBuYW1lLCBBV1MgQ2xvdWRGb3JtYXRpb24gZ2VuZXJhdGVzIGEgdW5pcXVlIElEIGFuZCB1c2VzIHRoYXQgSUQgZm9yIHRoZSBrZXlzcGFjZSBuYW1lLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtOYW1lIHR5cGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLW5hbWUuaHRtbCkgLlxuICAgICAqXG4gICAgICogKkxlbmd0aCBjb25zdHJhaW50czoqIE1pbmltdW0gbGVuZ3RoIG9mIDMuIE1heGltdW0gbGVuZ3RoIG9mIDI1NS5cbiAgICAgKlxuICAgICAqICpQYXR0ZXJuOiogYF5bYS16QS1aMC05XVthLXpBLVowLTlfXXsxLDQ3fSRgXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jYXNzYW5kcmEta2V5c3BhY2UuaHRtbCNjZm4tY2Fzc2FuZHJhLWtleXNwYWNlLWtleXNwYWNlbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGtleXNwYWNlTmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBrZXktdmFsdWUgcGFpciB0YWdzIHRvIGJlIGF0dGFjaGVkIHRvIHRoZSByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS1rZXlzcGFjZS5odG1sI2Nmbi1jYXNzYW5kcmEta2V5c3BhY2UtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuS2V5c3BhY2VQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuS2V5c3BhY2VQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5LZXlzcGFjZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5c3BhY2VOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleXNwYWNlTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZUNmblRhZykpKHByb3BlcnRpZXMudGFncykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5LZXlzcGFjZVByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpDYXNzYW5kcmE6OktleXNwYWNlYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5LZXlzcGFjZVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpDYXNzYW5kcmE6OktleXNwYWNlYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbktleXNwYWNlUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbktleXNwYWNlUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEtleXNwYWNlTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5rZXlzcGFjZU5hbWUpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuS2V5c3BhY2VQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbktleXNwYWNlUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbktleXNwYWNlUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdrZXlzcGFjZU5hbWUnLCAnS2V5c3BhY2VOYW1lJywgcHJvcGVydGllcy5LZXlzcGFjZU5hbWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuS2V5c3BhY2VOYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRDZm5UYWcpKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkNhc3NhbmRyYTo6S2V5c3BhY2VgXG4gKlxuICogVGhlIGBBV1M6OkNhc3NhbmRyYTo6S2V5c3BhY2VgIHJlc291cmNlIGFsbG93cyB5b3UgdG8gY3JlYXRlIGEgbmV3IGtleXNwYWNlIGluIEFtYXpvbiBLZXlzcGFjZXMgKGZvciBBcGFjaGUgQ2Fzc2FuZHJhKS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ3JlYXRlIGEga2V5c3BhY2UgYW5kIGEgdGFibGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rZXlzcGFjZXMvbGF0ZXN0L2Rldmd1aWRlL2dldHRpbmctc3RhcnRlZC5kZGwuaHRtbCkgaW4gdGhlICpBbWF6b24gS2V5c3BhY2VzIERldmVsb3BlciBHdWlkZSogLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6Q2Fzc2FuZHJhOjpLZXlzcGFjZVxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS1rZXlzcGFjZS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5LZXlzcGFjZSBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkNhc3NhbmRyYTo6S2V5c3BhY2VcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbktleXNwYWNlIHtcbiAgICAgICAgcmVzb3VyY2VBdHRyaWJ1dGVzID0gcmVzb3VyY2VBdHRyaWJ1dGVzIHx8IHt9O1xuICAgICAgICBjb25zdCByZXNvdXJjZVByb3BlcnRpZXMgPSBvcHRpb25zLnBhcnNlci5wYXJzZVZhbHVlKHJlc291cmNlQXR0cmlidXRlcy5Qcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcHJvcHNSZXN1bHQgPSBDZm5LZXlzcGFjZVByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5LZXlzcGFjZShzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUga2V5c3BhY2UgdG8gYmUgY3JlYXRlZC4gVGhlIGtleXNwYWNlIG5hbWUgaXMgY2FzZSBzZW5zaXRpdmUuIElmIHlvdSBkb24ndCBzcGVjaWZ5IGEgbmFtZSwgQVdTIENsb3VkRm9ybWF0aW9uIGdlbmVyYXRlcyBhIHVuaXF1ZSBJRCBhbmQgdXNlcyB0aGF0IElEIGZvciB0aGUga2V5c3BhY2UgbmFtZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbTmFtZSB0eXBlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1uYW1lLmh0bWwpIC5cbiAgICAgKlxuICAgICAqICpMZW5ndGggY29uc3RyYWludHM6KiBNaW5pbXVtIGxlbmd0aCBvZiAzLiBNYXhpbXVtIGxlbmd0aCBvZiAyNTUuXG4gICAgICpcbiAgICAgKiAqUGF0dGVybjoqIGBeW2EtekEtWjAtOV1bYS16QS1aMC05X117MSw0N30kYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLWtleXNwYWNlLmh0bWwjY2ZuLWNhc3NhbmRyYS1rZXlzcGFjZS1rZXlzcGFjZW5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMga2V5c3BhY2VOYW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2Yga2V5LXZhbHVlIHBhaXIgdGFncyB0byBiZSBhdHRhY2hlZCB0byB0aGUgcmVzb3VyY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jYXNzYW5kcmEta2V5c3BhY2UuaHRtbCNjZm4tY2Fzc2FuZHJhLWtleXNwYWNlLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6Q2Fzc2FuZHJhOjpLZXlzcGFjZWAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuS2V5c3BhY2VQcm9wcyA9IHt9KSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5LZXlzcGFjZS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcblxuICAgICAgICB0aGlzLmtleXNwYWNlTmFtZSA9IHByb3BzLmtleXNwYWNlTmFtZTtcbiAgICAgICAgdGhpcy50YWdzID0gbmV3IGNkay5UYWdNYW5hZ2VyKGNkay5UYWdUeXBlLlNUQU5EQVJELCBcIkFXUzo6Q2Fzc2FuZHJhOjpLZXlzcGFjZVwiLCBwcm9wcy50YWdzLCB7IHRhZ1Byb3BlcnR5TmFtZTogJ3RhZ3MnIH0pO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuS2V5c3BhY2UuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGtleXNwYWNlTmFtZTogdGhpcy5rZXlzcGFjZU5hbWUsXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbktleXNwYWNlUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuVGFibGVgXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuVGFibGVQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUga2V5c3BhY2UgaW4gd2hpY2ggdG8gY3JlYXRlIHRoZSB0YWJsZS4gVGhlIGtleXNwYWNlIG11c3QgYWxyZWFkeSBleGlzdC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUta2V5c3BhY2VuYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkga2V5c3BhY2VOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBPbmUgb3IgbW9yZSBjb2x1bW5zIHRoYXQgdW5pcXVlbHkgaWRlbnRpZnkgZXZlcnkgcm93IGluIHRoZSB0YWJsZS4gRXZlcnkgdGFibGUgbXVzdCBoYXZlIGEgcGFydGl0aW9uIGtleS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtcGFydGl0aW9ua2V5Y29sdW1uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHBhcnRpdGlvbktleUNvbHVtbnM6IEFycmF5PENmblRhYmxlLkNvbHVtblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBiaWxsaW5nIG1vZGUgZm9yIHRoZSB0YWJsZSwgd2hpY2ggZGV0ZXJtaW5lcyBob3cgeW91J2xsIGJlIGNoYXJnZWQgZm9yIHJlYWRzIGFuZCB3cml0ZXM6XG4gICAgICpcbiAgICAgKiAtICpPbi1kZW1hbmQgbW9kZSogKGRlZmF1bHQpIC0gWW91IHBheSBiYXNlZCBvbiB0aGUgYWN0dWFsIHJlYWRzIGFuZCB3cml0ZXMgeW91ciBhcHBsaWNhdGlvbiBwZXJmb3Jtcy5cbiAgICAgKiAtICpQcm92aXNpb25lZCBtb2RlKiAtIExldHMgeW91IHNwZWNpZnkgdGhlIG51bWJlciBvZiByZWFkcyBhbmQgd3JpdGVzIHBlciBzZWNvbmQgdGhhdCB5b3UgbmVlZCBmb3IgeW91ciBhcHBsaWNhdGlvbi5cbiAgICAgKlxuICAgICAqIElmIHlvdSBkb24ndCBzcGVjaWZ5IGEgdmFsdWUgZm9yIHRoaXMgcHJvcGVydHksIHRoZW4gdGhlIHRhYmxlIHdpbGwgdXNlIG9uLWRlbWFuZCBtb2RlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1iaWxsaW5nbW9kZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJpbGxpbmdNb2RlPzogQ2ZuVGFibGUuQmlsbGluZ01vZGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIE9uZSBvciBtb3JlIGNvbHVtbnMgdGhhdCBkZXRlcm1pbmUgaG93IHRoZSB0YWJsZSBkYXRhIGlzIHNvcnRlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtY2x1c3RlcmluZ2tleWNvbHVtbnNcbiAgICAgKi9cbiAgICByZWFkb25seSBjbHVzdGVyaW5nS2V5Q29sdW1ucz86IEFycmF5PENmblRhYmxlLkNsdXN0ZXJpbmdLZXlDb2x1bW5Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgZGVmYXVsdCBUaW1lIFRvIExpdmUgKFRUTCkgdmFsdWUgZm9yIGFsbCByb3dzIGluIGEgdGFibGUgaW4gc2Vjb25kcy4gVGhlIG1heGltdW0gY29uZmlndXJhYmxlIHZhbHVlIGlzIDYzMCw3MjAsMDAwIHNlY29uZHMsIHdoaWNoIGlzIHRoZSBlcXVpdmFsZW50IG9mIDIwIHllYXJzLiBCeSBkZWZhdWx0LCB0aGUgVFRMIHZhbHVlIGZvciBhIHRhYmxlIGlzIDAsIHdoaWNoIG1lYW5zIGRhdGEgZG9lcyBub3QgZXhwaXJlLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU2V0dGluZyB0aGUgZGVmYXVsdCBUVEwgdmFsdWUgZm9yIGEgdGFibGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rZXlzcGFjZXMvbGF0ZXN0L2Rldmd1aWRlL1RUTC1ob3ctaXQtd29ya3MuaHRtbCN0dGwtaG93aXR3b3Jrc19kZWZhdWx0X3R0bCkgaW4gdGhlICpBbWF6b24gS2V5c3BhY2VzIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1kZWZhdWx0dGltZXRvbGl2ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlZmF1bHRUaW1lVG9MaXZlPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGVuY3J5cHRpb24gYXQgcmVzdCBvcHRpb25zIGZvciB0aGUgdGFibGUuXG4gICAgICpcbiAgICAgKiAtICpBV1Mgb3duZWQga2V5KiAoZGVmYXVsdCkgLSBUaGUga2V5IGlzIG93bmVkIGJ5IEFtYXpvbiBLZXlzcGFjZXMuXG4gICAgICogLSAqQ3VzdG9tZXIgbWFuYWdlZCBrZXkqIC0gVGhlIGtleSBpcyBzdG9yZWQgaW4geW91ciBhY2NvdW50IGFuZCBpcyBjcmVhdGVkLCBvd25lZCwgYW5kIG1hbmFnZWQgYnkgeW91LlxuICAgICAqXG4gICAgICogPiBJZiB5b3UgY2hvb3NlIGVuY3J5cHRpb24gd2l0aCBhIGN1c3RvbWVyIG1hbmFnZWQga2V5LCB5b3UgbXVzdCBzcGVjaWZ5IGEgdmFsaWQgY3VzdG9tZXIgbWFuYWdlZCBLTVMga2V5IHdpdGggcGVybWlzc2lvbnMgZ3JhbnRlZCB0byBBbWF6b24gS2V5c3BhY2VzLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbRW5jcnlwdGlvbiBhdCByZXN0IGluIEFtYXpvbiBLZXlzcGFjZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rZXlzcGFjZXMvbGF0ZXN0L2Rldmd1aWRlL0VuY3J5cHRpb25BdFJlc3QuaHRtbCkgaW4gdGhlICpBbWF6b24gS2V5c3BhY2VzIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1lbmNyeXB0aW9uc3BlY2lmaWNhdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuY3J5cHRpb25TcGVjaWZpY2F0aW9uPzogQ2ZuVGFibGUuRW5jcnlwdGlvblNwZWNpZmljYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBpZiBwb2ludC1pbi10aW1lIHJlY292ZXJ5IGlzIGVuYWJsZWQgb3IgZGlzYWJsZWQgZm9yIHRoZSB0YWJsZS4gVGhlIG9wdGlvbnMgYXJlIGBQb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZD10cnVlYCBhbmQgYFBvaW50SW5UaW1lUmVjb3ZlcnlFbmFibGVkPWZhbHNlYCAuIElmIG5vdCBzcGVjaWZpZWQsIHRoZSBkZWZhdWx0IGlzIGBQb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZD1mYWxzZWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1wb2ludGludGltZXJlY292ZXJ5ZW5hYmxlZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBvaW50SW5UaW1lUmVjb3ZlcnlFbmFibGVkPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIE9uZSBvciBtb3JlIGNvbHVtbnMgdGhhdCBhcmUgbm90IHBhcnQgb2YgdGhlIHByaW1hcnkga2V5IC0gdGhhdCBpcywgY29sdW1ucyB0aGF0IGFyZSAqbm90KiBkZWZpbmVkIGFzIHBhcnRpdGlvbiBrZXkgY29sdW1ucyBvciBjbHVzdGVyaW5nIGtleSBjb2x1bW5zLlxuICAgICAqXG4gICAgICogWW91IGNhbiBhZGQgcmVndWxhciBjb2x1bW5zIHRvIGV4aXN0aW5nIHRhYmxlcyBieSBhZGRpbmcgdGhlbSB0byB0aGUgdGVtcGxhdGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jYXNzYW5kcmEtdGFibGUuaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLXJlZ3VsYXJjb2x1bW5zXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVndWxhckNvbHVtbnM/OiBBcnJheTxDZm5UYWJsZS5Db2x1bW5Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgdGFibGUgdG8gYmUgY3JlYXRlZC4gVGhlIHRhYmxlIG5hbWUgaXMgY2FzZSBzZW5zaXRpdmUuIElmIHlvdSBkb24ndCBzcGVjaWZ5IGEgbmFtZSwgQVdTIENsb3VkRm9ybWF0aW9uIGdlbmVyYXRlcyBhIHVuaXF1ZSBJRCBhbmQgdXNlcyB0aGF0IElEIGZvciB0aGUgdGFibGUgbmFtZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbTmFtZSB0eXBlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1uYW1lLmh0bWwpIC5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IHNwZWNpZnkgYSBuYW1lLCB5b3UgY2Fubm90IHBlcmZvcm0gdXBkYXRlcyB0aGF0IHJlcXVpcmUgcmVwbGFjZW1lbnQgb2YgdGhpcyByZXNvdXJjZS4gWW91IGNhbiBwZXJmb3JtIHVwZGF0ZXMgdGhhdCByZXF1aXJlIG5vIG9yIHNvbWUgaW50ZXJydXB0aW9uLiBJZiB5b3UgbXVzdCByZXBsYWNlIHRoZSByZXNvdXJjZSwgc3BlY2lmeSBhIG5ldyBuYW1lLlxuICAgICAqXG4gICAgICogKkxlbmd0aCBjb25zdHJhaW50czoqIE1pbmltdW0gbGVuZ3RoIG9mIDMuIE1heGltdW0gbGVuZ3RoIG9mIDI1NS5cbiAgICAgKlxuICAgICAqICpQYXR0ZXJuOiogYF5bYS16QS1aMC05XVthLXpBLVowLTlfXXsxLDQ3fSRgXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jYXNzYW5kcmEtdGFibGUuaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLXRhYmxlbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhYmxlTmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBrZXktdmFsdWUgcGFpciB0YWdzIHRvIGJlIGF0dGFjaGVkIHRvIHRoZSByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuVGFibGVQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuVGFibGVQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5UYWJsZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYmlsbGluZ01vZGUnLCBDZm5UYWJsZV9CaWxsaW5nTW9kZVByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmJpbGxpbmdNb2RlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjbHVzdGVyaW5nS2V5Q29sdW1ucycsIGNkay5saXN0VmFsaWRhdG9yKENmblRhYmxlX0NsdXN0ZXJpbmdLZXlDb2x1bW5Qcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMuY2x1c3RlcmluZ0tleUNvbHVtbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RlZmF1bHRUaW1lVG9MaXZlJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmRlZmF1bHRUaW1lVG9MaXZlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdlbmNyeXB0aW9uU3BlY2lmaWNhdGlvbicsIENmblRhYmxlX0VuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMuZW5jcnlwdGlvblNwZWNpZmljYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tleXNwYWNlTmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5rZXlzcGFjZU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tleXNwYWNlTmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5rZXlzcGFjZU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3BhcnRpdGlvbktleUNvbHVtbnMnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucGFydGl0aW9uS2V5Q29sdW1ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGFydGl0aW9uS2V5Q29sdW1ucycsIGNkay5saXN0VmFsaWRhdG9yKENmblRhYmxlX0NvbHVtblByb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5wYXJ0aXRpb25LZXlDb2x1bW5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZCcsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMucG9pbnRJblRpbWVSZWNvdmVyeUVuYWJsZWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3JlZ3VsYXJDb2x1bW5zJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuVGFibGVfQ29sdW1uUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLnJlZ3VsYXJDb2x1bW5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWJsZU5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudGFibGVOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmblRhYmxlUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGVgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblRhYmxlUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGVgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuVGFibGVQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuVGFibGVQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgS2V5c3BhY2VOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtleXNwYWNlTmFtZSksXG4gICAgICAgIFBhcnRpdGlvbktleUNvbHVtbnM6IGNkay5saXN0TWFwcGVyKGNmblRhYmxlQ29sdW1uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnBhcnRpdGlvbktleUNvbHVtbnMpLFxuICAgICAgICBCaWxsaW5nTW9kZTogY2ZuVGFibGVCaWxsaW5nTW9kZVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmJpbGxpbmdNb2RlKSxcbiAgICAgICAgQ2x1c3RlcmluZ0tleUNvbHVtbnM6IGNkay5saXN0TWFwcGVyKGNmblRhYmxlQ2x1c3RlcmluZ0tleUNvbHVtblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5jbHVzdGVyaW5nS2V5Q29sdW1ucyksXG4gICAgICAgIERlZmF1bHRUaW1lVG9MaXZlOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlZmF1bHRUaW1lVG9MaXZlKSxcbiAgICAgICAgRW5jcnlwdGlvblNwZWNpZmljYXRpb246IGNmblRhYmxlRW5jcnlwdGlvblNwZWNpZmljYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5lbmNyeXB0aW9uU3BlY2lmaWNhdGlvbiksXG4gICAgICAgIFBvaW50SW5UaW1lUmVjb3ZlcnlFbmFibGVkOiBjZGsuYm9vbGVhblRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZCksXG4gICAgICAgIFJlZ3VsYXJDb2x1bW5zOiBjZGsubGlzdE1hcHBlcihjZm5UYWJsZUNvbHVtblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5yZWd1bGFyQ29sdW1ucyksXG4gICAgICAgIFRhYmxlTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50YWJsZU5hbWUpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuVGFibGVQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblRhYmxlUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblRhYmxlUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdrZXlzcGFjZU5hbWUnLCAnS2V5c3BhY2VOYW1lJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXlzcGFjZU5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3BhcnRpdGlvbktleUNvbHVtbnMnLCAnUGFydGl0aW9uS2V5Q29sdW1ucycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuVGFibGVDb2x1bW5Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5QYXJ0aXRpb25LZXlDb2x1bW5zKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdiaWxsaW5nTW9kZScsICdCaWxsaW5nTW9kZScsIHByb3BlcnRpZXMuQmlsbGluZ01vZGUgIT0gbnVsbCA/IENmblRhYmxlQmlsbGluZ01vZGVQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkJpbGxpbmdNb2RlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjbHVzdGVyaW5nS2V5Q29sdW1ucycsICdDbHVzdGVyaW5nS2V5Q29sdW1ucycsIHByb3BlcnRpZXMuQ2x1c3RlcmluZ0tleUNvbHVtbnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuVGFibGVDbHVzdGVyaW5nS2V5Q29sdW1uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuQ2x1c3RlcmluZ0tleUNvbHVtbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RlZmF1bHRUaW1lVG9MaXZlJywgJ0RlZmF1bHRUaW1lVG9MaXZlJywgcHJvcGVydGllcy5EZWZhdWx0VGltZVRvTGl2ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5EZWZhdWx0VGltZVRvTGl2ZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZW5jcnlwdGlvblNwZWNpZmljYXRpb24nLCAnRW5jcnlwdGlvblNwZWNpZmljYXRpb24nLCBwcm9wZXJ0aWVzLkVuY3J5cHRpb25TcGVjaWZpY2F0aW9uICE9IG51bGwgPyBDZm5UYWJsZUVuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5FbmNyeXB0aW9uU3BlY2lmaWNhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncG9pbnRJblRpbWVSZWNvdmVyeUVuYWJsZWQnLCAnUG9pbnRJblRpbWVSZWNvdmVyeUVuYWJsZWQnLCBwcm9wZXJ0aWVzLlBvaW50SW5UaW1lUmVjb3ZlcnlFbmFibGVkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5Qb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVndWxhckNvbHVtbnMnLCAnUmVndWxhckNvbHVtbnMnLCBwcm9wZXJ0aWVzLlJlZ3VsYXJDb2x1bW5zICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KENmblRhYmxlQ29sdW1uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuUmVndWxhckNvbHVtbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhYmxlTmFtZScsICdUYWJsZU5hbWUnLCBwcm9wZXJ0aWVzLlRhYmxlTmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5UYWJsZU5hbWUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6Q2Fzc2FuZHJhOjpUYWJsZWBcbiAqXG4gKiBUaGUgYEFXUzo6Q2Fzc2FuZHJhOjpUYWJsZWAgcmVzb3VyY2UgYWxsb3dzIHlvdSB0byBjcmVhdGUgYSBuZXcgdGFibGUgaW4gQW1hem9uIEtleXNwYWNlcyAoZm9yIEFwYWNoZSBDYXNzYW5kcmEpLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDcmVhdGUgYSBrZXlzcGFjZSBhbmQgYSB0YWJsZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2tleXNwYWNlcy9sYXRlc3QvZGV2Z3VpZGUvZ2V0dGluZy1zdGFydGVkLmRkbC5odG1sKSBpbiB0aGUgKkFtYXpvbiBLZXlzcGFjZXMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpDYXNzYW5kcmE6OlRhYmxlXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmblRhYmxlIGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6Q2Fzc2FuZHJhOjpUYWJsZVwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuVGFibGUge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmblRhYmxlUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmblRhYmxlKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBrZXlzcGFjZSBpbiB3aGljaCB0byBjcmVhdGUgdGhlIHRhYmxlLiBUaGUga2V5c3BhY2UgbXVzdCBhbHJlYWR5IGV4aXN0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1rZXlzcGFjZW5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMga2V5c3BhY2VOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBPbmUgb3IgbW9yZSBjb2x1bW5zIHRoYXQgdW5pcXVlbHkgaWRlbnRpZnkgZXZlcnkgcm93IGluIHRoZSB0YWJsZS4gRXZlcnkgdGFibGUgbXVzdCBoYXZlIGEgcGFydGl0aW9uIGtleS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtcGFydGl0aW9ua2V5Y29sdW1uc1xuICAgICAqL1xuICAgIHB1YmxpYyBwYXJ0aXRpb25LZXlDb2x1bW5zOiBBcnJheTxDZm5UYWJsZS5Db2x1bW5Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYmlsbGluZyBtb2RlIGZvciB0aGUgdGFibGUsIHdoaWNoIGRldGVybWluZXMgaG93IHlvdSdsbCBiZSBjaGFyZ2VkIGZvciByZWFkcyBhbmQgd3JpdGVzOlxuICAgICAqXG4gICAgICogLSAqT24tZGVtYW5kIG1vZGUqIChkZWZhdWx0KSAtIFlvdSBwYXkgYmFzZWQgb24gdGhlIGFjdHVhbCByZWFkcyBhbmQgd3JpdGVzIHlvdXIgYXBwbGljYXRpb24gcGVyZm9ybXMuXG4gICAgICogLSAqUHJvdmlzaW9uZWQgbW9kZSogLSBMZXRzIHlvdSBzcGVjaWZ5IHRoZSBudW1iZXIgb2YgcmVhZHMgYW5kIHdyaXRlcyBwZXIgc2Vjb25kIHRoYXQgeW91IG5lZWQgZm9yIHlvdXIgYXBwbGljYXRpb24uXG4gICAgICpcbiAgICAgKiBJZiB5b3UgZG9uJ3Qgc3BlY2lmeSBhIHZhbHVlIGZvciB0aGlzIHByb3BlcnR5LCB0aGVuIHRoZSB0YWJsZSB3aWxsIHVzZSBvbi1kZW1hbmQgbW9kZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtYmlsbGluZ21vZGVcbiAgICAgKi9cbiAgICBwdWJsaWMgYmlsbGluZ01vZGU6IENmblRhYmxlLkJpbGxpbmdNb2RlUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBPbmUgb3IgbW9yZSBjb2x1bW5zIHRoYXQgZGV0ZXJtaW5lIGhvdyB0aGUgdGFibGUgZGF0YSBpcyBzb3J0ZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jYXNzYW5kcmEtdGFibGUuaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLWNsdXN0ZXJpbmdrZXljb2x1bW5zXG4gICAgICovXG4gICAgcHVibGljIGNsdXN0ZXJpbmdLZXlDb2x1bW5zOiBBcnJheTxDZm5UYWJsZS5DbHVzdGVyaW5nS2V5Q29sdW1uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGRlZmF1bHQgVGltZSBUbyBMaXZlIChUVEwpIHZhbHVlIGZvciBhbGwgcm93cyBpbiBhIHRhYmxlIGluIHNlY29uZHMuIFRoZSBtYXhpbXVtIGNvbmZpZ3VyYWJsZSB2YWx1ZSBpcyA2MzAsNzIwLDAwMCBzZWNvbmRzLCB3aGljaCBpcyB0aGUgZXF1aXZhbGVudCBvZiAyMCB5ZWFycy4gQnkgZGVmYXVsdCwgdGhlIFRUTCB2YWx1ZSBmb3IgYSB0YWJsZSBpcyAwLCB3aGljaCBtZWFucyBkYXRhIGRvZXMgbm90IGV4cGlyZS5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1NldHRpbmcgdGhlIGRlZmF1bHQgVFRMIHZhbHVlIGZvciBhIHRhYmxlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va2V5c3BhY2VzL2xhdGVzdC9kZXZndWlkZS9UVEwtaG93LWl0LXdvcmtzLmh0bWwjdHRsLWhvd2l0d29ya3NfZGVmYXVsdF90dGwpIGluIHRoZSAqQW1hem9uIEtleXNwYWNlcyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtZGVmYXVsdHRpbWV0b2xpdmVcbiAgICAgKi9cbiAgICBwdWJsaWMgZGVmYXVsdFRpbWVUb0xpdmU6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBlbmNyeXB0aW9uIGF0IHJlc3Qgb3B0aW9ucyBmb3IgdGhlIHRhYmxlLlxuICAgICAqXG4gICAgICogLSAqQVdTIG93bmVkIGtleSogKGRlZmF1bHQpIC0gVGhlIGtleSBpcyBvd25lZCBieSBBbWF6b24gS2V5c3BhY2VzLlxuICAgICAqIC0gKkN1c3RvbWVyIG1hbmFnZWQga2V5KiAtIFRoZSBrZXkgaXMgc3RvcmVkIGluIHlvdXIgYWNjb3VudCBhbmQgaXMgY3JlYXRlZCwgb3duZWQsIGFuZCBtYW5hZ2VkIGJ5IHlvdS5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IGNob29zZSBlbmNyeXB0aW9uIHdpdGggYSBjdXN0b21lciBtYW5hZ2VkIGtleSwgeW91IG11c3Qgc3BlY2lmeSBhIHZhbGlkIGN1c3RvbWVyIG1hbmFnZWQgS01TIGtleSB3aXRoIHBlcm1pc3Npb25zIGdyYW50ZWQgdG8gQW1hem9uIEtleXNwYWNlcy5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0VuY3J5cHRpb24gYXQgcmVzdCBpbiBBbWF6b24gS2V5c3BhY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va2V5c3BhY2VzL2xhdGVzdC9kZXZndWlkZS9FbmNyeXB0aW9uQXRSZXN0Lmh0bWwpIGluIHRoZSAqQW1hem9uIEtleXNwYWNlcyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtZW5jcnlwdGlvbnNwZWNpZmljYXRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgZW5jcnlwdGlvblNwZWNpZmljYXRpb246IENmblRhYmxlLkVuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgaWYgcG9pbnQtaW4tdGltZSByZWNvdmVyeSBpcyBlbmFibGVkIG9yIGRpc2FibGVkIGZvciB0aGUgdGFibGUuIFRoZSBvcHRpb25zIGFyZSBgUG9pbnRJblRpbWVSZWNvdmVyeUVuYWJsZWQ9dHJ1ZWAgYW5kIGBQb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZD1mYWxzZWAgLiBJZiBub3Qgc3BlY2lmaWVkLCB0aGUgZGVmYXVsdCBpcyBgUG9pbnRJblRpbWVSZWNvdmVyeUVuYWJsZWQ9ZmFsc2VgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNhc3NhbmRyYS10YWJsZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtcG9pbnRpbnRpbWVyZWNvdmVyeWVuYWJsZWRcbiAgICAgKi9cbiAgICBwdWJsaWMgcG9pbnRJblRpbWVSZWNvdmVyeUVuYWJsZWQ6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBPbmUgb3IgbW9yZSBjb2x1bW5zIHRoYXQgYXJlIG5vdCBwYXJ0IG9mIHRoZSBwcmltYXJ5IGtleSAtIHRoYXQgaXMsIGNvbHVtbnMgdGhhdCBhcmUgKm5vdCogZGVmaW5lZCBhcyBwYXJ0aXRpb24ga2V5IGNvbHVtbnMgb3IgY2x1c3RlcmluZyBrZXkgY29sdW1ucy5cbiAgICAgKlxuICAgICAqIFlvdSBjYW4gYWRkIHJlZ3VsYXIgY29sdW1ucyB0byBleGlzdGluZyB0YWJsZXMgYnkgYWRkaW5nIHRoZW0gdG8gdGhlIHRlbXBsYXRlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1yZWd1bGFyY29sdW1uc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWd1bGFyQ29sdW1uczogQXJyYXk8Q2ZuVGFibGUuQ29sdW1uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIHRhYmxlIHRvIGJlIGNyZWF0ZWQuIFRoZSB0YWJsZSBuYW1lIGlzIGNhc2Ugc2Vuc2l0aXZlLiBJZiB5b3UgZG9uJ3Qgc3BlY2lmeSBhIG5hbWUsIEFXUyBDbG91ZEZvcm1hdGlvbiBnZW5lcmF0ZXMgYSB1bmlxdWUgSUQgYW5kIHVzZXMgdGhhdCBJRCBmb3IgdGhlIHRhYmxlIG5hbWUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW05hbWUgdHlwZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtbmFtZS5odG1sKSAuXG4gICAgICpcbiAgICAgKiA+IElmIHlvdSBzcGVjaWZ5IGEgbmFtZSwgeW91IGNhbm5vdCBwZXJmb3JtIHVwZGF0ZXMgdGhhdCByZXF1aXJlIHJlcGxhY2VtZW50IG9mIHRoaXMgcmVzb3VyY2UuIFlvdSBjYW4gcGVyZm9ybSB1cGRhdGVzIHRoYXQgcmVxdWlyZSBubyBvciBzb21lIGludGVycnVwdGlvbi4gSWYgeW91IG11c3QgcmVwbGFjZSB0aGUgcmVzb3VyY2UsIHNwZWNpZnkgYSBuZXcgbmFtZS5cbiAgICAgKlxuICAgICAqICpMZW5ndGggY29uc3RyYWludHM6KiBNaW5pbXVtIGxlbmd0aCBvZiAzLiBNYXhpbXVtIGxlbmd0aCBvZiAyNTUuXG4gICAgICpcbiAgICAgKiAqUGF0dGVybjoqIGBeW2EtekEtWjAtOV1bYS16QS1aMC05X117MSw0N30kYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY2Fzc2FuZHJhLXRhYmxlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS10YWJsZW5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgdGFibGVOYW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2Yga2V5LXZhbHVlIHBhaXIgdGFncyB0byBiZSBhdHRhY2hlZCB0byB0aGUgcmVzb3VyY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jYXNzYW5kcmEtdGFibGUuaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6Q2Fzc2FuZHJhOjpUYWJsZWAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuVGFibGVQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuVGFibGUuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdrZXlzcGFjZU5hbWUnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3BhcnRpdGlvbktleUNvbHVtbnMnLCB0aGlzKTtcblxuICAgICAgICB0aGlzLmtleXNwYWNlTmFtZSA9IHByb3BzLmtleXNwYWNlTmFtZTtcbiAgICAgICAgdGhpcy5wYXJ0aXRpb25LZXlDb2x1bW5zID0gcHJvcHMucGFydGl0aW9uS2V5Q29sdW1ucztcbiAgICAgICAgdGhpcy5iaWxsaW5nTW9kZSA9IHByb3BzLmJpbGxpbmdNb2RlO1xuICAgICAgICB0aGlzLmNsdXN0ZXJpbmdLZXlDb2x1bW5zID0gcHJvcHMuY2x1c3RlcmluZ0tleUNvbHVtbnM7XG4gICAgICAgIHRoaXMuZGVmYXVsdFRpbWVUb0xpdmUgPSBwcm9wcy5kZWZhdWx0VGltZVRvTGl2ZTtcbiAgICAgICAgdGhpcy5lbmNyeXB0aW9uU3BlY2lmaWNhdGlvbiA9IHByb3BzLmVuY3J5cHRpb25TcGVjaWZpY2F0aW9uO1xuICAgICAgICB0aGlzLnBvaW50SW5UaW1lUmVjb3ZlcnlFbmFibGVkID0gcHJvcHMucG9pbnRJblRpbWVSZWNvdmVyeUVuYWJsZWQ7XG4gICAgICAgIHRoaXMucmVndWxhckNvbHVtbnMgPSBwcm9wcy5yZWd1bGFyQ29sdW1ucztcbiAgICAgICAgdGhpcy50YWJsZU5hbWUgPSBwcm9wcy50YWJsZU5hbWU7XG4gICAgICAgIHRoaXMudGFncyA9IG5ldyBjZGsuVGFnTWFuYWdlcihjZGsuVGFnVHlwZS5TVEFOREFSRCwgXCJBV1M6OkNhc3NhbmRyYTo6VGFibGVcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmblRhYmxlLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBrZXlzcGFjZU5hbWU6IHRoaXMua2V5c3BhY2VOYW1lLFxuICAgICAgICAgICAgcGFydGl0aW9uS2V5Q29sdW1uczogdGhpcy5wYXJ0aXRpb25LZXlDb2x1bW5zLFxuICAgICAgICAgICAgYmlsbGluZ01vZGU6IHRoaXMuYmlsbGluZ01vZGUsXG4gICAgICAgICAgICBjbHVzdGVyaW5nS2V5Q29sdW1uczogdGhpcy5jbHVzdGVyaW5nS2V5Q29sdW1ucyxcbiAgICAgICAgICAgIGRlZmF1bHRUaW1lVG9MaXZlOiB0aGlzLmRlZmF1bHRUaW1lVG9MaXZlLFxuICAgICAgICAgICAgZW5jcnlwdGlvblNwZWNpZmljYXRpb246IHRoaXMuZW5jcnlwdGlvblNwZWNpZmljYXRpb24sXG4gICAgICAgICAgICBwb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZDogdGhpcy5wb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZCxcbiAgICAgICAgICAgIHJlZ3VsYXJDb2x1bW5zOiB0aGlzLnJlZ3VsYXJDb2x1bW5zLFxuICAgICAgICAgICAgdGFibGVOYW1lOiB0aGlzLnRhYmxlTmFtZSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuVGFibGVQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5UYWJsZSB7XG4gICAgLyoqXG4gICAgICogRGV0ZXJtaW5lcyB0aGUgYmlsbGluZyBtb2RlIGZvciB0aGUgdGFibGUgLSBPbi1kZW1hbmQgb3IgcHJvdmlzaW9uZWQuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1jYXNzYW5kcmEtdGFibGUtYmlsbGluZ21vZGUuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgQmlsbGluZ01vZGVQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgYmlsbGluZyBtb2RlIGZvciB0aGUgdGFibGU6XG4gICAgICAgICAqXG4gICAgICAgICAqIC0gT24tZGVtYW5kIG1vZGUgLSBgT05fREVNQU5EYFxuICAgICAgICAgKiAtIFByb3Zpc2lvbmVkIG1vZGUgLSBgUFJPVklTSU9ORURgXG4gICAgICAgICAqXG4gICAgICAgICAqID4gSWYgeW91IGNob29zZSBgUFJPVklTSU9ORURgIG1vZGUsIHRoZW4geW91IGFsc28gbmVlZCB0byBzcGVjaWZ5IHByb3Zpc2lvbmVkIHRocm91Z2hwdXQgKHJlYWQgYW5kIHdyaXRlIGNhcGFjaXR5KSBmb3IgdGhlIHRhYmxlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBWYWxpZCB2YWx1ZXM6IGBPTl9ERU1BTkRgIHwgYFBST1ZJU0lPTkVEYFxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWNhc3NhbmRyYS10YWJsZS1iaWxsaW5nbW9kZS5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtYmlsbGluZ21vZGUtbW9kZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbW9kZTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHByb3Zpc2lvbmVkIHJlYWQgY2FwYWNpdHkgYW5kIHdyaXRlIGNhcGFjaXR5IGZvciB0aGUgdGFibGUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1Byb3Zpc2lvbmVkIHRocm91Z2hwdXQgY2FwYWNpdHkgbW9kZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2tleXNwYWNlcy9sYXRlc3QvZGV2Z3VpZGUvUmVhZFdyaXRlQ2FwYWNpdHlNb2RlLmh0bWwjUmVhZFdyaXRlQ2FwYWNpdHlNb2RlLlByb3Zpc2lvbmVkKSBpbiB0aGUgKkFtYXpvbiBLZXlzcGFjZXMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtY2Fzc2FuZHJhLXRhYmxlLWJpbGxpbmdtb2RlLmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1iaWxsaW5nbW9kZS1wcm92aXNpb25lZHRocm91Z2hwdXRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHByb3Zpc2lvbmVkVGhyb3VnaHB1dD86IENmblRhYmxlLlByb3Zpc2lvbmVkVGhyb3VnaHB1dFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBCaWxsaW5nTW9kZVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBCaWxsaW5nTW9kZVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblRhYmxlX0JpbGxpbmdNb2RlUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtb2RlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1vZGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21vZGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubW9kZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJvdmlzaW9uZWRUaHJvdWdocHV0JywgQ2ZuVGFibGVfUHJvdmlzaW9uZWRUaHJvdWdocHV0UHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJvdmlzaW9uZWRUaHJvdWdocHV0KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkJpbGxpbmdNb2RlUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGUuQmlsbGluZ01vZGVgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEJpbGxpbmdNb2RlUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGUuQmlsbGluZ01vZGVgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuVGFibGVCaWxsaW5nTW9kZVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5UYWJsZV9CaWxsaW5nTW9kZVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNb2RlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1vZGUpLFxuICAgICAgICBQcm92aXNpb25lZFRocm91Z2hwdXQ6IGNmblRhYmxlUHJvdmlzaW9uZWRUaHJvdWdocHV0UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJvdmlzaW9uZWRUaHJvdWdocHV0KSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuVGFibGVCaWxsaW5nTW9kZVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuVGFibGUuQmlsbGluZ01vZGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5UYWJsZS5CaWxsaW5nTW9kZVByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbW9kZScsICdNb2RlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Nb2RlKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwcm92aXNpb25lZFRocm91Z2hwdXQnLCAnUHJvdmlzaW9uZWRUaHJvdWdocHV0JywgcHJvcGVydGllcy5Qcm92aXNpb25lZFRocm91Z2hwdXQgIT0gbnVsbCA/IENmblRhYmxlUHJvdmlzaW9uZWRUaHJvdWdocHV0UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5Qcm92aXNpb25lZFRocm91Z2hwdXQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5UYWJsZSB7XG4gICAgLyoqXG4gICAgICogRGVmaW5lcyBhbiBpbmRpdmlkdWFsIGNvbHVtbiB3aXRoaW4gdGhlIGNsdXN0ZXJpbmcga2V5LlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtY2Fzc2FuZHJhLXRhYmxlLWNsdXN0ZXJpbmdrZXljb2x1bW4uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgQ2x1c3RlcmluZ0tleUNvbHVtblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIGFuZCBkYXRhIHR5cGUgb2YgdGhpcyBjbHVzdGVyaW5nIGtleSBjb2x1bW4uXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtY2Fzc2FuZHJhLXRhYmxlLWNsdXN0ZXJpbmdrZXljb2x1bW4uaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLWNsdXN0ZXJpbmdrZXljb2x1bW4tY29sdW1uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBjb2x1bW46IENmblRhYmxlLkNvbHVtblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG9yZGVyIGluIHdoaWNoIHRoaXMgY29sdW1uJ3MgZGF0YSBpcyBzdG9yZWQ6XG4gICAgICAgICAqXG4gICAgICAgICAqIC0gYEFTQ2AgKGRlZmF1bHQpIC0gVGhlIGNvbHVtbidzIGRhdGEgaXMgc3RvcmVkIGluIGFzY2VuZGluZyBvcmRlci5cbiAgICAgICAgICogLSBgREVTQ2AgLSBUaGUgY29sdW1uJ3MgZGF0YSBpcyBzdG9yZWQgaW4gZGVzY2VuZGluZyBvcmRlci5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1jYXNzYW5kcmEtdGFibGUtY2x1c3RlcmluZ2tleWNvbHVtbi5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtY2x1c3RlcmluZ2tleWNvbHVtbi1vcmRlcmJ5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBvcmRlckJ5Pzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDbHVzdGVyaW5nS2V5Q29sdW1uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENsdXN0ZXJpbmdLZXlDb2x1bW5Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5UYWJsZV9DbHVzdGVyaW5nS2V5Q29sdW1uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjb2x1bW4nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuY29sdW1uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjb2x1bW4nLCBDZm5UYWJsZV9Db2x1bW5Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5jb2x1bW4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ29yZGVyQnknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMub3JkZXJCeSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDbHVzdGVyaW5nS2V5Q29sdW1uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGUuQ2x1c3RlcmluZ0tleUNvbHVtbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2x1c3RlcmluZ0tleUNvbHVtblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpDYXNzYW5kcmE6OlRhYmxlLkNsdXN0ZXJpbmdLZXlDb2x1bW5gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuVGFibGVDbHVzdGVyaW5nS2V5Q29sdW1uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblRhYmxlX0NsdXN0ZXJpbmdLZXlDb2x1bW5Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQ29sdW1uOiBjZm5UYWJsZUNvbHVtblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNvbHVtbiksXG4gICAgICAgIE9yZGVyQnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMub3JkZXJCeSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblRhYmxlQ2x1c3RlcmluZ0tleUNvbHVtblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuVGFibGUuQ2x1c3RlcmluZ0tleUNvbHVtblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblRhYmxlLkNsdXN0ZXJpbmdLZXlDb2x1bW5Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2NvbHVtbicsICdDb2x1bW4nLCBDZm5UYWJsZUNvbHVtblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuQ29sdW1uKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdvcmRlckJ5JywgJ09yZGVyQnknLCBwcm9wZXJ0aWVzLk9yZGVyQnkgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuT3JkZXJCeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblRhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBhbmQgZGF0YSB0eXBlIG9mIGFuIGluZGl2aWR1YWwgY29sdW1uIGluIGEgdGFibGUuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1jYXNzYW5kcmEtdGFibGUtY29sdW1uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIENvbHVtblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIG9mIHRoZSBjb2x1bW4uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0lkZW50aWZpZXJzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va2V5c3BhY2VzL2xhdGVzdC9kZXZndWlkZS9jcWwuZWxlbWVudHMuaHRtbCNjcWwuZWxlbWVudHMuaWRlbnRpZmllcikgaW4gdGhlICpBbWF6b24gS2V5c3BhY2VzIERldmVsb3BlciBHdWlkZSogLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWNhc3NhbmRyYS10YWJsZS1jb2x1bW4uaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLWNvbHVtbi1jb2x1bW5uYW1lXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBjb2x1bW5OYW1lOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgZGF0YSB0eXBlIG9mIHRoZSBjb2x1bW4uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0RhdGEgdHlwZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rZXlzcGFjZXMvbGF0ZXN0L2Rldmd1aWRlL2NxbC5lbGVtZW50cy5odG1sI2NxbC5kYXRhLXR5cGVzKSBpbiB0aGUgKkFtYXpvbiBLZXlzcGFjZXMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtY2Fzc2FuZHJhLXRhYmxlLWNvbHVtbi5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtY29sdW1uLWNvbHVtbnR5cGVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGNvbHVtblR5cGU6IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ29sdW1uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENvbHVtblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblRhYmxlX0NvbHVtblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY29sdW1uTmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5jb2x1bW5OYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjb2x1bW5OYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmNvbHVtbk5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2NvbHVtblR5cGUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuY29sdW1uVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY29sdW1uVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb2x1bW5UeXBlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNvbHVtblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpDYXNzYW5kcmE6OlRhYmxlLkNvbHVtbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ29sdW1uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGUuQ29sdW1uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblRhYmxlQ29sdW1uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblRhYmxlX0NvbHVtblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBDb2x1bW5OYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNvbHVtbk5hbWUpLFxuICAgICAgICBDb2x1bW5UeXBlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNvbHVtblR5cGUpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5UYWJsZUNvbHVtblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuVGFibGUuQ29sdW1uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuVGFibGUuQ29sdW1uUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjb2x1bW5OYW1lJywgJ0NvbHVtbk5hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkNvbHVtbk5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2NvbHVtblR5cGUnLCAnQ29sdW1uVHlwZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQ29sdW1uVHlwZSkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblRhYmxlIHtcbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIGVuY3J5cHRpb24gYXQgcmVzdCBvcHRpb24gc2VsZWN0ZWQgZm9yIHRoZSB0YWJsZS5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWNhc3NhbmRyYS10YWJsZS1lbmNyeXB0aW9uc3BlY2lmaWNhdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBFbmNyeXB0aW9uU3BlY2lmaWNhdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBlbmNyeXB0aW9uIGF0IHJlc3Qgb3B0aW9ucyBmb3IgdGhlIHRhYmxlLlxuICAgICAgICAgKlxuICAgICAgICAgKiAtICpBV1Mgb3duZWQga2V5KiAoZGVmYXVsdCkgLSBgQVdTX09XTkVEX0tNU19LRVlgXG4gICAgICAgICAqIC0gKkN1c3RvbWVyIG1hbmFnZWQga2V5KiAtIGBDVVNUT01FUl9NQU5BR0VEX0tNU19LRVlgXG4gICAgICAgICAqXG4gICAgICAgICAqID4gSWYgeW91IGNob29zZSBgQ1VTVE9NRVJfTUFOQUdFRF9LTVNfS0VZYCAsIGEgYGttc19rZXlfaWRlbnRpZmllcmAgaW4gdGhlIGZvcm1hdCBvZiBhIGtleSBBUk4gaXMgcmVxdWlyZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIFZhbGlkIHZhbHVlczogYENVU1RPTUVSX01BTkFHRURfS01TX0tFWWAgfCBgQVdTX09XTkVEX0tNU19LRVlgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1jYXNzYW5kcmEtdGFibGUtZW5jcnlwdGlvbnNwZWNpZmljYXRpb24uaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLWVuY3J5cHRpb25zcGVjaWZpY2F0aW9uLWVuY3J5cHRpb250eXBlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBlbmNyeXB0aW9uVHlwZTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogUmVxdWlyZXMgYSBga21zX2tleV9pZGVudGlmaWVyYCBpbiB0aGUgZm9ybWF0IG9mIGEga2V5IEFSTi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1jYXNzYW5kcmEtdGFibGUtZW5jcnlwdGlvbnNwZWNpZmljYXRpb24uaHRtbCNjZm4tY2Fzc2FuZHJhLXRhYmxlLWVuY3J5cHRpb25zcGVjaWZpY2F0aW9uLWttc2tleWlkZW50aWZpZXJcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGttc0tleUlkZW50aWZpZXI/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYEVuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEVuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuVGFibGVfRW5jcnlwdGlvblNwZWNpZmljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2VuY3J5cHRpb25UeXBlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmVuY3J5cHRpb25UeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdlbmNyeXB0aW9uVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5lbmNyeXB0aW9uVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna21zS2V5SWRlbnRpZmllcicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5rbXNLZXlJZGVudGlmaWVyKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkVuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGUuRW5jcnlwdGlvblNwZWNpZmljYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEVuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNhc3NhbmRyYTo6VGFibGUuRW5jcnlwdGlvblNwZWNpZmljYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuVGFibGVFbmNyeXB0aW9uU3BlY2lmaWNhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5UYWJsZV9FbmNyeXB0aW9uU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBFbmNyeXB0aW9uVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5lbmNyeXB0aW9uVHlwZSksXG4gICAgICAgIEttc0tleUlkZW50aWZpZXI6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua21zS2V5SWRlbnRpZmllciksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblRhYmxlRW5jcnlwdGlvblNwZWNpZmljYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblRhYmxlLkVuY3J5cHRpb25TcGVjaWZpY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuVGFibGUuRW5jcnlwdGlvblNwZWNpZmljYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2VuY3J5cHRpb25UeXBlJywgJ0VuY3J5cHRpb25UeXBlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5FbmNyeXB0aW9uVHlwZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna21zS2V5SWRlbnRpZmllcicsICdLbXNLZXlJZGVudGlmaWVyJywgcHJvcGVydGllcy5LbXNLZXlJZGVudGlmaWVyICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkttc0tleUlkZW50aWZpZXIpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5UYWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHByb3Zpc2lvbmVkIHRocm91Z2hwdXQgZm9yIHRoZSB0YWJsZSwgd2hpY2ggY29uc2lzdHMgb2YgYFJlYWRDYXBhY2l0eVVuaXRzYCBhbmQgYFdyaXRlQ2FwYWNpdHlVbml0c2AgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtY2Fzc2FuZHJhLXRhYmxlLXByb3Zpc2lvbmVkdGhyb3VnaHB1dC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQcm92aXNpb25lZFRocm91Z2hwdXRQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgYW1vdW50IG9mIHJlYWQgY2FwYWNpdHkgdGhhdCdzIHByb3Zpc2lvbmVkIGZvciB0aGUgdGFibGUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1JlYWQvd3JpdGUgY2FwYWNpdHkgbW9kZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2tleXNwYWNlcy9sYXRlc3QvZGV2Z3VpZGUvUmVhZFdyaXRlQ2FwYWNpdHlNb2RlLmh0bWwpIGluIHRoZSAqQW1hem9uIEtleXNwYWNlcyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1jYXNzYW5kcmEtdGFibGUtcHJvdmlzaW9uZWR0aHJvdWdocHV0Lmh0bWwjY2ZuLWNhc3NhbmRyYS10YWJsZS1wcm92aXNpb25lZHRocm91Z2hwdXQtcmVhZGNhcGFjaXR5dW5pdHNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHJlYWRDYXBhY2l0eVVuaXRzOiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgYW1vdW50IG9mIHdyaXRlIGNhcGFjaXR5IHRoYXQncyBwcm92aXNpb25lZCBmb3IgdGhlIHRhYmxlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtSZWFkL3dyaXRlIGNhcGFjaXR5IG1vZGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rZXlzcGFjZXMvbGF0ZXN0L2Rldmd1aWRlL1JlYWRXcml0ZUNhcGFjaXR5TW9kZS5odG1sKSBpbiB0aGUgKkFtYXpvbiBLZXlzcGFjZXMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtY2Fzc2FuZHJhLXRhYmxlLXByb3Zpc2lvbmVkdGhyb3VnaHB1dC5odG1sI2Nmbi1jYXNzYW5kcmEtdGFibGUtcHJvdmlzaW9uZWR0aHJvdWdocHV0LXdyaXRlY2FwYWNpdHl1bml0c1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgd3JpdGVDYXBhY2l0eVVuaXRzOiBudW1iZXI7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFByb3Zpc2lvbmVkVGhyb3VnaHB1dFByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcm92aXNpb25lZFRocm91Z2hwdXRQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5UYWJsZV9Qcm92aXNpb25lZFRocm91Z2hwdXRQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3JlYWRDYXBhY2l0eVVuaXRzJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnJlYWRDYXBhY2l0eVVuaXRzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZWFkQ2FwYWNpdHlVbml0cycsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5yZWFkQ2FwYWNpdHlVbml0cykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignd3JpdGVDYXBhY2l0eVVuaXRzJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLndyaXRlQ2FwYWNpdHlVbml0cykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignd3JpdGVDYXBhY2l0eVVuaXRzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLndyaXRlQ2FwYWNpdHlVbml0cykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJQcm92aXNpb25lZFRocm91Z2hwdXRQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6Q2Fzc2FuZHJhOjpUYWJsZS5Qcm92aXNpb25lZFRocm91Z2hwdXRgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByb3Zpc2lvbmVkVGhyb3VnaHB1dFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpDYXNzYW5kcmE6OlRhYmxlLlByb3Zpc2lvbmVkVGhyb3VnaHB1dGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5UYWJsZVByb3Zpc2lvbmVkVGhyb3VnaHB1dFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5UYWJsZV9Qcm92aXNpb25lZFRocm91Z2hwdXRQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgUmVhZENhcGFjaXR5VW5pdHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVhZENhcGFjaXR5VW5pdHMpLFxuICAgICAgICBXcml0ZUNhcGFjaXR5VW5pdHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMud3JpdGVDYXBhY2l0eVVuaXRzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuVGFibGVQcm92aXNpb25lZFRocm91Z2hwdXRQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblRhYmxlLlByb3Zpc2lvbmVkVGhyb3VnaHB1dFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblRhYmxlLlByb3Zpc2lvbmVkVGhyb3VnaHB1dFByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVhZENhcGFjaXR5VW5pdHMnLCAnUmVhZENhcGFjaXR5VW5pdHMnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlJlYWRDYXBhY2l0eVVuaXRzKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd3cml0ZUNhcGFjaXR5VW5pdHMnLCAnV3JpdGVDYXBhY2l0eVVuaXRzJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5Xcml0ZUNhcGFjaXR5VW5pdHMpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cbiJdfQ==