"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupPlan = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const backup_generated_1 = require("./backup.generated");
const rule_1 = require("./rule");
const selection_1 = require("./selection");
const vault_1 = require("./vault");
/**
 * A backup plan
 */
class BackupPlan extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.rules = [];
        jsiiDeprecationWarnings.monocdk_aws_backup_BackupPlanProps(props);
        const plan = new backup_generated_1.CfnBackupPlan(this, 'Resource', {
            backupPlan: {
                advancedBackupSettings: this.advancedBackupSettings(props),
                backupPlanName: props.backupPlanName || id,
                backupPlanRule: core_1.Lazy.any({ produce: () => this.rules }, { omitEmptyArray: true }),
            },
        });
        this.backupPlanId = plan.attrBackupPlanId;
        this.backupPlanArn = plan.attrBackupPlanArn;
        this.versionId = plan.attrVersionId;
        this._backupVault = props.backupVault;
        for (const rule of props.backupPlanRules || []) {
            this.addRule(rule);
        }
    }
    /**
     * Import an existing backup plan
     */
    static fromBackupPlanId(scope, id, backupPlanId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.backupPlanId = backupPlanId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Daily with 35 day retention
     */
    static daily35DayRetention(scope, id, backupVault) {
        jsiiDeprecationWarnings.monocdk_aws_backup_IBackupVault(backupVault);
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        return plan;
    }
    /**
     * Daily and monthly with 1 year retention
     */
    static dailyMonthly1YearRetention(scope, id, backupVault) {
        jsiiDeprecationWarnings.monocdk_aws_backup_IBackupVault(backupVault);
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.monthly1Year());
        return plan;
    }
    /**
     * Daily, weekly and monthly with 5 year retention
     */
    static dailyWeeklyMonthly5YearRetention(scope, id, backupVault) {
        jsiiDeprecationWarnings.monocdk_aws_backup_IBackupVault(backupVault);
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.weekly());
        plan.addRule(rule_1.BackupPlanRule.monthly5Year());
        return plan;
    }
    /**
     * Daily, weekly and monthly with 7 year retention
     */
    static dailyWeeklyMonthly7YearRetention(scope, id, backupVault) {
        jsiiDeprecationWarnings.monocdk_aws_backup_IBackupVault(backupVault);
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.weekly());
        plan.addRule(rule_1.BackupPlanRule.monthly7Year());
        return plan;
    }
    advancedBackupSettings(props) {
        if (!props.windowsVss) {
            return undefined;
        }
        return [{
                backupOptions: {
                    WindowsVSS: 'enabled',
                },
                resourceType: 'EC2',
            }];
    }
    /**
     * Adds a rule to a plan
     *
     * @param rule the rule to add
     */
    addRule(rule) {
        var _b, _c, _d, _e, _f, _g;
        jsiiDeprecationWarnings.monocdk_aws_backup_BackupPlanRule(rule);
        let vault;
        if (rule.props.backupVault) {
            vault = rule.props.backupVault;
        }
        else if (this._backupVault) {
            vault = this._backupVault;
        }
        else {
            this._backupVault = new vault_1.BackupVault(this, 'Vault');
            vault = this._backupVault;
        }
        this.rules.push({
            completionWindowMinutes: (_b = rule.props.completionWindow) === null || _b === void 0 ? void 0 : _b.toMinutes(),
            lifecycle: (rule.props.deleteAfter || rule.props.moveToColdStorageAfter) && {
                deleteAfterDays: (_c = rule.props.deleteAfter) === null || _c === void 0 ? void 0 : _c.toDays(),
                moveToColdStorageAfterDays: (_d = rule.props.moveToColdStorageAfter) === null || _d === void 0 ? void 0 : _d.toDays(),
            },
            ruleName: (_e = rule.props.ruleName) !== null && _e !== void 0 ? _e : `${this.node.id}Rule${this.rules.length}`,
            scheduleExpression: (_f = rule.props.scheduleExpression) === null || _f === void 0 ? void 0 : _f.expressionString,
            startWindowMinutes: (_g = rule.props.startWindow) === null || _g === void 0 ? void 0 : _g.toMinutes(),
            enableContinuousBackup: rule.props.enableContinuousBackup,
            targetBackupVault: vault.backupVaultName,
        });
    }
    /**
     * The backup vault where backups are stored if not defined at
     * the rule level
     */
    get backupVault() {
        if (!this._backupVault) {
            // This cannot happen but is here to make TypeScript happy
            throw new Error('No backup vault!');
        }
        return this._backupVault;
    }
    /**
     * Adds a selection to this plan
     */
    addSelection(id, options) {
        jsiiDeprecationWarnings.monocdk_aws_backup_BackupSelectionOptions(options);
        return new selection_1.BackupSelection(this, id, {
            backupPlan: this,
            ...options,
        });
    }
    validate() {
        if (this.rules.length === 0) {
            return ['A backup plan must have at least 1 rule.'];
        }
        return [];
    }
}
exports.BackupPlan = BackupPlan;
_a = JSII_RTTI_SYMBOL_1;
BackupPlan[_a] = { fqn: "monocdk.aws_backup.BackupPlan", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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