"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnScalingPlan = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:31:26.534Z","fingerprint":"IOqEi8BoDZEN0issOcMSb/sIfnMcGQ7BeUgFXlKjeMk="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnScalingPlanProps`
 *
 * @param properties - the TypeScript properties of a `CfnScalingPlanProps`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlanPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('applicationSource', cdk.requiredValidator)(properties.applicationSource));
    errors.collect(cdk.propertyValidator('applicationSource', CfnScalingPlan_ApplicationSourcePropertyValidator)(properties.applicationSource));
    errors.collect(cdk.propertyValidator('scalingInstructions', cdk.requiredValidator)(properties.scalingInstructions));
    errors.collect(cdk.propertyValidator('scalingInstructions', cdk.listValidator(CfnScalingPlan_ScalingInstructionPropertyValidator))(properties.scalingInstructions));
    return errors.wrap('supplied properties not correct for "CfnScalingPlanProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan` resource
 *
 * @param properties - the TypeScript properties of a `CfnScalingPlanProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlanPropsValidator(properties).assertSuccess();
    return {
        ApplicationSource: cfnScalingPlanApplicationSourcePropertyToCloudFormation(properties.applicationSource),
        ScalingInstructions: cdk.listMapper(cfnScalingPlanScalingInstructionPropertyToCloudFormation)(properties.scalingInstructions),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('applicationSource', 'ApplicationSource', CfnScalingPlanApplicationSourcePropertyFromCloudFormation(properties.ApplicationSource));
    ret.addPropertyResult('scalingInstructions', 'ScalingInstructions', cfn_parse.FromCloudFormation.getArray(CfnScalingPlanScalingInstructionPropertyFromCloudFormation)(properties.ScalingInstructions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`
 *
 * The `AWS::AutoScalingPlans::ScalingPlan` resource defines an AWS Auto Scaling scaling plan. A scaling plan is used to scale application resources to size them appropriately to ensure that enough resource is available in the application at peak times and to reduce allocated resource during periods of low utilization. The following resources can be added to a scaling plan:
 *
 * - Amazon EC2 Auto Scaling groups
 * - Amazon EC2 Spot Fleet requests
 * - Amazon ECS services
 * - Amazon DynamoDB tables and global secondary indexes
 * - Amazon Aurora Replicas
 *
 * For more information, see the [AWS Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html) .
 *
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
class CfnScalingPlan extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScalingPlans::ScalingPlan`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnScalingPlan.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_autoscalingplans_CfnScalingPlanProps(props);
        cdk.requireProperty(props, 'applicationSource', this);
        cdk.requireProperty(props, 'scalingInstructions', this);
        this.attrScalingPlanName = cdk.Token.asString(this.getAtt('ScalingPlanName'));
        this.attrScalingPlanVersion = cdk.Token.asString(this.getAtt('ScalingPlanVersion'));
        this.applicationSource = props.applicationSource;
        this.scalingInstructions = props.scalingInstructions;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnScalingPlanPropsFromCloudFormation(resourceProperties);
        const ret = new CfnScalingPlan(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnScalingPlan.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            applicationSource: this.applicationSource,
            scalingInstructions: this.scalingInstructions,
        };
    }
    renderProperties(props) {
        return cfnScalingPlanPropsToCloudFormation(props);
    }
}
exports.CfnScalingPlan = CfnScalingPlan;
_a = JSII_RTTI_SYMBOL_1;
CfnScalingPlan[_a] = { fqn: "monocdk.aws_autoscalingplans.CfnScalingPlan", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnScalingPlan.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScalingPlans::ScalingPlan";
/**
 * Determine whether the given properties match those of a `ApplicationSourceProperty`
 *
 * @param properties - the TypeScript properties of a `ApplicationSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_ApplicationSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudFormationStackArn', cdk.validateString)(properties.cloudFormationStackArn));
    errors.collect(cdk.propertyValidator('tagFilters', cdk.listValidator(CfnScalingPlan_TagFilterPropertyValidator))(properties.tagFilters));
    return errors.wrap('supplied properties not correct for "ApplicationSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource` resource
 *
 * @param properties - the TypeScript properties of a `ApplicationSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanApplicationSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_ApplicationSourcePropertyValidator(properties).assertSuccess();
    return {
        CloudFormationStackARN: cdk.stringToCloudFormation(properties.cloudFormationStackArn),
        TagFilters: cdk.listMapper(cfnScalingPlanTagFilterPropertyToCloudFormation)(properties.tagFilters),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanApplicationSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudFormationStackArn', 'CloudFormationStackARN', properties.CloudFormationStackARN != null ? cfn_parse.FromCloudFormation.getString(properties.CloudFormationStackARN) : undefined);
    ret.addPropertyResult('tagFilters', 'TagFilters', properties.TagFilters != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPlanTagFilterPropertyFromCloudFormation)(properties.TagFilters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomizedLoadMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomizedLoadMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_CustomizedLoadMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dimensions', cdk.listValidator(CfnScalingPlan_MetricDimensionPropertyValidator))(properties.dimensions));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('namespace', cdk.requiredValidator)(properties.namespace));
    errors.collect(cdk.propertyValidator('namespace', cdk.validateString)(properties.namespace));
    errors.collect(cdk.propertyValidator('statistic', cdk.requiredValidator)(properties.statistic));
    errors.collect(cdk.propertyValidator('statistic', cdk.validateString)(properties.statistic));
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    return errors.wrap('supplied properties not correct for "CustomizedLoadMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.CustomizedLoadMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `CustomizedLoadMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.CustomizedLoadMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanCustomizedLoadMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_CustomizedLoadMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Dimensions: cdk.listMapper(cfnScalingPlanMetricDimensionPropertyToCloudFormation)(properties.dimensions),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        Namespace: cdk.stringToCloudFormation(properties.namespace),
        Statistic: cdk.stringToCloudFormation(properties.statistic),
        Unit: cdk.stringToCloudFormation(properties.unit),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanCustomizedLoadMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dimensions', 'Dimensions', properties.Dimensions != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPlanMetricDimensionPropertyFromCloudFormation)(properties.Dimensions) : undefined);
    ret.addPropertyResult('metricName', 'MetricName', cfn_parse.FromCloudFormation.getString(properties.MetricName));
    ret.addPropertyResult('namespace', 'Namespace', cfn_parse.FromCloudFormation.getString(properties.Namespace));
    ret.addPropertyResult('statistic', 'Statistic', cfn_parse.FromCloudFormation.getString(properties.Statistic));
    ret.addPropertyResult('unit', 'Unit', properties.Unit != null ? cfn_parse.FromCloudFormation.getString(properties.Unit) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomizedScalingMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomizedScalingMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_CustomizedScalingMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dimensions', cdk.listValidator(CfnScalingPlan_MetricDimensionPropertyValidator))(properties.dimensions));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('namespace', cdk.requiredValidator)(properties.namespace));
    errors.collect(cdk.propertyValidator('namespace', cdk.validateString)(properties.namespace));
    errors.collect(cdk.propertyValidator('statistic', cdk.requiredValidator)(properties.statistic));
    errors.collect(cdk.propertyValidator('statistic', cdk.validateString)(properties.statistic));
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    return errors.wrap('supplied properties not correct for "CustomizedScalingMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.CustomizedScalingMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `CustomizedScalingMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.CustomizedScalingMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanCustomizedScalingMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_CustomizedScalingMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Dimensions: cdk.listMapper(cfnScalingPlanMetricDimensionPropertyToCloudFormation)(properties.dimensions),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        Namespace: cdk.stringToCloudFormation(properties.namespace),
        Statistic: cdk.stringToCloudFormation(properties.statistic),
        Unit: cdk.stringToCloudFormation(properties.unit),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanCustomizedScalingMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dimensions', 'Dimensions', properties.Dimensions != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPlanMetricDimensionPropertyFromCloudFormation)(properties.Dimensions) : undefined);
    ret.addPropertyResult('metricName', 'MetricName', cfn_parse.FromCloudFormation.getString(properties.MetricName));
    ret.addPropertyResult('namespace', 'Namespace', cfn_parse.FromCloudFormation.getString(properties.Namespace));
    ret.addPropertyResult('statistic', 'Statistic', cfn_parse.FromCloudFormation.getString(properties.Statistic));
    ret.addPropertyResult('unit', 'Unit', properties.Unit != null ? cfn_parse.FromCloudFormation.getString(properties.Unit) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricDimensionProperty`
 *
 * @param properties - the TypeScript properties of a `MetricDimensionProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_MetricDimensionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "MetricDimensionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.MetricDimension` resource
 *
 * @param properties - the TypeScript properties of a `MetricDimensionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.MetricDimension` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanMetricDimensionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_MetricDimensionPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanMetricDimensionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredefinedLoadMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PredefinedLoadMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_PredefinedLoadMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedLoadMetricType', cdk.requiredValidator)(properties.predefinedLoadMetricType));
    errors.collect(cdk.propertyValidator('predefinedLoadMetricType', cdk.validateString)(properties.predefinedLoadMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredefinedLoadMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.PredefinedLoadMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `PredefinedLoadMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.PredefinedLoadMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanPredefinedLoadMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_PredefinedLoadMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        PredefinedLoadMetricType: cdk.stringToCloudFormation(properties.predefinedLoadMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanPredefinedLoadMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedLoadMetricType', 'PredefinedLoadMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedLoadMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredefinedScalingMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PredefinedScalingMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_PredefinedScalingMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedScalingMetricType', cdk.requiredValidator)(properties.predefinedScalingMetricType));
    errors.collect(cdk.propertyValidator('predefinedScalingMetricType', cdk.validateString)(properties.predefinedScalingMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredefinedScalingMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.PredefinedScalingMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `PredefinedScalingMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.PredefinedScalingMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanPredefinedScalingMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_PredefinedScalingMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        PredefinedScalingMetricType: cdk.stringToCloudFormation(properties.predefinedScalingMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanPredefinedScalingMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedScalingMetricType', 'PredefinedScalingMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedScalingMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ScalingInstructionProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingInstructionProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_ScalingInstructionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customizedLoadMetricSpecification', CfnScalingPlan_CustomizedLoadMetricSpecificationPropertyValidator)(properties.customizedLoadMetricSpecification));
    errors.collect(cdk.propertyValidator('disableDynamicScaling', cdk.validateBoolean)(properties.disableDynamicScaling));
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.requiredValidator)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.validateNumber)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.requiredValidator)(properties.minCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.validateNumber)(properties.minCapacity));
    errors.collect(cdk.propertyValidator('predefinedLoadMetricSpecification', CfnScalingPlan_PredefinedLoadMetricSpecificationPropertyValidator)(properties.predefinedLoadMetricSpecification));
    errors.collect(cdk.propertyValidator('predictiveScalingMaxCapacityBehavior', cdk.validateString)(properties.predictiveScalingMaxCapacityBehavior));
    errors.collect(cdk.propertyValidator('predictiveScalingMaxCapacityBuffer', cdk.validateNumber)(properties.predictiveScalingMaxCapacityBuffer));
    errors.collect(cdk.propertyValidator('predictiveScalingMode', cdk.validateString)(properties.predictiveScalingMode));
    errors.collect(cdk.propertyValidator('resourceId', cdk.requiredValidator)(properties.resourceId));
    errors.collect(cdk.propertyValidator('resourceId', cdk.validateString)(properties.resourceId));
    errors.collect(cdk.propertyValidator('scalableDimension', cdk.requiredValidator)(properties.scalableDimension));
    errors.collect(cdk.propertyValidator('scalableDimension', cdk.validateString)(properties.scalableDimension));
    errors.collect(cdk.propertyValidator('scalingPolicyUpdateBehavior', cdk.validateString)(properties.scalingPolicyUpdateBehavior));
    errors.collect(cdk.propertyValidator('scheduledActionBufferTime', cdk.validateNumber)(properties.scheduledActionBufferTime));
    errors.collect(cdk.propertyValidator('serviceNamespace', cdk.requiredValidator)(properties.serviceNamespace));
    errors.collect(cdk.propertyValidator('serviceNamespace', cdk.validateString)(properties.serviceNamespace));
    errors.collect(cdk.propertyValidator('targetTrackingConfigurations', cdk.requiredValidator)(properties.targetTrackingConfigurations));
    errors.collect(cdk.propertyValidator('targetTrackingConfigurations', cdk.listValidator(CfnScalingPlan_TargetTrackingConfigurationPropertyValidator))(properties.targetTrackingConfigurations));
    return errors.wrap('supplied properties not correct for "ScalingInstructionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.ScalingInstruction` resource
 *
 * @param properties - the TypeScript properties of a `ScalingInstructionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.ScalingInstruction` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanScalingInstructionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_ScalingInstructionPropertyValidator(properties).assertSuccess();
    return {
        CustomizedLoadMetricSpecification: cfnScalingPlanCustomizedLoadMetricSpecificationPropertyToCloudFormation(properties.customizedLoadMetricSpecification),
        DisableDynamicScaling: cdk.booleanToCloudFormation(properties.disableDynamicScaling),
        MaxCapacity: cdk.numberToCloudFormation(properties.maxCapacity),
        MinCapacity: cdk.numberToCloudFormation(properties.minCapacity),
        PredefinedLoadMetricSpecification: cfnScalingPlanPredefinedLoadMetricSpecificationPropertyToCloudFormation(properties.predefinedLoadMetricSpecification),
        PredictiveScalingMaxCapacityBehavior: cdk.stringToCloudFormation(properties.predictiveScalingMaxCapacityBehavior),
        PredictiveScalingMaxCapacityBuffer: cdk.numberToCloudFormation(properties.predictiveScalingMaxCapacityBuffer),
        PredictiveScalingMode: cdk.stringToCloudFormation(properties.predictiveScalingMode),
        ResourceId: cdk.stringToCloudFormation(properties.resourceId),
        ScalableDimension: cdk.stringToCloudFormation(properties.scalableDimension),
        ScalingPolicyUpdateBehavior: cdk.stringToCloudFormation(properties.scalingPolicyUpdateBehavior),
        ScheduledActionBufferTime: cdk.numberToCloudFormation(properties.scheduledActionBufferTime),
        ServiceNamespace: cdk.stringToCloudFormation(properties.serviceNamespace),
        TargetTrackingConfigurations: cdk.listMapper(cfnScalingPlanTargetTrackingConfigurationPropertyToCloudFormation)(properties.targetTrackingConfigurations),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanScalingInstructionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customizedLoadMetricSpecification', 'CustomizedLoadMetricSpecification', properties.CustomizedLoadMetricSpecification != null ? CfnScalingPlanCustomizedLoadMetricSpecificationPropertyFromCloudFormation(properties.CustomizedLoadMetricSpecification) : undefined);
    ret.addPropertyResult('disableDynamicScaling', 'DisableDynamicScaling', properties.DisableDynamicScaling != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableDynamicScaling) : undefined);
    ret.addPropertyResult('maxCapacity', 'MaxCapacity', cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity));
    ret.addPropertyResult('minCapacity', 'MinCapacity', cfn_parse.FromCloudFormation.getNumber(properties.MinCapacity));
    ret.addPropertyResult('predefinedLoadMetricSpecification', 'PredefinedLoadMetricSpecification', properties.PredefinedLoadMetricSpecification != null ? CfnScalingPlanPredefinedLoadMetricSpecificationPropertyFromCloudFormation(properties.PredefinedLoadMetricSpecification) : undefined);
    ret.addPropertyResult('predictiveScalingMaxCapacityBehavior', 'PredictiveScalingMaxCapacityBehavior', properties.PredictiveScalingMaxCapacityBehavior != null ? cfn_parse.FromCloudFormation.getString(properties.PredictiveScalingMaxCapacityBehavior) : undefined);
    ret.addPropertyResult('predictiveScalingMaxCapacityBuffer', 'PredictiveScalingMaxCapacityBuffer', properties.PredictiveScalingMaxCapacityBuffer != null ? cfn_parse.FromCloudFormation.getNumber(properties.PredictiveScalingMaxCapacityBuffer) : undefined);
    ret.addPropertyResult('predictiveScalingMode', 'PredictiveScalingMode', properties.PredictiveScalingMode != null ? cfn_parse.FromCloudFormation.getString(properties.PredictiveScalingMode) : undefined);
    ret.addPropertyResult('resourceId', 'ResourceId', cfn_parse.FromCloudFormation.getString(properties.ResourceId));
    ret.addPropertyResult('scalableDimension', 'ScalableDimension', cfn_parse.FromCloudFormation.getString(properties.ScalableDimension));
    ret.addPropertyResult('scalingPolicyUpdateBehavior', 'ScalingPolicyUpdateBehavior', properties.ScalingPolicyUpdateBehavior != null ? cfn_parse.FromCloudFormation.getString(properties.ScalingPolicyUpdateBehavior) : undefined);
    ret.addPropertyResult('scheduledActionBufferTime', 'ScheduledActionBufferTime', properties.ScheduledActionBufferTime != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScheduledActionBufferTime) : undefined);
    ret.addPropertyResult('serviceNamespace', 'ServiceNamespace', cfn_parse.FromCloudFormation.getString(properties.ServiceNamespace));
    ret.addPropertyResult('targetTrackingConfigurations', 'TargetTrackingConfigurations', cfn_parse.FromCloudFormation.getArray(CfnScalingPlanTargetTrackingConfigurationPropertyFromCloudFormation)(properties.TargetTrackingConfigurations));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TagFilterProperty`
 *
 * @param properties - the TypeScript properties of a `TagFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_TagFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "TagFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.TagFilter` resource
 *
 * @param properties - the TypeScript properties of a `TagFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.TagFilter` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanTagFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_TagFilterPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanTagFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetTrackingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPlan_TargetTrackingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customizedScalingMetricSpecification', CfnScalingPlan_CustomizedScalingMetricSpecificationPropertyValidator)(properties.customizedScalingMetricSpecification));
    errors.collect(cdk.propertyValidator('disableScaleIn', cdk.validateBoolean)(properties.disableScaleIn));
    errors.collect(cdk.propertyValidator('estimatedInstanceWarmup', cdk.validateNumber)(properties.estimatedInstanceWarmup));
    errors.collect(cdk.propertyValidator('predefinedScalingMetricSpecification', CfnScalingPlan_PredefinedScalingMetricSpecificationPropertyValidator)(properties.predefinedScalingMetricSpecification));
    errors.collect(cdk.propertyValidator('scaleInCooldown', cdk.validateNumber)(properties.scaleInCooldown));
    errors.collect(cdk.propertyValidator('scaleOutCooldown', cdk.validateNumber)(properties.scaleOutCooldown));
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "TargetTrackingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.TargetTrackingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScalingPlans::ScalingPlan.TargetTrackingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnScalingPlanTargetTrackingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPlan_TargetTrackingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomizedScalingMetricSpecification: cfnScalingPlanCustomizedScalingMetricSpecificationPropertyToCloudFormation(properties.customizedScalingMetricSpecification),
        DisableScaleIn: cdk.booleanToCloudFormation(properties.disableScaleIn),
        EstimatedInstanceWarmup: cdk.numberToCloudFormation(properties.estimatedInstanceWarmup),
        PredefinedScalingMetricSpecification: cfnScalingPlanPredefinedScalingMetricSpecificationPropertyToCloudFormation(properties.predefinedScalingMetricSpecification),
        ScaleInCooldown: cdk.numberToCloudFormation(properties.scaleInCooldown),
        ScaleOutCooldown: cdk.numberToCloudFormation(properties.scaleOutCooldown),
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnScalingPlanTargetTrackingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customizedScalingMetricSpecification', 'CustomizedScalingMetricSpecification', properties.CustomizedScalingMetricSpecification != null ? CfnScalingPlanCustomizedScalingMetricSpecificationPropertyFromCloudFormation(properties.CustomizedScalingMetricSpecification) : undefined);
    ret.addPropertyResult('disableScaleIn', 'DisableScaleIn', properties.DisableScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableScaleIn) : undefined);
    ret.addPropertyResult('estimatedInstanceWarmup', 'EstimatedInstanceWarmup', properties.EstimatedInstanceWarmup != null ? cfn_parse.FromCloudFormation.getNumber(properties.EstimatedInstanceWarmup) : undefined);
    ret.addPropertyResult('predefinedScalingMetricSpecification', 'PredefinedScalingMetricSpecification', properties.PredefinedScalingMetricSpecification != null ? CfnScalingPlanPredefinedScalingMetricSpecificationPropertyFromCloudFormation(properties.PredefinedScalingMetricSpecification) : undefined);
    ret.addPropertyResult('scaleInCooldown', 'ScaleInCooldown', properties.ScaleInCooldown != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScaleInCooldown) : undefined);
    ret.addPropertyResult('scaleOutCooldown', 'ScaleOutCooldown', properties.ScaleOutCooldown != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScaleOutCooldown) : undefined);
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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