"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnWarmPool = exports.CfnScheduledAction = exports.CfnScalingPolicy = exports.CfnLifecycleHook = exports.CfnLaunchConfiguration = exports.CfnAutoScalingGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:40:44.407Z","fingerprint":"i5QIgTm+oCXs7d041YYXoYC+4bUEmimP8TleX7Yq468="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnAutoScalingGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnAutoScalingGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('availabilityZones', cdk.listValidator(cdk.validateString))(properties.availabilityZones));
    errors.collect(cdk.propertyValidator('capacityRebalance', cdk.validateBoolean)(properties.capacityRebalance));
    errors.collect(cdk.propertyValidator('context', cdk.validateString)(properties.context));
    errors.collect(cdk.propertyValidator('cooldown', cdk.validateString)(properties.cooldown));
    errors.collect(cdk.propertyValidator('desiredCapacity', cdk.validateString)(properties.desiredCapacity));
    errors.collect(cdk.propertyValidator('desiredCapacityType', cdk.validateString)(properties.desiredCapacityType));
    errors.collect(cdk.propertyValidator('healthCheckGracePeriod', cdk.validateNumber)(properties.healthCheckGracePeriod));
    errors.collect(cdk.propertyValidator('healthCheckType', cdk.validateString)(properties.healthCheckType));
    errors.collect(cdk.propertyValidator('instanceId', cdk.validateString)(properties.instanceId));
    errors.collect(cdk.propertyValidator('launchConfigurationName', cdk.validateString)(properties.launchConfigurationName));
    errors.collect(cdk.propertyValidator('launchTemplate', CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('lifecycleHookSpecificationList', cdk.listValidator(CfnAutoScalingGroup_LifecycleHookSpecificationPropertyValidator))(properties.lifecycleHookSpecificationList));
    errors.collect(cdk.propertyValidator('loadBalancerNames', cdk.listValidator(cdk.validateString))(properties.loadBalancerNames));
    errors.collect(cdk.propertyValidator('maxInstanceLifetime', cdk.validateNumber)(properties.maxInstanceLifetime));
    errors.collect(cdk.propertyValidator('maxSize', cdk.requiredValidator)(properties.maxSize));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateString)(properties.maxSize));
    errors.collect(cdk.propertyValidator('metricsCollection', cdk.listValidator(CfnAutoScalingGroup_MetricsCollectionPropertyValidator))(properties.metricsCollection));
    errors.collect(cdk.propertyValidator('minSize', cdk.requiredValidator)(properties.minSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateString)(properties.minSize));
    errors.collect(cdk.propertyValidator('mixedInstancesPolicy', CfnAutoScalingGroup_MixedInstancesPolicyPropertyValidator)(properties.mixedInstancesPolicy));
    errors.collect(cdk.propertyValidator('newInstancesProtectedFromScaleIn', cdk.validateBoolean)(properties.newInstancesProtectedFromScaleIn));
    errors.collect(cdk.propertyValidator('notificationConfigurations', cdk.listValidator(CfnAutoScalingGroup_NotificationConfigurationPropertyValidator))(properties.notificationConfigurations));
    errors.collect(cdk.propertyValidator('placementGroup', cdk.validateString)(properties.placementGroup));
    errors.collect(cdk.propertyValidator('serviceLinkedRoleArn', cdk.validateString)(properties.serviceLinkedRoleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnAutoScalingGroup_TagPropertyPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('targetGroupArns', cdk.listValidator(cdk.validateString))(properties.targetGroupArns));
    errors.collect(cdk.propertyValidator('terminationPolicies', cdk.listValidator(cdk.validateString))(properties.terminationPolicies));
    errors.collect(cdk.propertyValidator('vpcZoneIdentifier', cdk.listValidator(cdk.validateString))(properties.vpcZoneIdentifier));
    return errors.wrap('supplied properties not correct for "CfnAutoScalingGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnAutoScalingGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroupPropsValidator(properties).assertSuccess();
    return {
        MaxSize: cdk.stringToCloudFormation(properties.maxSize),
        MinSize: cdk.stringToCloudFormation(properties.minSize),
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(properties.availabilityZones),
        CapacityRebalance: cdk.booleanToCloudFormation(properties.capacityRebalance),
        Context: cdk.stringToCloudFormation(properties.context),
        Cooldown: cdk.stringToCloudFormation(properties.cooldown),
        DesiredCapacity: cdk.stringToCloudFormation(properties.desiredCapacity),
        DesiredCapacityType: cdk.stringToCloudFormation(properties.desiredCapacityType),
        HealthCheckGracePeriod: cdk.numberToCloudFormation(properties.healthCheckGracePeriod),
        HealthCheckType: cdk.stringToCloudFormation(properties.healthCheckType),
        InstanceId: cdk.stringToCloudFormation(properties.instanceId),
        LaunchConfigurationName: cdk.stringToCloudFormation(properties.launchConfigurationName),
        LaunchTemplate: cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties.launchTemplate),
        LifecycleHookSpecificationList: cdk.listMapper(cfnAutoScalingGroupLifecycleHookSpecificationPropertyToCloudFormation)(properties.lifecycleHookSpecificationList),
        LoadBalancerNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.loadBalancerNames),
        MaxInstanceLifetime: cdk.numberToCloudFormation(properties.maxInstanceLifetime),
        MetricsCollection: cdk.listMapper(cfnAutoScalingGroupMetricsCollectionPropertyToCloudFormation)(properties.metricsCollection),
        MixedInstancesPolicy: cfnAutoScalingGroupMixedInstancesPolicyPropertyToCloudFormation(properties.mixedInstancesPolicy),
        NewInstancesProtectedFromScaleIn: cdk.booleanToCloudFormation(properties.newInstancesProtectedFromScaleIn),
        NotificationConfigurations: cdk.listMapper(cfnAutoScalingGroupNotificationConfigurationPropertyToCloudFormation)(properties.notificationConfigurations),
        PlacementGroup: cdk.stringToCloudFormation(properties.placementGroup),
        ServiceLinkedRoleARN: cdk.stringToCloudFormation(properties.serviceLinkedRoleArn),
        Tags: cdk.listMapper(cfnAutoScalingGroupTagPropertyPropertyToCloudFormation)(properties.tags),
        TargetGroupARNs: cdk.listMapper(cdk.stringToCloudFormation)(properties.targetGroupArns),
        TerminationPolicies: cdk.listMapper(cdk.stringToCloudFormation)(properties.terminationPolicies),
        VPCZoneIdentifier: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcZoneIdentifier),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxSize', 'MaxSize', cfn_parse.FromCloudFormation.getString(properties.MaxSize));
    ret.addPropertyResult('minSize', 'MinSize', cfn_parse.FromCloudFormation.getString(properties.MinSize));
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', properties.AutoScalingGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName) : undefined);
    ret.addPropertyResult('availabilityZones', 'AvailabilityZones', properties.AvailabilityZones != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AvailabilityZones) : undefined);
    ret.addPropertyResult('capacityRebalance', 'CapacityRebalance', properties.CapacityRebalance != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CapacityRebalance) : undefined);
    ret.addPropertyResult('context', 'Context', properties.Context != null ? cfn_parse.FromCloudFormation.getString(properties.Context) : undefined);
    ret.addPropertyResult('cooldown', 'Cooldown', properties.Cooldown != null ? cfn_parse.FromCloudFormation.getString(properties.Cooldown) : undefined);
    ret.addPropertyResult('desiredCapacity', 'DesiredCapacity', properties.DesiredCapacity != null ? cfn_parse.FromCloudFormation.getString(properties.DesiredCapacity) : undefined);
    ret.addPropertyResult('desiredCapacityType', 'DesiredCapacityType', properties.DesiredCapacityType != null ? cfn_parse.FromCloudFormation.getString(properties.DesiredCapacityType) : undefined);
    ret.addPropertyResult('healthCheckGracePeriod', 'HealthCheckGracePeriod', properties.HealthCheckGracePeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.HealthCheckGracePeriod) : undefined);
    ret.addPropertyResult('healthCheckType', 'HealthCheckType', properties.HealthCheckType != null ? cfn_parse.FromCloudFormation.getString(properties.HealthCheckType) : undefined);
    ret.addPropertyResult('instanceId', 'InstanceId', properties.InstanceId != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceId) : undefined);
    ret.addPropertyResult('launchConfigurationName', 'LaunchConfigurationName', properties.LaunchConfigurationName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchConfigurationName) : undefined);
    ret.addPropertyResult('launchTemplate', 'LaunchTemplate', properties.LaunchTemplate != null ? CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties.LaunchTemplate) : undefined);
    ret.addPropertyResult('lifecycleHookSpecificationList', 'LifecycleHookSpecificationList', properties.LifecycleHookSpecificationList != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupLifecycleHookSpecificationPropertyFromCloudFormation)(properties.LifecycleHookSpecificationList) : undefined);
    ret.addPropertyResult('loadBalancerNames', 'LoadBalancerNames', properties.LoadBalancerNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.LoadBalancerNames) : undefined);
    ret.addPropertyResult('maxInstanceLifetime', 'MaxInstanceLifetime', properties.MaxInstanceLifetime != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxInstanceLifetime) : undefined);
    ret.addPropertyResult('metricsCollection', 'MetricsCollection', properties.MetricsCollection != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupMetricsCollectionPropertyFromCloudFormation)(properties.MetricsCollection) : undefined);
    ret.addPropertyResult('mixedInstancesPolicy', 'MixedInstancesPolicy', properties.MixedInstancesPolicy != null ? CfnAutoScalingGroupMixedInstancesPolicyPropertyFromCloudFormation(properties.MixedInstancesPolicy) : undefined);
    ret.addPropertyResult('newInstancesProtectedFromScaleIn', 'NewInstancesProtectedFromScaleIn', properties.NewInstancesProtectedFromScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NewInstancesProtectedFromScaleIn) : undefined);
    ret.addPropertyResult('notificationConfigurations', 'NotificationConfigurations', properties.NotificationConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupNotificationConfigurationPropertyFromCloudFormation)(properties.NotificationConfigurations) : undefined);
    ret.addPropertyResult('placementGroup', 'PlacementGroup', properties.PlacementGroup != null ? cfn_parse.FromCloudFormation.getString(properties.PlacementGroup) : undefined);
    ret.addPropertyResult('serviceLinkedRoleArn', 'ServiceLinkedRoleARN', properties.ServiceLinkedRoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceLinkedRoleARN) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupTagPropertyPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('targetGroupArns', 'TargetGroupARNs', properties.TargetGroupARNs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.TargetGroupARNs) : undefined);
    ret.addPropertyResult('terminationPolicies', 'TerminationPolicies', properties.TerminationPolicies != null ? cfn_parse.FromCloudFormation.getStringArray(properties.TerminationPolicies) : undefined);
    ret.addPropertyResult('vpcZoneIdentifier', 'VPCZoneIdentifier', properties.VPCZoneIdentifier != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VPCZoneIdentifier) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`
 *
 * The `AWS::AutoScaling::AutoScalingGroup` resource defines an Amazon EC2 Auto Scaling group, which is a collection of Amazon EC2 instances that are treated as a logical grouping for the purposes of automatic scaling and management.
 *
 * > Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a launch template or a launch configuration. We recommend that you use a launch template to make sure that you can use the latest features of Amazon EC2, such as Dedicated Hosts and T2 Unlimited instances. For more information, see [Creating a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) . You can find sample launch templates in [AWS::EC2::LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) .
 *
 * For more information, see [CreateAutoScalingGroup](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html) and [UpdateAutoScalingGroup](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_UpdateAutoScalingGroup.html) in the *Amazon EC2 Auto Scaling API Reference* . For more information about Amazon EC2 Auto Scaling, see the [Amazon EC2 Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html) .
 *
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 */
class CfnAutoScalingGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::AutoScalingGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAutoScalingGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnAutoScalingGroupProps(props);
        cdk.requireProperty(props, 'maxSize', this);
        cdk.requireProperty(props, 'minSize', this);
        this.maxSize = props.maxSize;
        this.minSize = props.minSize;
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.availabilityZones = props.availabilityZones;
        this.capacityRebalance = props.capacityRebalance;
        this.context = props.context;
        this.cooldown = props.cooldown;
        this.desiredCapacity = props.desiredCapacity;
        this.desiredCapacityType = props.desiredCapacityType;
        this.healthCheckGracePeriod = props.healthCheckGracePeriod;
        this.healthCheckType = props.healthCheckType;
        this.instanceId = props.instanceId;
        this.launchConfigurationName = props.launchConfigurationName;
        this.launchTemplate = props.launchTemplate;
        this.lifecycleHookSpecificationList = props.lifecycleHookSpecificationList;
        this.loadBalancerNames = props.loadBalancerNames;
        this.maxInstanceLifetime = props.maxInstanceLifetime;
        this.metricsCollection = props.metricsCollection;
        this.mixedInstancesPolicy = props.mixedInstancesPolicy;
        this.newInstancesProtectedFromScaleIn = props.newInstancesProtectedFromScaleIn;
        this.notificationConfigurations = props.notificationConfigurations;
        this.placementGroup = props.placementGroup;
        this.serviceLinkedRoleArn = props.serviceLinkedRoleArn;
        this.tags = new cdk.TagManager(cdk.TagType.AUTOSCALING_GROUP, "AWS::AutoScaling::AutoScalingGroup", props.tags, { tagPropertyName: 'tags' });
        this.targetGroupArns = props.targetGroupArns;
        this.terminationPolicies = props.terminationPolicies;
        this.vpcZoneIdentifier = props.vpcZoneIdentifier;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAutoScalingGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAutoScalingGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAutoScalingGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            maxSize: this.maxSize,
            minSize: this.minSize,
            autoScalingGroupName: this.autoScalingGroupName,
            availabilityZones: this.availabilityZones,
            capacityRebalance: this.capacityRebalance,
            context: this.context,
            cooldown: this.cooldown,
            desiredCapacity: this.desiredCapacity,
            desiredCapacityType: this.desiredCapacityType,
            healthCheckGracePeriod: this.healthCheckGracePeriod,
            healthCheckType: this.healthCheckType,
            instanceId: this.instanceId,
            launchConfigurationName: this.launchConfigurationName,
            launchTemplate: this.launchTemplate,
            lifecycleHookSpecificationList: this.lifecycleHookSpecificationList,
            loadBalancerNames: this.loadBalancerNames,
            maxInstanceLifetime: this.maxInstanceLifetime,
            metricsCollection: this.metricsCollection,
            mixedInstancesPolicy: this.mixedInstancesPolicy,
            newInstancesProtectedFromScaleIn: this.newInstancesProtectedFromScaleIn,
            notificationConfigurations: this.notificationConfigurations,
            placementGroup: this.placementGroup,
            serviceLinkedRoleArn: this.serviceLinkedRoleArn,
            tags: this.tags.renderTags(),
            targetGroupArns: this.targetGroupArns,
            terminationPolicies: this.terminationPolicies,
            vpcZoneIdentifier: this.vpcZoneIdentifier,
        };
    }
    renderProperties(props) {
        return cfnAutoScalingGroupPropsToCloudFormation(props);
    }
}
exports.CfnAutoScalingGroup = CfnAutoScalingGroup;
_a = JSII_RTTI_SYMBOL_1;
CfnAutoScalingGroup[_a] = { fqn: "monocdk.aws_autoscaling.CfnAutoScalingGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAutoScalingGroup.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::AutoScalingGroup";
/**
 * Determine whether the given properties match those of a `AcceleratorCountRequestProperty`
 *
 * @param properties - the TypeScript properties of a `AcceleratorCountRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_AcceleratorCountRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "AcceleratorCountRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorCountRequest` resource
 *
 * @param properties - the TypeScript properties of a `AcceleratorCountRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorCountRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupAcceleratorCountRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_AcceleratorCountRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupAcceleratorCountRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AcceleratorTotalMemoryMiBRequestProperty`
 *
 * @param properties - the TypeScript properties of a `AcceleratorTotalMemoryMiBRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_AcceleratorTotalMemoryMiBRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "AcceleratorTotalMemoryMiBRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorTotalMemoryMiBRequest` resource
 *
 * @param properties - the TypeScript properties of a `AcceleratorTotalMemoryMiBRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorTotalMemoryMiBRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_AcceleratorTotalMemoryMiBRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BaselineEbsBandwidthMbpsRequestProperty`
 *
 * @param properties - the TypeScript properties of a `BaselineEbsBandwidthMbpsRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_BaselineEbsBandwidthMbpsRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "BaselineEbsBandwidthMbpsRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.BaselineEbsBandwidthMbpsRequest` resource
 *
 * @param properties - the TypeScript properties of a `BaselineEbsBandwidthMbpsRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.BaselineEbsBandwidthMbpsRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_BaselineEbsBandwidthMbpsRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InstanceRequirementsProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceRequirementsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_InstanceRequirementsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('acceleratorCount', CfnAutoScalingGroup_AcceleratorCountRequestPropertyValidator)(properties.acceleratorCount));
    errors.collect(cdk.propertyValidator('acceleratorManufacturers', cdk.listValidator(cdk.validateString))(properties.acceleratorManufacturers));
    errors.collect(cdk.propertyValidator('acceleratorNames', cdk.listValidator(cdk.validateString))(properties.acceleratorNames));
    errors.collect(cdk.propertyValidator('acceleratorTotalMemoryMiB', CfnAutoScalingGroup_AcceleratorTotalMemoryMiBRequestPropertyValidator)(properties.acceleratorTotalMemoryMiB));
    errors.collect(cdk.propertyValidator('acceleratorTypes', cdk.listValidator(cdk.validateString))(properties.acceleratorTypes));
    errors.collect(cdk.propertyValidator('bareMetal', cdk.validateString)(properties.bareMetal));
    errors.collect(cdk.propertyValidator('baselineEbsBandwidthMbps', CfnAutoScalingGroup_BaselineEbsBandwidthMbpsRequestPropertyValidator)(properties.baselineEbsBandwidthMbps));
    errors.collect(cdk.propertyValidator('burstablePerformance', cdk.validateString)(properties.burstablePerformance));
    errors.collect(cdk.propertyValidator('cpuManufacturers', cdk.listValidator(cdk.validateString))(properties.cpuManufacturers));
    errors.collect(cdk.propertyValidator('excludedInstanceTypes', cdk.listValidator(cdk.validateString))(properties.excludedInstanceTypes));
    errors.collect(cdk.propertyValidator('instanceGenerations', cdk.listValidator(cdk.validateString))(properties.instanceGenerations));
    errors.collect(cdk.propertyValidator('localStorage', cdk.validateString)(properties.localStorage));
    errors.collect(cdk.propertyValidator('localStorageTypes', cdk.listValidator(cdk.validateString))(properties.localStorageTypes));
    errors.collect(cdk.propertyValidator('memoryGiBPerVCpu', CfnAutoScalingGroup_MemoryGiBPerVCpuRequestPropertyValidator)(properties.memoryGiBPerVCpu));
    errors.collect(cdk.propertyValidator('memoryMiB', CfnAutoScalingGroup_MemoryMiBRequestPropertyValidator)(properties.memoryMiB));
    errors.collect(cdk.propertyValidator('networkInterfaceCount', CfnAutoScalingGroup_NetworkInterfaceCountRequestPropertyValidator)(properties.networkInterfaceCount));
    errors.collect(cdk.propertyValidator('onDemandMaxPricePercentageOverLowestPrice', cdk.validateNumber)(properties.onDemandMaxPricePercentageOverLowestPrice));
    errors.collect(cdk.propertyValidator('requireHibernateSupport', cdk.validateBoolean)(properties.requireHibernateSupport));
    errors.collect(cdk.propertyValidator('spotMaxPricePercentageOverLowestPrice', cdk.validateNumber)(properties.spotMaxPricePercentageOverLowestPrice));
    errors.collect(cdk.propertyValidator('totalLocalStorageGb', CfnAutoScalingGroup_TotalLocalStorageGBRequestPropertyValidator)(properties.totalLocalStorageGb));
    errors.collect(cdk.propertyValidator('vCpuCount', CfnAutoScalingGroup_VCpuCountRequestPropertyValidator)(properties.vCpuCount));
    return errors.wrap('supplied properties not correct for "InstanceRequirementsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstanceRequirements` resource
 *
 * @param properties - the TypeScript properties of a `InstanceRequirementsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstanceRequirements` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupInstanceRequirementsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_InstanceRequirementsPropertyValidator(properties).assertSuccess();
    return {
        AcceleratorCount: cfnAutoScalingGroupAcceleratorCountRequestPropertyToCloudFormation(properties.acceleratorCount),
        AcceleratorManufacturers: cdk.listMapper(cdk.stringToCloudFormation)(properties.acceleratorManufacturers),
        AcceleratorNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.acceleratorNames),
        AcceleratorTotalMemoryMiB: cfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyToCloudFormation(properties.acceleratorTotalMemoryMiB),
        AcceleratorTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.acceleratorTypes),
        BareMetal: cdk.stringToCloudFormation(properties.bareMetal),
        BaselineEbsBandwidthMbps: cfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyToCloudFormation(properties.baselineEbsBandwidthMbps),
        BurstablePerformance: cdk.stringToCloudFormation(properties.burstablePerformance),
        CpuManufacturers: cdk.listMapper(cdk.stringToCloudFormation)(properties.cpuManufacturers),
        ExcludedInstanceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludedInstanceTypes),
        InstanceGenerations: cdk.listMapper(cdk.stringToCloudFormation)(properties.instanceGenerations),
        LocalStorage: cdk.stringToCloudFormation(properties.localStorage),
        LocalStorageTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.localStorageTypes),
        MemoryGiBPerVCpu: cfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyToCloudFormation(properties.memoryGiBPerVCpu),
        MemoryMiB: cfnAutoScalingGroupMemoryMiBRequestPropertyToCloudFormation(properties.memoryMiB),
        NetworkInterfaceCount: cfnAutoScalingGroupNetworkInterfaceCountRequestPropertyToCloudFormation(properties.networkInterfaceCount),
        OnDemandMaxPricePercentageOverLowestPrice: cdk.numberToCloudFormation(properties.onDemandMaxPricePercentageOverLowestPrice),
        RequireHibernateSupport: cdk.booleanToCloudFormation(properties.requireHibernateSupport),
        SpotMaxPricePercentageOverLowestPrice: cdk.numberToCloudFormation(properties.spotMaxPricePercentageOverLowestPrice),
        TotalLocalStorageGB: cfnAutoScalingGroupTotalLocalStorageGBRequestPropertyToCloudFormation(properties.totalLocalStorageGb),
        VCpuCount: cfnAutoScalingGroupVCpuCountRequestPropertyToCloudFormation(properties.vCpuCount),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupInstanceRequirementsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('acceleratorCount', 'AcceleratorCount', properties.AcceleratorCount != null ? CfnAutoScalingGroupAcceleratorCountRequestPropertyFromCloudFormation(properties.AcceleratorCount) : undefined);
    ret.addPropertyResult('acceleratorManufacturers', 'AcceleratorManufacturers', properties.AcceleratorManufacturers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AcceleratorManufacturers) : undefined);
    ret.addPropertyResult('acceleratorNames', 'AcceleratorNames', properties.AcceleratorNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AcceleratorNames) : undefined);
    ret.addPropertyResult('acceleratorTotalMemoryMiB', 'AcceleratorTotalMemoryMiB', properties.AcceleratorTotalMemoryMiB != null ? CfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyFromCloudFormation(properties.AcceleratorTotalMemoryMiB) : undefined);
    ret.addPropertyResult('acceleratorTypes', 'AcceleratorTypes', properties.AcceleratorTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AcceleratorTypes) : undefined);
    ret.addPropertyResult('bareMetal', 'BareMetal', properties.BareMetal != null ? cfn_parse.FromCloudFormation.getString(properties.BareMetal) : undefined);
    ret.addPropertyResult('baselineEbsBandwidthMbps', 'BaselineEbsBandwidthMbps', properties.BaselineEbsBandwidthMbps != null ? CfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyFromCloudFormation(properties.BaselineEbsBandwidthMbps) : undefined);
    ret.addPropertyResult('burstablePerformance', 'BurstablePerformance', properties.BurstablePerformance != null ? cfn_parse.FromCloudFormation.getString(properties.BurstablePerformance) : undefined);
    ret.addPropertyResult('cpuManufacturers', 'CpuManufacturers', properties.CpuManufacturers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CpuManufacturers) : undefined);
    ret.addPropertyResult('excludedInstanceTypes', 'ExcludedInstanceTypes', properties.ExcludedInstanceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludedInstanceTypes) : undefined);
    ret.addPropertyResult('instanceGenerations', 'InstanceGenerations', properties.InstanceGenerations != null ? cfn_parse.FromCloudFormation.getStringArray(properties.InstanceGenerations) : undefined);
    ret.addPropertyResult('localStorage', 'LocalStorage', properties.LocalStorage != null ? cfn_parse.FromCloudFormation.getString(properties.LocalStorage) : undefined);
    ret.addPropertyResult('localStorageTypes', 'LocalStorageTypes', properties.LocalStorageTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.LocalStorageTypes) : undefined);
    ret.addPropertyResult('memoryGiBPerVCpu', 'MemoryGiBPerVCpu', properties.MemoryGiBPerVCpu != null ? CfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyFromCloudFormation(properties.MemoryGiBPerVCpu) : undefined);
    ret.addPropertyResult('memoryMiB', 'MemoryMiB', properties.MemoryMiB != null ? CfnAutoScalingGroupMemoryMiBRequestPropertyFromCloudFormation(properties.MemoryMiB) : undefined);
    ret.addPropertyResult('networkInterfaceCount', 'NetworkInterfaceCount', properties.NetworkInterfaceCount != null ? CfnAutoScalingGroupNetworkInterfaceCountRequestPropertyFromCloudFormation(properties.NetworkInterfaceCount) : undefined);
    ret.addPropertyResult('onDemandMaxPricePercentageOverLowestPrice', 'OnDemandMaxPricePercentageOverLowestPrice', properties.OnDemandMaxPricePercentageOverLowestPrice != null ? cfn_parse.FromCloudFormation.getNumber(properties.OnDemandMaxPricePercentageOverLowestPrice) : undefined);
    ret.addPropertyResult('requireHibernateSupport', 'RequireHibernateSupport', properties.RequireHibernateSupport != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireHibernateSupport) : undefined);
    ret.addPropertyResult('spotMaxPricePercentageOverLowestPrice', 'SpotMaxPricePercentageOverLowestPrice', properties.SpotMaxPricePercentageOverLowestPrice != null ? cfn_parse.FromCloudFormation.getNumber(properties.SpotMaxPricePercentageOverLowestPrice) : undefined);
    ret.addPropertyResult('totalLocalStorageGb', 'TotalLocalStorageGB', properties.TotalLocalStorageGB != null ? CfnAutoScalingGroupTotalLocalStorageGBRequestPropertyFromCloudFormation(properties.TotalLocalStorageGB) : undefined);
    ret.addPropertyResult('vCpuCount', 'VCpuCount', properties.VCpuCount != null ? CfnAutoScalingGroupVCpuCountRequestPropertyFromCloudFormation(properties.VCpuCount) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InstancesDistributionProperty`
 *
 * @param properties - the TypeScript properties of a `InstancesDistributionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_InstancesDistributionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('onDemandAllocationStrategy', cdk.validateString)(properties.onDemandAllocationStrategy));
    errors.collect(cdk.propertyValidator('onDemandBaseCapacity', cdk.validateNumber)(properties.onDemandBaseCapacity));
    errors.collect(cdk.propertyValidator('onDemandPercentageAboveBaseCapacity', cdk.validateNumber)(properties.onDemandPercentageAboveBaseCapacity));
    errors.collect(cdk.propertyValidator('spotAllocationStrategy', cdk.validateString)(properties.spotAllocationStrategy));
    errors.collect(cdk.propertyValidator('spotInstancePools', cdk.validateNumber)(properties.spotInstancePools));
    errors.collect(cdk.propertyValidator('spotMaxPrice', cdk.validateString)(properties.spotMaxPrice));
    return errors.wrap('supplied properties not correct for "InstancesDistributionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstancesDistribution` resource
 *
 * @param properties - the TypeScript properties of a `InstancesDistributionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstancesDistribution` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupInstancesDistributionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_InstancesDistributionPropertyValidator(properties).assertSuccess();
    return {
        OnDemandAllocationStrategy: cdk.stringToCloudFormation(properties.onDemandAllocationStrategy),
        OnDemandBaseCapacity: cdk.numberToCloudFormation(properties.onDemandBaseCapacity),
        OnDemandPercentageAboveBaseCapacity: cdk.numberToCloudFormation(properties.onDemandPercentageAboveBaseCapacity),
        SpotAllocationStrategy: cdk.stringToCloudFormation(properties.spotAllocationStrategy),
        SpotInstancePools: cdk.numberToCloudFormation(properties.spotInstancePools),
        SpotMaxPrice: cdk.stringToCloudFormation(properties.spotMaxPrice),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupInstancesDistributionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('onDemandAllocationStrategy', 'OnDemandAllocationStrategy', properties.OnDemandAllocationStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.OnDemandAllocationStrategy) : undefined);
    ret.addPropertyResult('onDemandBaseCapacity', 'OnDemandBaseCapacity', properties.OnDemandBaseCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.OnDemandBaseCapacity) : undefined);
    ret.addPropertyResult('onDemandPercentageAboveBaseCapacity', 'OnDemandPercentageAboveBaseCapacity', properties.OnDemandPercentageAboveBaseCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.OnDemandPercentageAboveBaseCapacity) : undefined);
    ret.addPropertyResult('spotAllocationStrategy', 'SpotAllocationStrategy', properties.SpotAllocationStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.SpotAllocationStrategy) : undefined);
    ret.addPropertyResult('spotInstancePools', 'SpotInstancePools', properties.SpotInstancePools != null ? cfn_parse.FromCloudFormation.getNumber(properties.SpotInstancePools) : undefined);
    ret.addPropertyResult('spotMaxPrice', 'SpotMaxPrice', properties.SpotMaxPrice != null ? cfn_parse.FromCloudFormation.getString(properties.SpotMaxPrice) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LaunchTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('launchTemplateSpecification', cdk.requiredValidator)(properties.launchTemplateSpecification));
    errors.collect(cdk.propertyValidator('launchTemplateSpecification', CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator)(properties.launchTemplateSpecification));
    errors.collect(cdk.propertyValidator('overrides', cdk.listValidator(CfnAutoScalingGroup_LaunchTemplateOverridesPropertyValidator))(properties.overrides));
    return errors.wrap('supplied properties not correct for "LaunchTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLaunchTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LaunchTemplatePropertyValidator(properties).assertSuccess();
    return {
        LaunchTemplateSpecification: cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties.launchTemplateSpecification),
        Overrides: cdk.listMapper(cfnAutoScalingGroupLaunchTemplateOverridesPropertyToCloudFormation)(properties.overrides),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLaunchTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('launchTemplateSpecification', 'LaunchTemplateSpecification', CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties.LaunchTemplateSpecification));
    ret.addPropertyResult('overrides', 'Overrides', properties.Overrides != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupLaunchTemplateOverridesPropertyFromCloudFormation)(properties.Overrides) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateOverridesProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateOverridesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LaunchTemplateOverridesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceRequirements', CfnAutoScalingGroup_InstanceRequirementsPropertyValidator)(properties.instanceRequirements));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('launchTemplateSpecification', CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator)(properties.launchTemplateSpecification));
    errors.collect(cdk.propertyValidator('weightedCapacity', cdk.validateString)(properties.weightedCapacity));
    return errors.wrap('supplied properties not correct for "LaunchTemplateOverridesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateOverridesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLaunchTemplateOverridesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LaunchTemplateOverridesPropertyValidator(properties).assertSuccess();
    return {
        InstanceRequirements: cfnAutoScalingGroupInstanceRequirementsPropertyToCloudFormation(properties.instanceRequirements),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        LaunchTemplateSpecification: cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties.launchTemplateSpecification),
        WeightedCapacity: cdk.stringToCloudFormation(properties.weightedCapacity),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLaunchTemplateOverridesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceRequirements', 'InstanceRequirements', properties.InstanceRequirements != null ? CfnAutoScalingGroupInstanceRequirementsPropertyFromCloudFormation(properties.InstanceRequirements) : undefined);
    ret.addPropertyResult('instanceType', 'InstanceType', properties.InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceType) : undefined);
    ret.addPropertyResult('launchTemplateSpecification', 'LaunchTemplateSpecification', properties.LaunchTemplateSpecification != null ? CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties.LaunchTemplateSpecification) : undefined);
    ret.addPropertyResult('weightedCapacity', 'WeightedCapacity', properties.WeightedCapacity != null ? cfn_parse.FromCloudFormation.getString(properties.WeightedCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('launchTemplateId', cdk.validateString)(properties.launchTemplateId));
    errors.collect(cdk.propertyValidator('launchTemplateName', cdk.validateString)(properties.launchTemplateName));
    errors.collect(cdk.propertyValidator('version', cdk.requiredValidator)(properties.version));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "LaunchTemplateSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator(properties).assertSuccess();
    return {
        LaunchTemplateId: cdk.stringToCloudFormation(properties.launchTemplateId),
        LaunchTemplateName: cdk.stringToCloudFormation(properties.launchTemplateName),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('launchTemplateId', 'LaunchTemplateId', properties.LaunchTemplateId != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateId) : undefined);
    ret.addPropertyResult('launchTemplateName', 'LaunchTemplateName', properties.LaunchTemplateName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateName) : undefined);
    ret.addPropertyResult('version', 'Version', cfn_parse.FromCloudFormation.getString(properties.Version));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LifecycleHookSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `LifecycleHookSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LifecycleHookSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultResult', cdk.validateString)(properties.defaultResult));
    errors.collect(cdk.propertyValidator('heartbeatTimeout', cdk.validateNumber)(properties.heartbeatTimeout));
    errors.collect(cdk.propertyValidator('lifecycleHookName', cdk.requiredValidator)(properties.lifecycleHookName));
    errors.collect(cdk.propertyValidator('lifecycleHookName', cdk.validateString)(properties.lifecycleHookName));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.requiredValidator)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.validateString)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('notificationMetadata', cdk.validateString)(properties.notificationMetadata));
    errors.collect(cdk.propertyValidator('notificationTargetArn', cdk.validateString)(properties.notificationTargetArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "LifecycleHookSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification` resource
 *
 * @param properties - the TypeScript properties of a `LifecycleHookSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLifecycleHookSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LifecycleHookSpecificationPropertyValidator(properties).assertSuccess();
    return {
        DefaultResult: cdk.stringToCloudFormation(properties.defaultResult),
        HeartbeatTimeout: cdk.numberToCloudFormation(properties.heartbeatTimeout),
        LifecycleHookName: cdk.stringToCloudFormation(properties.lifecycleHookName),
        LifecycleTransition: cdk.stringToCloudFormation(properties.lifecycleTransition),
        NotificationMetadata: cdk.stringToCloudFormation(properties.notificationMetadata),
        NotificationTargetARN: cdk.stringToCloudFormation(properties.notificationTargetArn),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLifecycleHookSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultResult', 'DefaultResult', properties.DefaultResult != null ? cfn_parse.FromCloudFormation.getString(properties.DefaultResult) : undefined);
    ret.addPropertyResult('heartbeatTimeout', 'HeartbeatTimeout', properties.HeartbeatTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.HeartbeatTimeout) : undefined);
    ret.addPropertyResult('lifecycleHookName', 'LifecycleHookName', cfn_parse.FromCloudFormation.getString(properties.LifecycleHookName));
    ret.addPropertyResult('lifecycleTransition', 'LifecycleTransition', cfn_parse.FromCloudFormation.getString(properties.LifecycleTransition));
    ret.addPropertyResult('notificationMetadata', 'NotificationMetadata', properties.NotificationMetadata != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationMetadata) : undefined);
    ret.addPropertyResult('notificationTargetArn', 'NotificationTargetARN', properties.NotificationTargetARN != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTargetARN) : undefined);
    ret.addPropertyResult('roleArn', 'RoleARN', properties.RoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.RoleARN) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MemoryGiBPerVCpuRequestProperty`
 *
 * @param properties - the TypeScript properties of a `MemoryGiBPerVCpuRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MemoryGiBPerVCpuRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "MemoryGiBPerVCpuRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryGiBPerVCpuRequest` resource
 *
 * @param properties - the TypeScript properties of a `MemoryGiBPerVCpuRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryGiBPerVCpuRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MemoryGiBPerVCpuRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MemoryMiBRequestProperty`
 *
 * @param properties - the TypeScript properties of a `MemoryMiBRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MemoryMiBRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "MemoryMiBRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryMiBRequest` resource
 *
 * @param properties - the TypeScript properties of a `MemoryMiBRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryMiBRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMemoryMiBRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MemoryMiBRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMemoryMiBRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricsCollectionProperty`
 *
 * @param properties - the TypeScript properties of a `MetricsCollectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MetricsCollectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('granularity', cdk.requiredValidator)(properties.granularity));
    errors.collect(cdk.propertyValidator('granularity', cdk.validateString)(properties.granularity));
    errors.collect(cdk.propertyValidator('metrics', cdk.listValidator(cdk.validateString))(properties.metrics));
    return errors.wrap('supplied properties not correct for "MetricsCollectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MetricsCollection` resource
 *
 * @param properties - the TypeScript properties of a `MetricsCollectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MetricsCollection` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMetricsCollectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MetricsCollectionPropertyValidator(properties).assertSuccess();
    return {
        Granularity: cdk.stringToCloudFormation(properties.granularity),
        Metrics: cdk.listMapper(cdk.stringToCloudFormation)(properties.metrics),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMetricsCollectionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('granularity', 'Granularity', cfn_parse.FromCloudFormation.getString(properties.Granularity));
    ret.addPropertyResult('metrics', 'Metrics', properties.Metrics != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Metrics) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MixedInstancesPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `MixedInstancesPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MixedInstancesPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instancesDistribution', CfnAutoScalingGroup_InstancesDistributionPropertyValidator)(properties.instancesDistribution));
    errors.collect(cdk.propertyValidator('launchTemplate', cdk.requiredValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('launchTemplate', CfnAutoScalingGroup_LaunchTemplatePropertyValidator)(properties.launchTemplate));
    return errors.wrap('supplied properties not correct for "MixedInstancesPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy` resource
 *
 * @param properties - the TypeScript properties of a `MixedInstancesPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMixedInstancesPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MixedInstancesPolicyPropertyValidator(properties).assertSuccess();
    return {
        InstancesDistribution: cfnAutoScalingGroupInstancesDistributionPropertyToCloudFormation(properties.instancesDistribution),
        LaunchTemplate: cfnAutoScalingGroupLaunchTemplatePropertyToCloudFormation(properties.launchTemplate),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMixedInstancesPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instancesDistribution', 'InstancesDistribution', properties.InstancesDistribution != null ? CfnAutoScalingGroupInstancesDistributionPropertyFromCloudFormation(properties.InstancesDistribution) : undefined);
    ret.addPropertyResult('launchTemplate', 'LaunchTemplate', CfnAutoScalingGroupLaunchTemplatePropertyFromCloudFormation(properties.LaunchTemplate));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkInterfaceCountRequestProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkInterfaceCountRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_NetworkInterfaceCountRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "NetworkInterfaceCountRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NetworkInterfaceCountRequest` resource
 *
 * @param properties - the TypeScript properties of a `NetworkInterfaceCountRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NetworkInterfaceCountRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupNetworkInterfaceCountRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_NetworkInterfaceCountRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupNetworkInterfaceCountRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NotificationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NotificationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_NotificationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('notificationTypes', cdk.listValidator(cdk.validateString))(properties.notificationTypes));
    errors.collect(cdk.propertyValidator('topicArn', cdk.requiredValidator)(properties.topicArn));
    errors.collect(cdk.propertyValidator('topicArn', cdk.validateString)(properties.topicArn));
    return errors.wrap('supplied properties not correct for "NotificationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NotificationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupNotificationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_NotificationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        NotificationTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.notificationTypes),
        TopicARN: cdk.stringToCloudFormation(properties.topicArn),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupNotificationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('notificationTypes', 'NotificationTypes', properties.NotificationTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotificationTypes) : undefined);
    ret.addPropertyResult('topicArn', 'TopicARN', cfn_parse.FromCloudFormation.getString(properties.TopicARN));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TagPropertyProperty`
 *
 * @param properties - the TypeScript properties of a `TagPropertyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_TagPropertyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('propagateAtLaunch', cdk.requiredValidator)(properties.propagateAtLaunch));
    errors.collect(cdk.propertyValidator('propagateAtLaunch', cdk.validateBoolean)(properties.propagateAtLaunch));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagPropertyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TagProperty` resource
 *
 * @param properties - the TypeScript properties of a `TagPropertyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TagProperty` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupTagPropertyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_TagPropertyPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        PropagateAtLaunch: cdk.booleanToCloudFormation(properties.propagateAtLaunch),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupTagPropertyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('propagateAtLaunch', 'PropagateAtLaunch', cfn_parse.FromCloudFormation.getBoolean(properties.PropagateAtLaunch));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TotalLocalStorageGBRequestProperty`
 *
 * @param properties - the TypeScript properties of a `TotalLocalStorageGBRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_TotalLocalStorageGBRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "TotalLocalStorageGBRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TotalLocalStorageGBRequest` resource
 *
 * @param properties - the TypeScript properties of a `TotalLocalStorageGBRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TotalLocalStorageGBRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupTotalLocalStorageGBRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_TotalLocalStorageGBRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupTotalLocalStorageGBRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VCpuCountRequestProperty`
 *
 * @param properties - the TypeScript properties of a `VCpuCountRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_VCpuCountRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "VCpuCountRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.VCpuCountRequest` resource
 *
 * @param properties - the TypeScript properties of a `VCpuCountRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.VCpuCountRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupVCpuCountRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_VCpuCountRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupVCpuCountRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLaunchConfigurationProps`
 *
 * @param properties - the TypeScript properties of a `CfnLaunchConfigurationProps`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfigurationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('associatePublicIpAddress', cdk.validateBoolean)(properties.associatePublicIpAddress));
    errors.collect(cdk.propertyValidator('blockDeviceMappings', cdk.listValidator(CfnLaunchConfiguration_BlockDeviceMappingPropertyValidator))(properties.blockDeviceMappings));
    errors.collect(cdk.propertyValidator('classicLinkVpcId', cdk.validateString)(properties.classicLinkVpcId));
    errors.collect(cdk.propertyValidator('classicLinkVpcSecurityGroups', cdk.listValidator(cdk.validateString))(properties.classicLinkVpcSecurityGroups));
    errors.collect(cdk.propertyValidator('ebsOptimized', cdk.validateBoolean)(properties.ebsOptimized));
    errors.collect(cdk.propertyValidator('iamInstanceProfile', cdk.validateString)(properties.iamInstanceProfile));
    errors.collect(cdk.propertyValidator('imageId', cdk.requiredValidator)(properties.imageId));
    errors.collect(cdk.propertyValidator('imageId', cdk.validateString)(properties.imageId));
    errors.collect(cdk.propertyValidator('instanceId', cdk.validateString)(properties.instanceId));
    errors.collect(cdk.propertyValidator('instanceMonitoring', cdk.validateBoolean)(properties.instanceMonitoring));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('kernelId', cdk.validateString)(properties.kernelId));
    errors.collect(cdk.propertyValidator('keyName', cdk.validateString)(properties.keyName));
    errors.collect(cdk.propertyValidator('launchConfigurationName', cdk.validateString)(properties.launchConfigurationName));
    errors.collect(cdk.propertyValidator('metadataOptions', CfnLaunchConfiguration_MetadataOptionsPropertyValidator)(properties.metadataOptions));
    errors.collect(cdk.propertyValidator('placementTenancy', cdk.validateString)(properties.placementTenancy));
    errors.collect(cdk.propertyValidator('ramDiskId', cdk.validateString)(properties.ramDiskId));
    errors.collect(cdk.propertyValidator('securityGroups', cdk.listValidator(cdk.validateString))(properties.securityGroups));
    errors.collect(cdk.propertyValidator('spotPrice', cdk.validateString)(properties.spotPrice));
    errors.collect(cdk.propertyValidator('userData', cdk.validateString)(properties.userData));
    return errors.wrap('supplied properties not correct for "CfnLaunchConfigurationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CfnLaunchConfigurationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfigurationPropsValidator(properties).assertSuccess();
    return {
        ImageId: cdk.stringToCloudFormation(properties.imageId),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        AssociatePublicIpAddress: cdk.booleanToCloudFormation(properties.associatePublicIpAddress),
        BlockDeviceMappings: cdk.listMapper(cfnLaunchConfigurationBlockDeviceMappingPropertyToCloudFormation)(properties.blockDeviceMappings),
        ClassicLinkVPCId: cdk.stringToCloudFormation(properties.classicLinkVpcId),
        ClassicLinkVPCSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.classicLinkVpcSecurityGroups),
        EbsOptimized: cdk.booleanToCloudFormation(properties.ebsOptimized),
        IamInstanceProfile: cdk.stringToCloudFormation(properties.iamInstanceProfile),
        InstanceId: cdk.stringToCloudFormation(properties.instanceId),
        InstanceMonitoring: cdk.booleanToCloudFormation(properties.instanceMonitoring),
        KernelId: cdk.stringToCloudFormation(properties.kernelId),
        KeyName: cdk.stringToCloudFormation(properties.keyName),
        LaunchConfigurationName: cdk.stringToCloudFormation(properties.launchConfigurationName),
        MetadataOptions: cfnLaunchConfigurationMetadataOptionsPropertyToCloudFormation(properties.metadataOptions),
        PlacementTenancy: cdk.stringToCloudFormation(properties.placementTenancy),
        RamDiskId: cdk.stringToCloudFormation(properties.ramDiskId),
        SecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroups),
        SpotPrice: cdk.stringToCloudFormation(properties.spotPrice),
        UserData: cdk.stringToCloudFormation(properties.userData),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('imageId', 'ImageId', cfn_parse.FromCloudFormation.getString(properties.ImageId));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('associatePublicIpAddress', 'AssociatePublicIpAddress', properties.AssociatePublicIpAddress != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AssociatePublicIpAddress) : undefined);
    ret.addPropertyResult('blockDeviceMappings', 'BlockDeviceMappings', properties.BlockDeviceMappings != null ? cfn_parse.FromCloudFormation.getArray(CfnLaunchConfigurationBlockDeviceMappingPropertyFromCloudFormation)(properties.BlockDeviceMappings) : undefined);
    ret.addPropertyResult('classicLinkVpcId', 'ClassicLinkVPCId', properties.ClassicLinkVPCId != null ? cfn_parse.FromCloudFormation.getString(properties.ClassicLinkVPCId) : undefined);
    ret.addPropertyResult('classicLinkVpcSecurityGroups', 'ClassicLinkVPCSecurityGroups', properties.ClassicLinkVPCSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ClassicLinkVPCSecurityGroups) : undefined);
    ret.addPropertyResult('ebsOptimized', 'EbsOptimized', properties.EbsOptimized != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EbsOptimized) : undefined);
    ret.addPropertyResult('iamInstanceProfile', 'IamInstanceProfile', properties.IamInstanceProfile != null ? cfn_parse.FromCloudFormation.getString(properties.IamInstanceProfile) : undefined);
    ret.addPropertyResult('instanceId', 'InstanceId', properties.InstanceId != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceId) : undefined);
    ret.addPropertyResult('instanceMonitoring', 'InstanceMonitoring', properties.InstanceMonitoring != null ? cfn_parse.FromCloudFormation.getBoolean(properties.InstanceMonitoring) : undefined);
    ret.addPropertyResult('kernelId', 'KernelId', properties.KernelId != null ? cfn_parse.FromCloudFormation.getString(properties.KernelId) : undefined);
    ret.addPropertyResult('keyName', 'KeyName', properties.KeyName != null ? cfn_parse.FromCloudFormation.getString(properties.KeyName) : undefined);
    ret.addPropertyResult('launchConfigurationName', 'LaunchConfigurationName', properties.LaunchConfigurationName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchConfigurationName) : undefined);
    ret.addPropertyResult('metadataOptions', 'MetadataOptions', properties.MetadataOptions != null ? CfnLaunchConfigurationMetadataOptionsPropertyFromCloudFormation(properties.MetadataOptions) : undefined);
    ret.addPropertyResult('placementTenancy', 'PlacementTenancy', properties.PlacementTenancy != null ? cfn_parse.FromCloudFormation.getString(properties.PlacementTenancy) : undefined);
    ret.addPropertyResult('ramDiskId', 'RamDiskId', properties.RamDiskId != null ? cfn_parse.FromCloudFormation.getString(properties.RamDiskId) : undefined);
    ret.addPropertyResult('securityGroups', 'SecurityGroups', properties.SecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroups) : undefined);
    ret.addPropertyResult('spotPrice', 'SpotPrice', properties.SpotPrice != null ? cfn_parse.FromCloudFormation.getString(properties.SpotPrice) : undefined);
    ret.addPropertyResult('userData', 'UserData', properties.UserData != null ? cfn_parse.FromCloudFormation.getString(properties.UserData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::LaunchConfiguration`
 *
 * The `AWS::AutoScaling::LaunchConfiguration` resource specifies the launch configuration that can be used by an Auto Scaling group to configure Amazon EC2 instances.
 *
 * When you update the launch configuration for an Auto Scaling group, CloudFormation deletes that resource and creates a new launch configuration with the updated properties and a new name. Existing instances are not affected. To update existing instances when you update the `AWS::AutoScaling::LaunchConfiguration` resource, you can specify an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html) for the group. You can find sample update policies for rolling updates in [Auto scaling template snippets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-autoscaling.html) .
 *
 * For more information, see [CreateLaunchConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateLaunchConfiguration.html) in the *Amazon EC2 Auto Scaling API Reference* and [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * > To configure Amazon EC2 instances launched as part of the Auto Scaling group, you can specify a launch template or a launch configuration. We recommend that you use a [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) to make sure that you can use the latest features of Amazon EC2, such as Dedicated Hosts and T2 Unlimited instances. For more information, see [Creating a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) .
 *
 * @cloudformationResource AWS::AutoScaling::LaunchConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html
 */
class CfnLaunchConfiguration extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::LaunchConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnLaunchConfigurationProps(props);
        cdk.requireProperty(props, 'imageId', this);
        cdk.requireProperty(props, 'instanceType', this);
        this.imageId = props.imageId;
        this.instanceType = props.instanceType;
        this.associatePublicIpAddress = props.associatePublicIpAddress;
        this.blockDeviceMappings = props.blockDeviceMappings;
        this.classicLinkVpcId = props.classicLinkVpcId;
        this.classicLinkVpcSecurityGroups = props.classicLinkVpcSecurityGroups;
        this.ebsOptimized = props.ebsOptimized;
        this.iamInstanceProfile = props.iamInstanceProfile;
        this.instanceId = props.instanceId;
        this.instanceMonitoring = props.instanceMonitoring;
        this.kernelId = props.kernelId;
        this.keyName = props.keyName;
        this.launchConfigurationName = props.launchConfigurationName;
        this.metadataOptions = props.metadataOptions;
        this.placementTenancy = props.placementTenancy;
        this.ramDiskId = props.ramDiskId;
        this.securityGroups = props.securityGroups;
        this.spotPrice = props.spotPrice;
        this.userData = props.userData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLaunchConfigurationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLaunchConfiguration(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            imageId: this.imageId,
            instanceType: this.instanceType,
            associatePublicIpAddress: this.associatePublicIpAddress,
            blockDeviceMappings: this.blockDeviceMappings,
            classicLinkVpcId: this.classicLinkVpcId,
            classicLinkVpcSecurityGroups: this.classicLinkVpcSecurityGroups,
            ebsOptimized: this.ebsOptimized,
            iamInstanceProfile: this.iamInstanceProfile,
            instanceId: this.instanceId,
            instanceMonitoring: this.instanceMonitoring,
            kernelId: this.kernelId,
            keyName: this.keyName,
            launchConfigurationName: this.launchConfigurationName,
            metadataOptions: this.metadataOptions,
            placementTenancy: this.placementTenancy,
            ramDiskId: this.ramDiskId,
            securityGroups: this.securityGroups,
            spotPrice: this.spotPrice,
            userData: this.userData,
        };
    }
    renderProperties(props) {
        return cfnLaunchConfigurationPropsToCloudFormation(props);
    }
}
exports.CfnLaunchConfiguration = CfnLaunchConfiguration;
_b = JSII_RTTI_SYMBOL_1;
CfnLaunchConfiguration[_b] = { fqn: "monocdk.aws_autoscaling.CfnLaunchConfiguration", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LaunchConfiguration";
/**
 * Determine whether the given properties match those of a `BlockDeviceProperty`
 *
 * @param properties - the TypeScript properties of a `BlockDeviceProperty`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfiguration_BlockDevicePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteOnTermination', cdk.validateBoolean)(properties.deleteOnTermination));
    errors.collect(cdk.propertyValidator('encrypted', cdk.validateBoolean)(properties.encrypted));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('snapshotId', cdk.validateString)(properties.snapshotId));
    errors.collect(cdk.propertyValidator('throughput', cdk.validateNumber)(properties.throughput));
    errors.collect(cdk.propertyValidator('volumeSize', cdk.validateNumber)(properties.volumeSize));
    errors.collect(cdk.propertyValidator('volumeType', cdk.validateString)(properties.volumeType));
    return errors.wrap('supplied properties not correct for "BlockDeviceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDevice` resource
 *
 * @param properties - the TypeScript properties of a `BlockDeviceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDevice` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationBlockDevicePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfiguration_BlockDevicePropertyValidator(properties).assertSuccess();
    return {
        DeleteOnTermination: cdk.booleanToCloudFormation(properties.deleteOnTermination),
        Encrypted: cdk.booleanToCloudFormation(properties.encrypted),
        Iops: cdk.numberToCloudFormation(properties.iops),
        SnapshotId: cdk.stringToCloudFormation(properties.snapshotId),
        Throughput: cdk.numberToCloudFormation(properties.throughput),
        VolumeSize: cdk.numberToCloudFormation(properties.volumeSize),
        VolumeType: cdk.stringToCloudFormation(properties.volumeType),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationBlockDevicePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deleteOnTermination', 'DeleteOnTermination', properties.DeleteOnTermination != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteOnTermination) : undefined);
    ret.addPropertyResult('encrypted', 'Encrypted', properties.Encrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Encrypted) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('snapshotId', 'SnapshotId', properties.SnapshotId != null ? cfn_parse.FromCloudFormation.getString(properties.SnapshotId) : undefined);
    ret.addPropertyResult('throughput', 'Throughput', properties.Throughput != null ? cfn_parse.FromCloudFormation.getNumber(properties.Throughput) : undefined);
    ret.addPropertyResult('volumeSize', 'VolumeSize', properties.VolumeSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.VolumeSize) : undefined);
    ret.addPropertyResult('volumeType', 'VolumeType', properties.VolumeType != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BlockDeviceMappingProperty`
 *
 * @param properties - the TypeScript properties of a `BlockDeviceMappingProperty`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfiguration_BlockDeviceMappingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deviceName', cdk.requiredValidator)(properties.deviceName));
    errors.collect(cdk.propertyValidator('deviceName', cdk.validateString)(properties.deviceName));
    errors.collect(cdk.propertyValidator('ebs', CfnLaunchConfiguration_BlockDevicePropertyValidator)(properties.ebs));
    errors.collect(cdk.propertyValidator('noDevice', cdk.validateBoolean)(properties.noDevice));
    errors.collect(cdk.propertyValidator('virtualName', cdk.validateString)(properties.virtualName));
    return errors.wrap('supplied properties not correct for "BlockDeviceMappingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping` resource
 *
 * @param properties - the TypeScript properties of a `BlockDeviceMappingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationBlockDeviceMappingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfiguration_BlockDeviceMappingPropertyValidator(properties).assertSuccess();
    return {
        DeviceName: cdk.stringToCloudFormation(properties.deviceName),
        Ebs: cfnLaunchConfigurationBlockDevicePropertyToCloudFormation(properties.ebs),
        NoDevice: cdk.booleanToCloudFormation(properties.noDevice),
        VirtualName: cdk.stringToCloudFormation(properties.virtualName),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationBlockDeviceMappingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deviceName', 'DeviceName', cfn_parse.FromCloudFormation.getString(properties.DeviceName));
    ret.addPropertyResult('ebs', 'Ebs', properties.Ebs != null ? CfnLaunchConfigurationBlockDevicePropertyFromCloudFormation(properties.Ebs) : undefined);
    ret.addPropertyResult('noDevice', 'NoDevice', properties.NoDevice != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NoDevice) : undefined);
    ret.addPropertyResult('virtualName', 'VirtualName', properties.VirtualName != null ? cfn_parse.FromCloudFormation.getString(properties.VirtualName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetadataOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MetadataOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfiguration_MetadataOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('httpEndpoint', cdk.validateString)(properties.httpEndpoint));
    errors.collect(cdk.propertyValidator('httpPutResponseHopLimit', cdk.validateNumber)(properties.httpPutResponseHopLimit));
    errors.collect(cdk.propertyValidator('httpTokens', cdk.validateString)(properties.httpTokens));
    return errors.wrap('supplied properties not correct for "MetadataOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.MetadataOptions` resource
 *
 * @param properties - the TypeScript properties of a `MetadataOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.MetadataOptions` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationMetadataOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfiguration_MetadataOptionsPropertyValidator(properties).assertSuccess();
    return {
        HttpEndpoint: cdk.stringToCloudFormation(properties.httpEndpoint),
        HttpPutResponseHopLimit: cdk.numberToCloudFormation(properties.httpPutResponseHopLimit),
        HttpTokens: cdk.stringToCloudFormation(properties.httpTokens),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationMetadataOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('httpEndpoint', 'HttpEndpoint', properties.HttpEndpoint != null ? cfn_parse.FromCloudFormation.getString(properties.HttpEndpoint) : undefined);
    ret.addPropertyResult('httpPutResponseHopLimit', 'HttpPutResponseHopLimit', properties.HttpPutResponseHopLimit != null ? cfn_parse.FromCloudFormation.getNumber(properties.HttpPutResponseHopLimit) : undefined);
    ret.addPropertyResult('httpTokens', 'HttpTokens', properties.HttpTokens != null ? cfn_parse.FromCloudFormation.getString(properties.HttpTokens) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLifecycleHookProps`
 *
 * @param properties - the TypeScript properties of a `CfnLifecycleHookProps`
 *
 * @returns the result of the validation.
 */
function CfnLifecycleHookPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('defaultResult', cdk.validateString)(properties.defaultResult));
    errors.collect(cdk.propertyValidator('heartbeatTimeout', cdk.validateNumber)(properties.heartbeatTimeout));
    errors.collect(cdk.propertyValidator('lifecycleHookName', cdk.validateString)(properties.lifecycleHookName));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.requiredValidator)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.validateString)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('notificationMetadata', cdk.validateString)(properties.notificationMetadata));
    errors.collect(cdk.propertyValidator('notificationTargetArn', cdk.validateString)(properties.notificationTargetArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "CfnLifecycleHookProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LifecycleHook` resource
 *
 * @param properties - the TypeScript properties of a `CfnLifecycleHookProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LifecycleHook` resource.
 */
// @ts-ignore TS6133
function cfnLifecycleHookPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLifecycleHookPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        LifecycleTransition: cdk.stringToCloudFormation(properties.lifecycleTransition),
        DefaultResult: cdk.stringToCloudFormation(properties.defaultResult),
        HeartbeatTimeout: cdk.numberToCloudFormation(properties.heartbeatTimeout),
        LifecycleHookName: cdk.stringToCloudFormation(properties.lifecycleHookName),
        NotificationMetadata: cdk.stringToCloudFormation(properties.notificationMetadata),
        NotificationTargetARN: cdk.stringToCloudFormation(properties.notificationTargetArn),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnLifecycleHookPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('lifecycleTransition', 'LifecycleTransition', cfn_parse.FromCloudFormation.getString(properties.LifecycleTransition));
    ret.addPropertyResult('defaultResult', 'DefaultResult', properties.DefaultResult != null ? cfn_parse.FromCloudFormation.getString(properties.DefaultResult) : undefined);
    ret.addPropertyResult('heartbeatTimeout', 'HeartbeatTimeout', properties.HeartbeatTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.HeartbeatTimeout) : undefined);
    ret.addPropertyResult('lifecycleHookName', 'LifecycleHookName', properties.LifecycleHookName != null ? cfn_parse.FromCloudFormation.getString(properties.LifecycleHookName) : undefined);
    ret.addPropertyResult('notificationMetadata', 'NotificationMetadata', properties.NotificationMetadata != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationMetadata) : undefined);
    ret.addPropertyResult('notificationTargetArn', 'NotificationTargetARN', properties.NotificationTargetARN != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTargetARN) : undefined);
    ret.addPropertyResult('roleArn', 'RoleARN', properties.RoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.RoleARN) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::LifecycleHook`
 *
 * The `AWS::AutoScaling::LifecycleHook` resource specifies lifecycle hooks for an Auto Scaling group. These hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and then perform a custom action on instances when the corresponding lifecycle event occurs. A lifecycle hook provides a specified amount of time (one hour by default) to wait for the action to complete before the instance transitions to the next state.
 *
 * Use lifecycle hooks to prepare new instances for use or to delay them from being registered behind a load balancer before their configuration has been applied completely. You can also use lifecycle hooks to prepare running instances to be terminated by, for example, downloading logs or other data.
 *
 * For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide* and [PutLifecycleHook](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PutLifecycleHook.html) in the *Amazon EC2 Auto Scaling API Reference* .
 *
 * @cloudformationResource AWS::AutoScaling::LifecycleHook
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-lifecyclehook.html
 */
class CfnLifecycleHook extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::LifecycleHook`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLifecycleHook.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnLifecycleHookProps(props);
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        cdk.requireProperty(props, 'lifecycleTransition', this);
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.lifecycleTransition = props.lifecycleTransition;
        this.defaultResult = props.defaultResult;
        this.heartbeatTimeout = props.heartbeatTimeout;
        this.lifecycleHookName = props.lifecycleHookName;
        this.notificationMetadata = props.notificationMetadata;
        this.notificationTargetArn = props.notificationTargetArn;
        this.roleArn = props.roleArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLifecycleHookPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLifecycleHook(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLifecycleHook.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            lifecycleTransition: this.lifecycleTransition,
            defaultResult: this.defaultResult,
            heartbeatTimeout: this.heartbeatTimeout,
            lifecycleHookName: this.lifecycleHookName,
            notificationMetadata: this.notificationMetadata,
            notificationTargetArn: this.notificationTargetArn,
            roleArn: this.roleArn,
        };
    }
    renderProperties(props) {
        return cfnLifecycleHookPropsToCloudFormation(props);
    }
}
exports.CfnLifecycleHook = CfnLifecycleHook;
_c = JSII_RTTI_SYMBOL_1;
CfnLifecycleHook[_c] = { fqn: "monocdk.aws_autoscaling.CfnLifecycleHook", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLifecycleHook.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LifecycleHook";
/**
 * Determine whether the given properties match those of a `CfnScalingPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnScalingPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adjustmentType', cdk.validateString)(properties.adjustmentType));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('cooldown', cdk.validateString)(properties.cooldown));
    errors.collect(cdk.propertyValidator('estimatedInstanceWarmup', cdk.validateNumber)(properties.estimatedInstanceWarmup));
    errors.collect(cdk.propertyValidator('metricAggregationType', cdk.validateString)(properties.metricAggregationType));
    errors.collect(cdk.propertyValidator('minAdjustmentMagnitude', cdk.validateNumber)(properties.minAdjustmentMagnitude));
    errors.collect(cdk.propertyValidator('policyType', cdk.validateString)(properties.policyType));
    errors.collect(cdk.propertyValidator('predictiveScalingConfiguration', CfnScalingPolicy_PredictiveScalingConfigurationPropertyValidator)(properties.predictiveScalingConfiguration));
    errors.collect(cdk.propertyValidator('scalingAdjustment', cdk.validateNumber)(properties.scalingAdjustment));
    errors.collect(cdk.propertyValidator('stepAdjustments', cdk.listValidator(CfnScalingPolicy_StepAdjustmentPropertyValidator))(properties.stepAdjustments));
    errors.collect(cdk.propertyValidator('targetTrackingConfiguration', CfnScalingPolicy_TargetTrackingConfigurationPropertyValidator)(properties.targetTrackingConfiguration));
    return errors.wrap('supplied properties not correct for "CfnScalingPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnScalingPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicyPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        AdjustmentType: cdk.stringToCloudFormation(properties.adjustmentType),
        Cooldown: cdk.stringToCloudFormation(properties.cooldown),
        EstimatedInstanceWarmup: cdk.numberToCloudFormation(properties.estimatedInstanceWarmup),
        MetricAggregationType: cdk.stringToCloudFormation(properties.metricAggregationType),
        MinAdjustmentMagnitude: cdk.numberToCloudFormation(properties.minAdjustmentMagnitude),
        PolicyType: cdk.stringToCloudFormation(properties.policyType),
        PredictiveScalingConfiguration: cfnScalingPolicyPredictiveScalingConfigurationPropertyToCloudFormation(properties.predictiveScalingConfiguration),
        ScalingAdjustment: cdk.numberToCloudFormation(properties.scalingAdjustment),
        StepAdjustments: cdk.listMapper(cfnScalingPolicyStepAdjustmentPropertyToCloudFormation)(properties.stepAdjustments),
        TargetTrackingConfiguration: cfnScalingPolicyTargetTrackingConfigurationPropertyToCloudFormation(properties.targetTrackingConfiguration),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('adjustmentType', 'AdjustmentType', properties.AdjustmentType != null ? cfn_parse.FromCloudFormation.getString(properties.AdjustmentType) : undefined);
    ret.addPropertyResult('cooldown', 'Cooldown', properties.Cooldown != null ? cfn_parse.FromCloudFormation.getString(properties.Cooldown) : undefined);
    ret.addPropertyResult('estimatedInstanceWarmup', 'EstimatedInstanceWarmup', properties.EstimatedInstanceWarmup != null ? cfn_parse.FromCloudFormation.getNumber(properties.EstimatedInstanceWarmup) : undefined);
    ret.addPropertyResult('metricAggregationType', 'MetricAggregationType', properties.MetricAggregationType != null ? cfn_parse.FromCloudFormation.getString(properties.MetricAggregationType) : undefined);
    ret.addPropertyResult('minAdjustmentMagnitude', 'MinAdjustmentMagnitude', properties.MinAdjustmentMagnitude != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinAdjustmentMagnitude) : undefined);
    ret.addPropertyResult('policyType', 'PolicyType', properties.PolicyType != null ? cfn_parse.FromCloudFormation.getString(properties.PolicyType) : undefined);
    ret.addPropertyResult('predictiveScalingConfiguration', 'PredictiveScalingConfiguration', properties.PredictiveScalingConfiguration != null ? CfnScalingPolicyPredictiveScalingConfigurationPropertyFromCloudFormation(properties.PredictiveScalingConfiguration) : undefined);
    ret.addPropertyResult('scalingAdjustment', 'ScalingAdjustment', properties.ScalingAdjustment != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScalingAdjustment) : undefined);
    ret.addPropertyResult('stepAdjustments', 'StepAdjustments', properties.StepAdjustments != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyStepAdjustmentPropertyFromCloudFormation)(properties.StepAdjustments) : undefined);
    ret.addPropertyResult('targetTrackingConfiguration', 'TargetTrackingConfiguration', properties.TargetTrackingConfiguration != null ? CfnScalingPolicyTargetTrackingConfigurationPropertyFromCloudFormation(properties.TargetTrackingConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`
 *
 * The `AWS::AutoScaling::ScalingPolicy` resource specifies an Amazon EC2 Auto Scaling scaling policy so that the Auto Scaling group can scale the number of instances available for your application.
 *
 * For more information about using scaling policies to scale your Auto Scaling group automatically, see [Dynamic scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scale-based-on-demand.html) and [Predictive scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 */
class CfnScalingPolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::ScalingPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnScalingPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnScalingPolicyProps(props);
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.adjustmentType = props.adjustmentType;
        this.cooldown = props.cooldown;
        this.estimatedInstanceWarmup = props.estimatedInstanceWarmup;
        this.metricAggregationType = props.metricAggregationType;
        this.minAdjustmentMagnitude = props.minAdjustmentMagnitude;
        this.policyType = props.policyType;
        this.predictiveScalingConfiguration = props.predictiveScalingConfiguration;
        this.scalingAdjustment = props.scalingAdjustment;
        this.stepAdjustments = props.stepAdjustments;
        this.targetTrackingConfiguration = props.targetTrackingConfiguration;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnScalingPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnScalingPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnScalingPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            adjustmentType: this.adjustmentType,
            cooldown: this.cooldown,
            estimatedInstanceWarmup: this.estimatedInstanceWarmup,
            metricAggregationType: this.metricAggregationType,
            minAdjustmentMagnitude: this.minAdjustmentMagnitude,
            policyType: this.policyType,
            predictiveScalingConfiguration: this.predictiveScalingConfiguration,
            scalingAdjustment: this.scalingAdjustment,
            stepAdjustments: this.stepAdjustments,
            targetTrackingConfiguration: this.targetTrackingConfiguration,
        };
    }
    renderProperties(props) {
        return cfnScalingPolicyPropsToCloudFormation(props);
    }
}
exports.CfnScalingPolicy = CfnScalingPolicy;
_d = JSII_RTTI_SYMBOL_1;
CfnScalingPolicy[_d] = { fqn: "monocdk.aws_autoscaling.CfnScalingPolicy", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnScalingPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScalingPolicy";
/**
 * Determine whether the given properties match those of a `CustomizedMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomizedMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_CustomizedMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dimensions', cdk.listValidator(CfnScalingPolicy_MetricDimensionPropertyValidator))(properties.dimensions));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('namespace', cdk.requiredValidator)(properties.namespace));
    errors.collect(cdk.propertyValidator('namespace', cdk.validateString)(properties.namespace));
    errors.collect(cdk.propertyValidator('statistic', cdk.requiredValidator)(properties.statistic));
    errors.collect(cdk.propertyValidator('statistic', cdk.validateString)(properties.statistic));
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    return errors.wrap('supplied properties not correct for "CustomizedMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `CustomizedMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyCustomizedMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_CustomizedMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Dimensions: cdk.listMapper(cfnScalingPolicyMetricDimensionPropertyToCloudFormation)(properties.dimensions),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        Namespace: cdk.stringToCloudFormation(properties.namespace),
        Statistic: cdk.stringToCloudFormation(properties.statistic),
        Unit: cdk.stringToCloudFormation(properties.unit),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyCustomizedMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dimensions', 'Dimensions', properties.Dimensions != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDimensionPropertyFromCloudFormation)(properties.Dimensions) : undefined);
    ret.addPropertyResult('metricName', 'MetricName', cfn_parse.FromCloudFormation.getString(properties.MetricName));
    ret.addPropertyResult('namespace', 'Namespace', cfn_parse.FromCloudFormation.getString(properties.Namespace));
    ret.addPropertyResult('statistic', 'Statistic', cfn_parse.FromCloudFormation.getString(properties.Statistic));
    ret.addPropertyResult('unit', 'Unit', properties.Unit != null ? cfn_parse.FromCloudFormation.getString(properties.Unit) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricProperty`
 *
 * @param properties - the TypeScript properties of a `MetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dimensions', cdk.listValidator(CfnScalingPolicy_MetricDimensionPropertyValidator))(properties.dimensions));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('namespace', cdk.requiredValidator)(properties.namespace));
    errors.collect(cdk.propertyValidator('namespace', cdk.validateString)(properties.namespace));
    return errors.wrap('supplied properties not correct for "MetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.Metric` resource
 *
 * @param properties - the TypeScript properties of a `MetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.Metric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricPropertyValidator(properties).assertSuccess();
    return {
        Dimensions: cdk.listMapper(cfnScalingPolicyMetricDimensionPropertyToCloudFormation)(properties.dimensions),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        Namespace: cdk.stringToCloudFormation(properties.namespace),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dimensions', 'Dimensions', properties.Dimensions != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDimensionPropertyFromCloudFormation)(properties.Dimensions) : undefined);
    ret.addPropertyResult('metricName', 'MetricName', cfn_parse.FromCloudFormation.getString(properties.MetricName));
    ret.addPropertyResult('namespace', 'Namespace', cfn_parse.FromCloudFormation.getString(properties.Namespace));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricDataQueryProperty`
 *
 * @param properties - the TypeScript properties of a `MetricDataQueryProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricDataQueryPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('label', cdk.validateString)(properties.label));
    errors.collect(cdk.propertyValidator('metricStat', CfnScalingPolicy_MetricStatPropertyValidator)(properties.metricStat));
    errors.collect(cdk.propertyValidator('returnData', cdk.validateBoolean)(properties.returnData));
    return errors.wrap('supplied properties not correct for "MetricDataQueryProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDataQuery` resource
 *
 * @param properties - the TypeScript properties of a `MetricDataQueryProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDataQuery` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricDataQueryPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricDataQueryPropertyValidator(properties).assertSuccess();
    return {
        Expression: cdk.stringToCloudFormation(properties.expression),
        Id: cdk.stringToCloudFormation(properties.id),
        Label: cdk.stringToCloudFormation(properties.label),
        MetricStat: cfnScalingPolicyMetricStatPropertyToCloudFormation(properties.metricStat),
        ReturnData: cdk.booleanToCloudFormation(properties.returnData),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('expression', 'Expression', properties.Expression != null ? cfn_parse.FromCloudFormation.getString(properties.Expression) : undefined);
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('label', 'Label', properties.Label != null ? cfn_parse.FromCloudFormation.getString(properties.Label) : undefined);
    ret.addPropertyResult('metricStat', 'MetricStat', properties.MetricStat != null ? CfnScalingPolicyMetricStatPropertyFromCloudFormation(properties.MetricStat) : undefined);
    ret.addPropertyResult('returnData', 'ReturnData', properties.ReturnData != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReturnData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricDimensionProperty`
 *
 * @param properties - the TypeScript properties of a `MetricDimensionProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricDimensionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "MetricDimensionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDimension` resource
 *
 * @param properties - the TypeScript properties of a `MetricDimensionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDimension` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricDimensionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricDimensionPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricDimensionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricStatProperty`
 *
 * @param properties - the TypeScript properties of a `MetricStatProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricStatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metric', cdk.requiredValidator)(properties.metric));
    errors.collect(cdk.propertyValidator('metric', CfnScalingPolicy_MetricPropertyValidator)(properties.metric));
    errors.collect(cdk.propertyValidator('stat', cdk.requiredValidator)(properties.stat));
    errors.collect(cdk.propertyValidator('stat', cdk.validateString)(properties.stat));
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    return errors.wrap('supplied properties not correct for "MetricStatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricStat` resource
 *
 * @param properties - the TypeScript properties of a `MetricStatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricStat` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricStatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricStatPropertyValidator(properties).assertSuccess();
    return {
        Metric: cfnScalingPolicyMetricPropertyToCloudFormation(properties.metric),
        Stat: cdk.stringToCloudFormation(properties.stat),
        Unit: cdk.stringToCloudFormation(properties.unit),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricStatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metric', 'Metric', CfnScalingPolicyMetricPropertyFromCloudFormation(properties.Metric));
    ret.addPropertyResult('stat', 'Stat', cfn_parse.FromCloudFormation.getString(properties.Stat));
    ret.addPropertyResult('unit', 'Unit', properties.Unit != null ? cfn_parse.FromCloudFormation.getString(properties.Unit) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredefinedMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PredefinedMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredefinedMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredefinedMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `PredefinedMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredefinedMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredefinedMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredefinedMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxCapacityBreachBehavior', cdk.validateString)(properties.maxCapacityBreachBehavior));
    errors.collect(cdk.propertyValidator('maxCapacityBuffer', cdk.validateNumber)(properties.maxCapacityBuffer));
    errors.collect(cdk.propertyValidator('metricSpecifications', cdk.requiredValidator)(properties.metricSpecifications));
    errors.collect(cdk.propertyValidator('metricSpecifications', cdk.listValidator(CfnScalingPolicy_PredictiveScalingMetricSpecificationPropertyValidator))(properties.metricSpecifications));
    errors.collect(cdk.propertyValidator('mode', cdk.validateString)(properties.mode));
    errors.collect(cdk.propertyValidator('schedulingBufferTime', cdk.validateNumber)(properties.schedulingBufferTime));
    return errors.wrap('supplied properties not correct for "PredictiveScalingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        MaxCapacityBreachBehavior: cdk.stringToCloudFormation(properties.maxCapacityBreachBehavior),
        MaxCapacityBuffer: cdk.numberToCloudFormation(properties.maxCapacityBuffer),
        MetricSpecifications: cdk.listMapper(cfnScalingPolicyPredictiveScalingMetricSpecificationPropertyToCloudFormation)(properties.metricSpecifications),
        Mode: cdk.stringToCloudFormation(properties.mode),
        SchedulingBufferTime: cdk.numberToCloudFormation(properties.schedulingBufferTime),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxCapacityBreachBehavior', 'MaxCapacityBreachBehavior', properties.MaxCapacityBreachBehavior != null ? cfn_parse.FromCloudFormation.getString(properties.MaxCapacityBreachBehavior) : undefined);
    ret.addPropertyResult('maxCapacityBuffer', 'MaxCapacityBuffer', properties.MaxCapacityBuffer != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacityBuffer) : undefined);
    ret.addPropertyResult('metricSpecifications', 'MetricSpecifications', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyPredictiveScalingMetricSpecificationPropertyFromCloudFormation)(properties.MetricSpecifications));
    ret.addPropertyResult('mode', 'Mode', properties.Mode != null ? cfn_parse.FromCloudFormation.getString(properties.Mode) : undefined);
    ret.addPropertyResult('schedulingBufferTime', 'SchedulingBufferTime', properties.SchedulingBufferTime != null ? cfn_parse.FromCloudFormation.getNumber(properties.SchedulingBufferTime) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingCustomizedCapacityMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedCapacityMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingCustomizedCapacityMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.requiredValidator)(properties.metricDataQueries));
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.listValidator(CfnScalingPolicy_MetricDataQueryPropertyValidator))(properties.metricDataQueries));
    return errors.wrap('supplied properties not correct for "PredictiveScalingCustomizedCapacityMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedCapacityMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedCapacityMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedCapacityMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingCustomizedCapacityMetricPropertyValidator(properties).assertSuccess();
    return {
        MetricDataQueries: cdk.listMapper(cfnScalingPolicyMetricDataQueryPropertyToCloudFormation)(properties.metricDataQueries),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricDataQueries', 'MetricDataQueries', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation)(properties.MetricDataQueries));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingCustomizedLoadMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedLoadMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingCustomizedLoadMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.requiredValidator)(properties.metricDataQueries));
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.listValidator(CfnScalingPolicy_MetricDataQueryPropertyValidator))(properties.metricDataQueries));
    return errors.wrap('supplied properties not correct for "PredictiveScalingCustomizedLoadMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedLoadMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedLoadMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedLoadMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingCustomizedLoadMetricPropertyValidator(properties).assertSuccess();
    return {
        MetricDataQueries: cdk.listMapper(cfnScalingPolicyMetricDataQueryPropertyToCloudFormation)(properties.metricDataQueries),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricDataQueries', 'MetricDataQueries', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation)(properties.MetricDataQueries));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingCustomizedScalingMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedScalingMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingCustomizedScalingMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.requiredValidator)(properties.metricDataQueries));
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.listValidator(CfnScalingPolicy_MetricDataQueryPropertyValidator))(properties.metricDataQueries));
    return errors.wrap('supplied properties not correct for "PredictiveScalingCustomizedScalingMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedScalingMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedScalingMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedScalingMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingCustomizedScalingMetricPropertyValidator(properties).assertSuccess();
    return {
        MetricDataQueries: cdk.listMapper(cfnScalingPolicyMetricDataQueryPropertyToCloudFormation)(properties.metricDataQueries),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricDataQueries', 'MetricDataQueries', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation)(properties.MetricDataQueries));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customizedCapacityMetricSpecification', CfnScalingPolicy_PredictiveScalingCustomizedCapacityMetricPropertyValidator)(properties.customizedCapacityMetricSpecification));
    errors.collect(cdk.propertyValidator('customizedLoadMetricSpecification', CfnScalingPolicy_PredictiveScalingCustomizedLoadMetricPropertyValidator)(properties.customizedLoadMetricSpecification));
    errors.collect(cdk.propertyValidator('customizedScalingMetricSpecification', CfnScalingPolicy_PredictiveScalingCustomizedScalingMetricPropertyValidator)(properties.customizedScalingMetricSpecification));
    errors.collect(cdk.propertyValidator('predefinedLoadMetricSpecification', CfnScalingPolicy_PredictiveScalingPredefinedLoadMetricPropertyValidator)(properties.predefinedLoadMetricSpecification));
    errors.collect(cdk.propertyValidator('predefinedMetricPairSpecification', CfnScalingPolicy_PredictiveScalingPredefinedMetricPairPropertyValidator)(properties.predefinedMetricPairSpecification));
    errors.collect(cdk.propertyValidator('predefinedScalingMetricSpecification', CfnScalingPolicy_PredictiveScalingPredefinedScalingMetricPropertyValidator)(properties.predefinedScalingMetricSpecification));
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "PredictiveScalingMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        CustomizedCapacityMetricSpecification: cfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyToCloudFormation(properties.customizedCapacityMetricSpecification),
        CustomizedLoadMetricSpecification: cfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyToCloudFormation(properties.customizedLoadMetricSpecification),
        CustomizedScalingMetricSpecification: cfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyToCloudFormation(properties.customizedScalingMetricSpecification),
        PredefinedLoadMetricSpecification: cfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyToCloudFormation(properties.predefinedLoadMetricSpecification),
        PredefinedMetricPairSpecification: cfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyToCloudFormation(properties.predefinedMetricPairSpecification),
        PredefinedScalingMetricSpecification: cfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyToCloudFormation(properties.predefinedScalingMetricSpecification),
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customizedCapacityMetricSpecification', 'CustomizedCapacityMetricSpecification', properties.CustomizedCapacityMetricSpecification != null ? CfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyFromCloudFormation(properties.CustomizedCapacityMetricSpecification) : undefined);
    ret.addPropertyResult('customizedLoadMetricSpecification', 'CustomizedLoadMetricSpecification', properties.CustomizedLoadMetricSpecification != null ? CfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyFromCloudFormation(properties.CustomizedLoadMetricSpecification) : undefined);
    ret.addPropertyResult('customizedScalingMetricSpecification', 'CustomizedScalingMetricSpecification', properties.CustomizedScalingMetricSpecification != null ? CfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyFromCloudFormation(properties.CustomizedScalingMetricSpecification) : undefined);
    ret.addPropertyResult('predefinedLoadMetricSpecification', 'PredefinedLoadMetricSpecification', properties.PredefinedLoadMetricSpecification != null ? CfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyFromCloudFormation(properties.PredefinedLoadMetricSpecification) : undefined);
    ret.addPropertyResult('predefinedMetricPairSpecification', 'PredefinedMetricPairSpecification', properties.PredefinedMetricPairSpecification != null ? CfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyFromCloudFormation(properties.PredefinedMetricPairSpecification) : undefined);
    ret.addPropertyResult('predefinedScalingMetricSpecification', 'PredefinedScalingMetricSpecification', properties.PredefinedScalingMetricSpecification != null ? CfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyFromCloudFormation(properties.PredefinedScalingMetricSpecification) : undefined);
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingPredefinedLoadMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedLoadMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingPredefinedLoadMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredictiveScalingPredefinedLoadMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedLoadMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedLoadMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedLoadMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingPredefinedLoadMetricPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingPredefinedMetricPairProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedMetricPairProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingPredefinedMetricPairPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredictiveScalingPredefinedMetricPairProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedMetricPair` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedMetricPairProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedMetricPair` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingPredefinedMetricPairPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingPredefinedScalingMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedScalingMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingPredefinedScalingMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredictiveScalingPredefinedScalingMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedScalingMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedScalingMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedScalingMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingPredefinedScalingMetricPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StepAdjustmentProperty`
 *
 * @param properties - the TypeScript properties of a `StepAdjustmentProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_StepAdjustmentPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricIntervalLowerBound', cdk.validateNumber)(properties.metricIntervalLowerBound));
    errors.collect(cdk.propertyValidator('metricIntervalUpperBound', cdk.validateNumber)(properties.metricIntervalUpperBound));
    errors.collect(cdk.propertyValidator('scalingAdjustment', cdk.requiredValidator)(properties.scalingAdjustment));
    errors.collect(cdk.propertyValidator('scalingAdjustment', cdk.validateNumber)(properties.scalingAdjustment));
    return errors.wrap('supplied properties not correct for "StepAdjustmentProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.StepAdjustment` resource
 *
 * @param properties - the TypeScript properties of a `StepAdjustmentProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.StepAdjustment` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyStepAdjustmentPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_StepAdjustmentPropertyValidator(properties).assertSuccess();
    return {
        MetricIntervalLowerBound: cdk.numberToCloudFormation(properties.metricIntervalLowerBound),
        MetricIntervalUpperBound: cdk.numberToCloudFormation(properties.metricIntervalUpperBound),
        ScalingAdjustment: cdk.numberToCloudFormation(properties.scalingAdjustment),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyStepAdjustmentPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricIntervalLowerBound', 'MetricIntervalLowerBound', properties.MetricIntervalLowerBound != null ? cfn_parse.FromCloudFormation.getNumber(properties.MetricIntervalLowerBound) : undefined);
    ret.addPropertyResult('metricIntervalUpperBound', 'MetricIntervalUpperBound', properties.MetricIntervalUpperBound != null ? cfn_parse.FromCloudFormation.getNumber(properties.MetricIntervalUpperBound) : undefined);
    ret.addPropertyResult('scalingAdjustment', 'ScalingAdjustment', cfn_parse.FromCloudFormation.getNumber(properties.ScalingAdjustment));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetTrackingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_TargetTrackingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customizedMetricSpecification', CfnScalingPolicy_CustomizedMetricSpecificationPropertyValidator)(properties.customizedMetricSpecification));
    errors.collect(cdk.propertyValidator('disableScaleIn', cdk.validateBoolean)(properties.disableScaleIn));
    errors.collect(cdk.propertyValidator('predefinedMetricSpecification', CfnScalingPolicy_PredefinedMetricSpecificationPropertyValidator)(properties.predefinedMetricSpecification));
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "TargetTrackingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyTargetTrackingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_TargetTrackingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomizedMetricSpecification: cfnScalingPolicyCustomizedMetricSpecificationPropertyToCloudFormation(properties.customizedMetricSpecification),
        DisableScaleIn: cdk.booleanToCloudFormation(properties.disableScaleIn),
        PredefinedMetricSpecification: cfnScalingPolicyPredefinedMetricSpecificationPropertyToCloudFormation(properties.predefinedMetricSpecification),
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyTargetTrackingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customizedMetricSpecification', 'CustomizedMetricSpecification', properties.CustomizedMetricSpecification != null ? CfnScalingPolicyCustomizedMetricSpecificationPropertyFromCloudFormation(properties.CustomizedMetricSpecification) : undefined);
    ret.addPropertyResult('disableScaleIn', 'DisableScaleIn', properties.DisableScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableScaleIn) : undefined);
    ret.addPropertyResult('predefinedMetricSpecification', 'PredefinedMetricSpecification', properties.PredefinedMetricSpecification != null ? CfnScalingPolicyPredefinedMetricSpecificationPropertyFromCloudFormation(properties.PredefinedMetricSpecification) : undefined);
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnScheduledActionProps`
 *
 * @param properties - the TypeScript properties of a `CfnScheduledActionProps`
 *
 * @returns the result of the validation.
 */
function CfnScheduledActionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('desiredCapacity', cdk.validateNumber)(properties.desiredCapacity));
    errors.collect(cdk.propertyValidator('endTime', cdk.validateString)(properties.endTime));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('recurrence', cdk.validateString)(properties.recurrence));
    errors.collect(cdk.propertyValidator('startTime', cdk.validateString)(properties.startTime));
    errors.collect(cdk.propertyValidator('timeZone', cdk.validateString)(properties.timeZone));
    return errors.wrap('supplied properties not correct for "CfnScheduledActionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScheduledAction` resource
 *
 * @param properties - the TypeScript properties of a `CfnScheduledActionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScheduledAction` resource.
 */
// @ts-ignore TS6133
function cfnScheduledActionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScheduledActionPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        DesiredCapacity: cdk.numberToCloudFormation(properties.desiredCapacity),
        EndTime: cdk.stringToCloudFormation(properties.endTime),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        Recurrence: cdk.stringToCloudFormation(properties.recurrence),
        StartTime: cdk.stringToCloudFormation(properties.startTime),
        TimeZone: cdk.stringToCloudFormation(properties.timeZone),
    };
}
// @ts-ignore TS6133
function CfnScheduledActionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('desiredCapacity', 'DesiredCapacity', properties.DesiredCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.DesiredCapacity) : undefined);
    ret.addPropertyResult('endTime', 'EndTime', properties.EndTime != null ? cfn_parse.FromCloudFormation.getString(properties.EndTime) : undefined);
    ret.addPropertyResult('maxSize', 'MaxSize', properties.MaxSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxSize) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('recurrence', 'Recurrence', properties.Recurrence != null ? cfn_parse.FromCloudFormation.getString(properties.Recurrence) : undefined);
    ret.addPropertyResult('startTime', 'StartTime', properties.StartTime != null ? cfn_parse.FromCloudFormation.getString(properties.StartTime) : undefined);
    ret.addPropertyResult('timeZone', 'TimeZone', properties.TimeZone != null ? cfn_parse.FromCloudFormation.getString(properties.TimeZone) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScheduledAction`
 *
 * The `AWS::AutoScaling::ScheduledAction` resource specifies an Amazon EC2 Auto Scaling scheduled action so that the Auto Scaling group can change the number of instances available for your application in response to predictable load changes.
 *
 * When you update a stack with an Auto Scaling group and scheduled action, CloudFormation always sets the min size, max size, and desired capacity properties of your group to the values that are defined in the `AWS::AutoScaling::AutoScalingGroup` section of your template. However, you might not want CloudFormation to do that when you have a scheduled action in effect. You can use an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html) to prevent CloudFormation from changing the min size, max size, or desired capacity property values during a stack update unless you modified the individual values in your template. If you have rolling updates enabled, before you can update the Auto Scaling group, you must suspend scheduled actions by specifying an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html) for the Auto Scaling group. You can find a sample update policy for rolling updates in [Auto scaling template snippets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-autoscaling.html) .
 *
 * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html) and [Suspending and resuming scaling processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * @cloudformationResource AWS::AutoScaling::ScheduledAction
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html
 */
class CfnScheduledAction extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::ScheduledAction`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnScheduledAction.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnScheduledActionProps(props);
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.desiredCapacity = props.desiredCapacity;
        this.endTime = props.endTime;
        this.maxSize = props.maxSize;
        this.minSize = props.minSize;
        this.recurrence = props.recurrence;
        this.startTime = props.startTime;
        this.timeZone = props.timeZone;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnScheduledActionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnScheduledAction(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnScheduledAction.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            desiredCapacity: this.desiredCapacity,
            endTime: this.endTime,
            maxSize: this.maxSize,
            minSize: this.minSize,
            recurrence: this.recurrence,
            startTime: this.startTime,
            timeZone: this.timeZone,
        };
    }
    renderProperties(props) {
        return cfnScheduledActionPropsToCloudFormation(props);
    }
}
exports.CfnScheduledAction = CfnScheduledAction;
_e = JSII_RTTI_SYMBOL_1;
CfnScheduledAction[_e] = { fqn: "monocdk.aws_autoscaling.CfnScheduledAction", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnScheduledAction.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScheduledAction";
/**
 * Determine whether the given properties match those of a `CfnWarmPoolProps`
 *
 * @param properties - the TypeScript properties of a `CfnWarmPoolProps`
 *
 * @returns the result of the validation.
 */
function CfnWarmPoolPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('instanceReusePolicy', CfnWarmPool_InstanceReusePolicyPropertyValidator)(properties.instanceReusePolicy));
    errors.collect(cdk.propertyValidator('maxGroupPreparedCapacity', cdk.validateNumber)(properties.maxGroupPreparedCapacity));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('poolState', cdk.validateString)(properties.poolState));
    return errors.wrap('supplied properties not correct for "CfnWarmPoolProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool` resource
 *
 * @param properties - the TypeScript properties of a `CfnWarmPoolProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool` resource.
 */
// @ts-ignore TS6133
function cfnWarmPoolPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWarmPoolPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        InstanceReusePolicy: cfnWarmPoolInstanceReusePolicyPropertyToCloudFormation(properties.instanceReusePolicy),
        MaxGroupPreparedCapacity: cdk.numberToCloudFormation(properties.maxGroupPreparedCapacity),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        PoolState: cdk.stringToCloudFormation(properties.poolState),
    };
}
// @ts-ignore TS6133
function CfnWarmPoolPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('instanceReusePolicy', 'InstanceReusePolicy', properties.InstanceReusePolicy != null ? CfnWarmPoolInstanceReusePolicyPropertyFromCloudFormation(properties.InstanceReusePolicy) : undefined);
    ret.addPropertyResult('maxGroupPreparedCapacity', 'MaxGroupPreparedCapacity', properties.MaxGroupPreparedCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxGroupPreparedCapacity) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('poolState', 'PoolState', properties.PoolState != null ? cfn_parse.FromCloudFormation.getString(properties.PoolState) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::WarmPool`
 *
 * The `AWS::AutoScaling::WarmPool` resource creates a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity.
 *
 * When you create a warm pool, you can define a minimum size. When your Auto Scaling group scales out and the size of the warm pool shrinks, Amazon EC2 Auto Scaling launches new instances into the warm pool to maintain its minimum size.
 *
 * For more information, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * > CloudFormation supports the `UpdatePolicy` attribute for Auto Scaling groups. During an update, if `UpdatePolicy` is set to `AutoScalingRollingUpdate` , CloudFormation replaces `InService` instances only. Instances in the warm pool are not replaced. The difference in which instances are replaced can potentially result in different instance configurations after the stack update completes. If `UpdatePolicy` is set to `AutoScalingReplacingUpdate` , you do not encounter this issue because CloudFormation replaces both the Auto Scaling group and the warm pool.
 *
 * @cloudformationResource AWS::AutoScaling::WarmPool
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html
 */
class CfnWarmPool extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::WarmPool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnWarmPool.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnWarmPoolProps(props);
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.instanceReusePolicy = props.instanceReusePolicy;
        this.maxGroupPreparedCapacity = props.maxGroupPreparedCapacity;
        this.minSize = props.minSize;
        this.poolState = props.poolState;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnWarmPoolPropsFromCloudFormation(resourceProperties);
        const ret = new CfnWarmPool(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnWarmPool.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            instanceReusePolicy: this.instanceReusePolicy,
            maxGroupPreparedCapacity: this.maxGroupPreparedCapacity,
            minSize: this.minSize,
            poolState: this.poolState,
        };
    }
    renderProperties(props) {
        return cfnWarmPoolPropsToCloudFormation(props);
    }
}
exports.CfnWarmPool = CfnWarmPool;
_f = JSII_RTTI_SYMBOL_1;
CfnWarmPool[_f] = { fqn: "monocdk.aws_autoscaling.CfnWarmPool", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnWarmPool.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::WarmPool";
/**
 * Determine whether the given properties match those of a `InstanceReusePolicyProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceReusePolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnWarmPool_InstanceReusePolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('reuseOnScaleIn', cdk.validateBoolean)(properties.reuseOnScaleIn));
    return errors.wrap('supplied properties not correct for "InstanceReusePolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool.InstanceReusePolicy` resource
 *
 * @param properties - the TypeScript properties of a `InstanceReusePolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool.InstanceReusePolicy` resource.
 */
// @ts-ignore TS6133
function cfnWarmPoolInstanceReusePolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWarmPool_InstanceReusePolicyPropertyValidator(properties).assertSuccess();
    return {
        ReuseOnScaleIn: cdk.booleanToCloudFormation(properties.reuseOnScaleIn),
    };
}
// @ts-ignore TS6133
function CfnWarmPoolInstanceReusePolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('reuseOnScaleIn', 'ReuseOnScaleIn', properties.ReuseOnScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReuseOnScaleIn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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