"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingGroupRequireImdsv2Aspect = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core");
const auto_scaling_group_1 = require("../auto-scaling-group");
/**
 * Aspect that makes IMDSv2 required on instances deployed by AutoScalingGroups.
 */
class AutoScalingGroupRequireImdsv2Aspect {
    constructor() {
    }
    visit(node) {
        jsiiDeprecationWarnings.monocdk_IConstruct(node);
        if (!(node instanceof auto_scaling_group_1.AutoScalingGroup)) {
            return;
        }
        const launchConfig = node.node.tryFindChild('LaunchConfig');
        if (cdk.isResolvableObject(launchConfig.metadataOptions)) {
            this.warn(node, 'CfnLaunchConfiguration.MetadataOptions field is a CDK token.');
            return;
        }
        launchConfig.metadataOptions = {
            ...launchConfig.metadataOptions,
            httpTokens: 'required',
        };
    }
    /**
     * Adds a warning annotation to a node.
     *
     * @param node The scope to add the warning to.
     * @param message The warning message.
     */
    warn(node, message) {
        jsiiDeprecationWarnings.monocdk_IConstruct(node);
        cdk.Annotations.of(node).addWarning(`${AutoScalingGroupRequireImdsv2Aspect.name} failed on node ${node.node.id}: ${message}`);
    }
}
exports.AutoScalingGroupRequireImdsv2Aspect = AutoScalingGroupRequireImdsv2Aspect;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingGroupRequireImdsv2Aspect[_a] = { fqn: "monocdk.aws_autoscaling.AutoScalingGroupRequireImdsv2Aspect", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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