"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("../../aws-sns");
const subs = require("../../aws-sns-subscriptions");
const common_1 = require("./common");
const topic_hook_1 = require("./topic-hook");
/**
 * Use a Lambda Function as a hook target
 *
 * Internally creates a Topic to make the connection.
 */
class FunctionHook {
    /**
     * @param fn Function to invoke in response to a lifecycle event
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     */
    constructor(fn, encryptionKey) {
        this.fn = fn;
        this.encryptionKey = encryptionKey;
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
        jsiiDeprecationWarnings.monocdk_aws_kms_IKey(encryptionKey);
    }
    /**
     * If the `IRole` does not exist in `options`, will create an `IRole` and an SNS Topic and attach both to the lifecycle hook.
     * If the `IRole` does exist in `options`, will only create an SNS Topic and attach it to the lifecycle hook.
     */
    bind(_scope, options) {
        var _b;
        jsiiDeprecationWarnings.monocdk_aws_autoscaling_BindHookTargetOptions(options);
        const topic = new sns.Topic(_scope, 'Topic', {
            masterKey: this.encryptionKey,
        });
        const role = common_1.createRole(_scope, options.role);
        // Per: https://docs.aws.amazon.com/sns/latest/dg/sns-key-management.html#sns-what-permissions-for-sse
        // Topic's grantPublish() is in a base class that does not know there is a kms key, and so does not
        // grant appropriate permissions to the kms key. We do that here to ensure the correct permissions
        // are in place.
        (_b = this.encryptionKey) === null || _b === void 0 ? void 0 : _b.grant(role, 'kms:Decrypt', 'kms:GenerateDataKey');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(_scope, { lifecycleHook: options.lifecycleHook, role });
    }
}
exports.FunctionHook = FunctionHook;
_a = JSII_RTTI_SYMBOL_1;
FunctionHook[_a] = { fqn: "monocdk.aws_autoscaling_hooktargets.FunctionHook", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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