"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Values = exports.AttributeValuesStep = exports.AttributeValues = exports.PartitionKey = exports.PrimaryKey = exports.SortKeyStep = exports.PartitionKeyStep = exports.Assign = exports.KeyCondition = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const private_1 = require("./private");
/**
 * Factory class for DynamoDB key conditions.
 */
class KeyCondition {
    constructor(cond) {
        this.cond = cond;
    }
    /**
     * Condition k = arg, true if the key attribute k is equal to the Query argument
     */
    static eq(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '=', arg));
    }
    /**
     * Condition k < arg, true if the key attribute k is less than the Query argument
     */
    static lt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<', arg));
    }
    /**
     * Condition k <= arg, true if the key attribute k is less than or equal to the Query argument
     */
    static le(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<=', arg));
    }
    /**
     * Condition k > arg, true if the key attribute k is greater than the the Query argument
     */
    static gt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>', arg));
    }
    /**
     * Condition k >= arg, true if the key attribute k is greater or equal to the Query argument
     */
    static ge(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>=', arg));
    }
    /**
     * Condition (k, arg). True if the key attribute k begins with the Query argument.
     */
    static beginsWith(keyName, arg) {
        return new KeyCondition(new private_1.BeginsWith(keyName, arg));
    }
    /**
     * Condition k BETWEEN arg1 AND arg2, true if k >= arg1 and k <= arg2.
     */
    static between(keyName, arg1, arg2) {
        return new KeyCondition(new private_1.Between(keyName, arg1, arg2));
    }
    /**
     * Conjunction between two conditions.
     */
    and(keyCond) {
        jsiiDeprecationWarnings.monocdk_aws_appsync_KeyCondition(keyCond);
        return new KeyCondition(this.cond.and(keyCond.cond));
    }
    /**
     * Renders the key condition to a VTL string.
     */
    renderTemplate() {
        return `"query" : {
              "expression" : "${this.cond.renderCondition()}",
              "expressionNames" : {
                ${this.cond.renderExpressionNames()}
              },
              "expressionValues" : {
                ${this.cond.renderExpressionValues()}
              }
            }`;
    }
}
exports.KeyCondition = KeyCondition;
_a = JSII_RTTI_SYMBOL_1;
KeyCondition[_a] = { fqn: "monocdk.aws_appsync.KeyCondition", version: "1.149.0" };
/**
 * Utility class representing the assigment of a value to an attribute.
 */
class Assign {
    constructor(attr, arg) {
        this.attr = attr;
        this.arg = arg;
    }
    /**
     * Renders the assignment as a VTL string.
     */
    renderAsAssignment() {
        return `"${this.attr}" : $util.dynamodb.toDynamoDBJson(${this.arg})`;
    }
    /**
     * Renders the assignment as a map element.
     */
    putInMap(map) {
        return `$util.qr($${map}.put("${this.attr}", ${this.arg}))`;
    }
}
exports.Assign = Assign;
_b = JSII_RTTI_SYMBOL_1;
Assign[_b] = { fqn: "monocdk.aws_appsync.Assign", version: "1.149.0" };
/**
 * Utility class to allow assigning a value or an auto-generated id
 * to a partition key.
 */
class PartitionKeyStep {
    constructor(key) {
        this.key = key;
    }
    /**
     * Assign an auto-generated value to the partition key.
     */
    is(val) {
        return new PartitionKey(new Assign(this.key, `$ctx.args.${val}`));
    }
    /**
     * Assign an auto-generated value to the partition key.
     */
    auto() {
        return new PartitionKey(new Assign(this.key, '$util.autoId()'));
    }
}
exports.PartitionKeyStep = PartitionKeyStep;
_c = JSII_RTTI_SYMBOL_1;
PartitionKeyStep[_c] = { fqn: "monocdk.aws_appsync.PartitionKeyStep", version: "1.149.0" };
/**
 * Utility class to allow assigning a value or an auto-generated id
 * to a sort key.
 */
class SortKeyStep {
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        jsiiDeprecationWarnings.monocdk_aws_appsync_Assign(pkey);
    }
    /**
     * Assign an auto-generated value to the sort key.
     */
    is(val) {
        return new PrimaryKey(this.pkey, new Assign(this.skey, `$ctx.args.${val}`));
    }
    /**
     * Assign an auto-generated value to the sort key.
     */
    auto() {
        return new PrimaryKey(this.pkey, new Assign(this.skey, '$util.autoId()'));
    }
}
exports.SortKeyStep = SortKeyStep;
_d = JSII_RTTI_SYMBOL_1;
SortKeyStep[_d] = { fqn: "monocdk.aws_appsync.SortKeyStep", version: "1.149.0" };
/**
 * Specifies the assignment to the primary key. It either
 * contains the full primary key or only the partition key.
 */
class PrimaryKey {
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        jsiiDeprecationWarnings.monocdk_aws_appsync_Assign(pkey);
        jsiiDeprecationWarnings.monocdk_aws_appsync_Assign(skey);
    }
    /**
     * Allows assigning a value to the partition key.
     */
    static partition(key) {
        return new PartitionKeyStep(key);
    }
    /**
     * Renders the key assignment to a VTL string.
     */
    renderTemplate() {
        const assignments = [this.pkey.renderAsAssignment()];
        if (this.skey) {
            assignments.push(this.skey.renderAsAssignment());
        }
        return `"key" : {
      ${assignments.join(',')}
    }`;
    }
}
exports.PrimaryKey = PrimaryKey;
_e = JSII_RTTI_SYMBOL_1;
PrimaryKey[_e] = { fqn: "monocdk.aws_appsync.PrimaryKey", version: "1.149.0" };
/**
 * Specifies the assignment to the partition key. It can be
 * enhanced with the assignment of the sort key.
 */
class PartitionKey extends PrimaryKey {
    constructor(pkey) {
        super(pkey);
        jsiiDeprecationWarnings.monocdk_aws_appsync_Assign(pkey);
    }
    /**
     * Allows assigning a value to the sort key.
     */
    sort(key) {
        return new SortKeyStep(this.pkey, key);
    }
}
exports.PartitionKey = PartitionKey;
_f = JSII_RTTI_SYMBOL_1;
PartitionKey[_f] = { fqn: "monocdk.aws_appsync.PartitionKey", version: "1.149.0" };
/**
 * Specifies the attribute value assignments.
 */
class AttributeValues {
    constructor(container, assignments = []) {
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * Allows assigning a value to the specified attribute.
     */
    attribute(attr) {
        return new AttributeValuesStep(attr, this.container, this.assignments);
    }
    /**
     * Renders the variables required for `renderTemplate`.
     */
    renderVariables() {
        return `#set($input = ${this.container})
      ${this.assignments.map(a => a.putInMap('input')).join('\n')}`;
    }
    /**
     * Renders the attribute value assingments to a VTL string.
     */
    renderTemplate() {
        return '"attributeValues": $util.dynamodb.toMapValuesJson($input)';
    }
}
exports.AttributeValues = AttributeValues;
_g = JSII_RTTI_SYMBOL_1;
AttributeValues[_g] = { fqn: "monocdk.aws_appsync.AttributeValues", version: "1.149.0" };
/**
 * Utility class to allow assigning a value to an attribute.
 */
class AttributeValuesStep {
    constructor(attr, container, assignments) {
        this.attr = attr;
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * Assign the value to the current attribute.
     */
    is(val) {
        this.assignments.push(new Assign(this.attr, val));
        return new AttributeValues(this.container, this.assignments);
    }
}
exports.AttributeValuesStep = AttributeValuesStep;
_h = JSII_RTTI_SYMBOL_1;
AttributeValuesStep[_h] = { fqn: "monocdk.aws_appsync.AttributeValuesStep", version: "1.149.0" };
/**
 * Factory class for attribute value assignments.
 */
class Values {
    /**
     * Treats the specified object as a map of assignments, where the property
     * names represent attribute names. It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     */
    static projecting(arg) {
        return new AttributeValues('$ctx.args' + (arg ? `.${arg}` : ''));
    }
    /**
     * Allows assigning a value to the specified attribute.
     */
    static attribute(attr) {
        return new AttributeValues('{}').attribute(attr);
    }
}
exports.Values = Values;
_j = JSII_RTTI_SYMBOL_1;
Values[_j] = { fqn: "monocdk.aws_appsync.Values", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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