"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MutualTlsCertificate = exports.TlsCertificate = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a TLS certificate
 */
class TlsCertificate {
    /**
     * Returns an File TLS Certificate
     */
    static file(certificateChainPath, privateKeyPath) {
        return new FileTlsCertificate(certificateChainPath, privateKeyPath);
    }
    /**
     * Returns an ACM TLS Certificate
     */
    static acm(certificate) {
        jsiiDeprecationWarnings.monocdk_aws_certificatemanager_ICertificate(certificate);
        return new AcmTlsCertificate(certificate);
    }
    /**
     * Returns an SDS TLS Certificate
     */
    static sds(secretName) {
        return new SdsTlsCertificate(secretName);
    }
}
exports.TlsCertificate = TlsCertificate;
_a = JSII_RTTI_SYMBOL_1;
TlsCertificate[_a] = { fqn: "monocdk.aws_appmesh.TlsCertificate", version: "1.149.0" };
/**
 * Represents a TLS certificate that is supported for mutual TLS authentication.
 */
class MutualTlsCertificate extends TlsCertificate {
    constructor() {
        super(...arguments);
        // TypeScript uses structural typing, so we need a property different from TlsCertificate
        this.differentiator = false;
    }
}
exports.MutualTlsCertificate = MutualTlsCertificate;
_b = JSII_RTTI_SYMBOL_1;
MutualTlsCertificate[_b] = { fqn: "monocdk.aws_appmesh.MutualTlsCertificate", version: "1.149.0" };
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(certificate) {
        super();
        this.acmCertificate = certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends MutualTlsCertificate {
    constructor(certificateChainPath, privateKeyPath) {
        super();
        this.certificateChain = certificateChainPath;
        this.privateKey = privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
        };
    }
}
/**
 * Represents a SDS provided TLS certificate
 */
class SdsTlsCertificate extends MutualTlsCertificate {
    constructor(secretName) {
        super();
        this.secretName = secretName;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                sds: {
                    secretName: this.secretName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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