"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = exports.DnsResponseType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum of DNS service discovery response type
 */
var DnsResponseType;
(function (DnsResponseType) {
    /**
     * DNS resolver returns a loadbalanced set of endpoints and the traffic would be sent to the given endpoints.
     * It would not drain existing connections to other endpoints that are not part of this list.
     */
    DnsResponseType["LOAD_BALANCER"] = "LOADBALANCER";
    /**
     * DNS resolver is returning all the endpoints.
     * This also means that if an endpoint is missing, it would drain the current connections to the missing endpoint.
     */
    DnsResponseType["ENDPOINTS"] = "ENDPOINTS";
})(DnsResponseType = exports.DnsResponseType || (exports.DnsResponseType = {}));
/**
 * Provides the Service Discovery method a VirtualNode uses
 */
class ServiceDiscovery {
    /**
     * Returns DNS based service discovery
     *
     * @param hostname
     * @param responseType Specifies the DNS response type for the virtual node.
     *  The default is `DnsResponseType.LOAD_BALANCER`.
     */
    static dns(hostname, responseType) {
        jsiiDeprecationWarnings.monocdk_aws_appmesh_DnsResponseType(responseType);
        return new DnsServiceDiscovery(hostname, responseType);
    }
    /**
     * Returns Cloud Map based service discovery
     *
     * @param service The AWS Cloud Map Service to use for service discovery
     * @param instanceAttributes A string map that contains attributes with values that you can use to
     *  filter instances by any custom attribute that you specified when you
     *  registered the instance. Only instances that match all of the specified
     *  key/value pairs will be returned.
     */
    static cloudMap(service, instanceAttributes) {
        jsiiDeprecationWarnings.monocdk_aws_servicediscovery_IService(service);
        return new CloudMapServiceDiscovery(service, instanceAttributes);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
_a = JSII_RTTI_SYMBOL_1;
ServiceDiscovery[_a] = { fqn: "monocdk.aws_appmesh.ServiceDiscovery", version: "1.149.0" };
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname, responseType) {
        super();
        this.hostname = hostname;
        this.responseType = responseType;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
                responseType: this.responseType,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(service, instanceAttributes) {
        super();
        this.service = service;
        this.instanceAttributes = instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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