"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceNamespace = exports.ScalableTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const applicationautoscaling_generated_1 = require("./applicationautoscaling.generated");
const step_scaling_policy_1 = require("./step-scaling-policy");
const target_tracking_scaling_policy_1 = require("./target-tracking-scaling-policy");
/**
 * Define a scalable target
 */
class ScalableTarget extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.actions = new Array();
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_ScalableTargetProps(props);
        core_1.withResolved(props.maxCapacity, max => {
            if (max < 0) {
                throw new RangeError(`maxCapacity cannot be negative, got: ${props.maxCapacity}`);
            }
        });
        core_1.withResolved(props.minCapacity, min => {
            if (min < 0) {
                throw new RangeError(`minCapacity cannot be negative, got: ${props.minCapacity}`);
            }
        });
        core_1.withResolved(props.minCapacity, props.maxCapacity, (min, max) => {
            if (max < min) {
                throw new RangeError(`minCapacity (${props.minCapacity}) should be lower than maxCapacity (${props.maxCapacity})`);
            }
        });
        this.role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('application-autoscaling.amazonaws.com'),
        });
        const resource = new applicationautoscaling_generated_1.CfnScalableTarget(this, 'Resource', {
            maxCapacity: props.maxCapacity,
            minCapacity: props.minCapacity,
            resourceId: props.resourceId,
            roleArn: this.role.roleArn,
            scalableDimension: props.scalableDimension,
            scheduledActions: core_1.Lazy.any({ produce: () => this.actions }, { omitEmptyArray: true }),
            serviceNamespace: props.serviceNamespace,
        });
        this.scalableTargetId = resource.ref;
    }
    static fromScalableTargetId(scope, id, scalableTargetId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.scalableTargetId = scalableTargetId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add a policy statement to the role's policy
     */
    addToRolePolicy(statement) {
        jsiiDeprecationWarnings.monocdk_aws_iam_PolicyStatement(statement);
        this.role.addToPrincipalPolicy(statement);
    }
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_ScalingSchedule(action);
        if (action.minCapacity === undefined && action.maxCapacity === undefined) {
            throw new Error(`You must supply at least one of minCapacity or maxCapacity, got ${JSON.stringify(action)}`);
        }
        // add a warning on synth when minute is not defined in a cron schedule
        action.schedule._bind(this);
        this.actions.push({
            scheduledActionName: id,
            schedule: action.schedule.expressionString,
            startTime: action.startTime,
            endTime: action.endTime,
            scalableTargetAction: {
                maxCapacity: action.maxCapacity,
                minCapacity: action.minCapacity,
            },
        });
    }
    /**
     * Scale out or in, in response to a metric
     */
    scaleOnMetric(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_BasicStepScalingPolicyProps(props);
        return new step_scaling_policy_1.StepScalingPolicy(this, id, { ...props, scalingTarget: this });
    }
    /**
     * Scale out or in in order to keep a metric around a target value
     */
    scaleToTrackMetric(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_BasicTargetTrackingScalingPolicyProps(props);
        return new target_tracking_scaling_policy_1.TargetTrackingScalingPolicy(this, id, { ...props, scalingTarget: this });
    }
}
exports.ScalableTarget = ScalableTarget;
_a = JSII_RTTI_SYMBOL_1;
ScalableTarget[_a] = { fqn: "monocdk.aws_applicationautoscaling.ScalableTarget", version: "1.149.0" };
/**
 * The service that supports Application AutoScaling
 */
var ServiceNamespace;
(function (ServiceNamespace) {
    /**
     * Elastic Container Service
     */
    ServiceNamespace["ECS"] = "ecs";
    /**
     * Elastic Map Reduce
     */
    ServiceNamespace["ELASTIC_MAP_REDUCE"] = "elasticmapreduce";
    /**
     * Elastic Compute Cloud
     */
    ServiceNamespace["EC2"] = "ec2";
    /**
     * App Stream
     */
    ServiceNamespace["APPSTREAM"] = "appstream";
    /**
     * Dynamo DB
     */
    ServiceNamespace["DYNAMODB"] = "dynamodb";
    /**
     * Relational Database Service
     */
    ServiceNamespace["RDS"] = "rds";
    /**
     * SageMaker
     */
    ServiceNamespace["SAGEMAKER"] = "sagemaker";
    /**
     * Custom Resource
     */
    ServiceNamespace["CUSTOM_RESOURCE"] = "custom-resource";
    /**
     * Lambda
     */
    ServiceNamespace["LAMBDA"] = "lambda";
    /**
     * Comprehend
     */
    ServiceNamespace["COMPREHEND"] = "comprehend";
    /**
     * Kafka
     */
    ServiceNamespace["KAFKA"] = "kafka";
    /**
     * ElastiCache
     */
    ServiceNamespace["ELASTICACHE"] = "elasticache";
})(ServiceNamespace = exports.ServiceNamespace || (exports.ServiceNamespace = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NhbGFibGUtdGFyZ2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic2NhbGFibGUtdGFyZ2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHFDQUFxQztBQUNyQyxxQ0FBcUU7QUFFckUseUZBQXVFO0FBRXZFLCtEQUF1RjtBQUN2RixxRkFBc0g7QUFnRXRIOztHQUVHO0FBQ0gsTUFBYSxjQUFlLFNBQVEsZUFBUTtJQXlCMUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBSEYsWUFBTyxHQUFHLElBQUksS0FBSyxFQUE2QyxDQUFDOztRQUtoRixtQkFBWSxDQUFDLEtBQUssQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLEVBQUU7WUFDcEMsSUFBSSxHQUFHLEdBQUcsQ0FBQyxFQUFFO2dCQUNYLE1BQU0sSUFBSSxVQUFVLENBQUMsd0NBQXdDLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO2FBQ25GO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFFSCxtQkFBWSxDQUFDLEtBQUssQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLEVBQUU7WUFDcEMsSUFBSSxHQUFHLEdBQUcsQ0FBQyxFQUFFO2dCQUNYLE1BQU0sSUFBSSxVQUFVLENBQUMsd0NBQXdDLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO2FBQ25GO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFFSCxtQkFBWSxDQUFDLEtBQUssQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRTtZQUM5RCxJQUFJLEdBQUcsR0FBRyxHQUFHLEVBQUU7Z0JBQ2IsTUFBTSxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsS0FBSyxDQUFDLFdBQVcsdUNBQXVDLEtBQUssQ0FBQyxXQUFXLEdBQUcsQ0FBQyxDQUFDO2FBQ3BIO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLElBQUksSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDbkQsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLHVDQUF1QyxDQUFDO1NBQzdFLENBQUMsQ0FBQztRQUVILE1BQU0sUUFBUSxHQUFHLElBQUksb0RBQWlCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUN2RCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixPQUFPLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPO1lBQzFCLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7WUFDMUMsZ0JBQWdCLEVBQUUsV0FBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsRUFBRSxjQUFjLEVBQUUsSUFBSSxFQUFFLENBQUM7WUFDckYsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtTQUN6QyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztLQUN0QztJQTNETSxNQUFNLENBQUMsb0JBQW9CLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsZ0JBQXdCO1FBQ3ZGLE1BQU0sTUFBTyxTQUFRLGVBQVE7WUFBN0I7O2dCQUNrQixxQkFBZ0IsR0FBRyxnQkFBZ0IsQ0FBQztZQUN0RCxDQUFDO1NBQUE7UUFDRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5QjtJQXdERDs7T0FFRztJQUNJLGVBQWUsQ0FBQyxTQUE4Qjs7UUFDbkQsSUFBSSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztLQUMzQztJQUVEOztPQUVHO0lBQ0ksZUFBZSxDQUFDLEVBQVUsRUFBRSxNQUF1Qjs7UUFDeEQsSUFBSSxNQUFNLENBQUMsV0FBVyxLQUFLLFNBQVMsSUFBSSxNQUFNLENBQUMsV0FBVyxLQUFLLFNBQVMsRUFBRTtZQUN4RSxNQUFNLElBQUksS0FBSyxDQUFDLG1FQUFtRSxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQztTQUM5RztRQUVELHVFQUF1RTtRQUN2RSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUU1QixJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQztZQUNoQixtQkFBbUIsRUFBRSxFQUFFO1lBQ3ZCLFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUSxDQUFDLGdCQUFnQjtZQUMxQyxTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPO1lBQ3ZCLG9CQUFvQixFQUFFO2dCQUNwQixXQUFXLEVBQUUsTUFBTSxDQUFDLFdBQVc7Z0JBQy9CLFdBQVcsRUFBRSxNQUFNLENBQUMsV0FBVzthQUNoQztTQUNGLENBQUMsQ0FBQztLQUNKO0lBRUQ7O09BRUc7SUFDSSxhQUFhLENBQUMsRUFBVSxFQUFFLEtBQWtDOztRQUNqRSxPQUFPLElBQUksdUNBQWlCLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRSxFQUFFLEdBQUcsS0FBSyxFQUFFLGFBQWEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0tBQzNFO0lBRUQ7O09BRUc7SUFDSSxrQkFBa0IsQ0FBQyxFQUFVLEVBQUUsS0FBNEM7O1FBQ2hGLE9BQU8sSUFBSSw0REFBMkIsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxLQUFLLEVBQUUsYUFBYSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7S0FDckY7O0FBekdILHdDQTBHQzs7O0FBa0REOztHQUVHO0FBQ0gsSUFBWSxnQkE0RFg7QUE1REQsV0FBWSxnQkFBZ0I7SUFDMUI7O09BRUc7SUFDSCwrQkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCwyREFBdUMsQ0FBQTtJQUV2Qzs7T0FFRztJQUNILCtCQUFXLENBQUE7SUFFWDs7T0FFRztJQUNILDJDQUF1QixDQUFBO0lBRXZCOztPQUVHO0lBQ0gseUNBQXFCLENBQUE7SUFFckI7O09BRUc7SUFDSCwrQkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCwyQ0FBdUIsQ0FBQTtJQUV2Qjs7T0FFRztJQUNILHVEQUFtQyxDQUFBO0lBRW5DOztPQUVHO0lBQ0gscUNBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCw2Q0FBeUIsQ0FBQTtJQUV6Qjs7T0FFRztJQUNILG1DQUFlLENBQUE7SUFFZjs7T0FFRztJQUNILCtDQUEyQixDQUFBO0FBQzdCLENBQUMsRUE1RFcsZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUE0RDNCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJy4uLy4uL2F3cy1pYW0nO1xuaW1wb3J0IHsgSVJlc291cmNlLCBMYXp5LCBSZXNvdXJjZSwgd2l0aFJlc29sdmVkIH0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmblNjYWxhYmxlVGFyZ2V0IH0gZnJvbSAnLi9hcHBsaWNhdGlvbmF1dG9zY2FsaW5nLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBTY2hlZHVsZSB9IGZyb20gJy4vc2NoZWR1bGUnO1xuaW1wb3J0IHsgQmFzaWNTdGVwU2NhbGluZ1BvbGljeVByb3BzLCBTdGVwU2NhbGluZ1BvbGljeSB9IGZyb20gJy4vc3RlcC1zY2FsaW5nLXBvbGljeSc7XG5pbXBvcnQgeyBCYXNpY1RhcmdldFRyYWNraW5nU2NhbGluZ1BvbGljeVByb3BzLCBUYXJnZXRUcmFja2luZ1NjYWxpbmdQb2xpY3kgfSBmcm9tICcuL3RhcmdldC10cmFja2luZy1zY2FsaW5nLXBvbGljeSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgSVNjYWxhYmxlVGFyZ2V0IGV4dGVuZHMgSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHNjYWxhYmxlVGFyZ2V0SWQ6IHN0cmluZztcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIHNjYWxhYmxlIHRhcmdldFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNjYWxhYmxlVGFyZ2V0UHJvcHMge1xuICAvKipcbiAgICogVGhlIG1pbmltdW0gdmFsdWUgdGhhdCBBcHBsaWNhdGlvbiBBdXRvIFNjYWxpbmcgY2FuIHVzZSB0byBzY2FsZSBhIHRhcmdldCBkdXJpbmcgYSBzY2FsaW5nIGFjdGl2aXR5LlxuICAgKi9cbiAgcmVhZG9ubHkgbWluQ2FwYWNpdHk6IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIG1heGltdW0gdmFsdWUgdGhhdCBBcHBsaWNhdGlvbiBBdXRvIFNjYWxpbmcgY2FuIHVzZSB0byBzY2FsZSBhIHRhcmdldCBkdXJpbmcgYSBzY2FsaW5nIGFjdGl2aXR5LlxuICAgKi9cbiAgcmVhZG9ubHkgbWF4Q2FwYWNpdHk6IG51bWJlcjtcblxuICAvKipcbiAgICogUm9sZSB0aGF0IGFsbG93cyBBcHBsaWNhdGlvbiBBdXRvIFNjYWxpbmcgdG8gbW9kaWZ5IHlvdXIgc2NhbGFibGUgdGFyZ2V0LlxuICAgKlxuICAgKiBAZGVmYXVsdCBBIHJvbGUgaXMgYXV0b21hdGljYWxseSBjcmVhdGVkXG4gICAqL1xuICByZWFkb25seSByb2xlPzogaWFtLklSb2xlO1xuXG4gIC8qKlxuICAgKiBUaGUgcmVzb3VyY2UgaWRlbnRpZmllciB0byBhc3NvY2lhdGUgd2l0aCB0aGlzIHNjYWxhYmxlIHRhcmdldC5cbiAgICpcbiAgICogVGhpcyBzdHJpbmcgY29uc2lzdHMgb2YgdGhlIHJlc291cmNlIHR5cGUgYW5kIHVuaXF1ZSBpZGVudGlmaWVyLlxuICAgKlxuICAgKiBFeGFtcGxlIHZhbHVlOiBgc2VydmljZS9lY3NTdGFjay1NeUVDU0NsdXN0ZXItQUIxMkNERTNGNEdIL2Vjc1N0YWNrLU15RUNTU2VydmljZS1BQjEyQ0RFM0Y0R0hgXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2FwcGxpY2F0aW9uL0FQSVJlZmVyZW5jZS9BUElfUmVnaXN0ZXJTY2FsYWJsZVRhcmdldC5odG1sXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZUlkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBzY2FsYWJsZSBkaW1lbnNpb24gdGhhdCdzIGFzc29jaWF0ZWQgd2l0aCB0aGUgc2NhbGFibGUgdGFyZ2V0LlxuICAgKlxuICAgKiBTcGVjaWZ5IHRoZSBzZXJ2aWNlIG5hbWVzcGFjZSwgcmVzb3VyY2UgdHlwZSwgYW5kIHNjYWxpbmcgcHJvcGVydHkuXG4gICAqXG4gICAqIEV4YW1wbGUgdmFsdWU6IGBlY3M6c2VydmljZTpEZXNpcmVkQ291bnRgXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2FwcGxpY2F0aW9uL0FQSVJlZmVyZW5jZS9BUElfU2NhbGluZ1BvbGljeS5odG1sXG4gICAqL1xuICByZWFkb25seSBzY2FsYWJsZURpbWVuc2lvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZXNwYWNlIG9mIHRoZSBBV1Mgc2VydmljZSB0aGF0IHByb3ZpZGVzIHRoZSByZXNvdXJjZSBvclxuICAgKiBjdXN0b20tcmVzb3VyY2UgZm9yIGEgcmVzb3VyY2UgcHJvdmlkZWQgYnkgeW91ciBvd24gYXBwbGljYXRpb24gb3JcbiAgICogc2VydmljZS5cbiAgICpcbiAgICogRm9yIHZhbGlkIEFXUyBzZXJ2aWNlIG5hbWVzcGFjZSB2YWx1ZXMsIHNlZSB0aGUgUmVnaXN0ZXJTY2FsYWJsZVRhcmdldFxuICAgKiBhY3Rpb24gaW4gdGhlIEFwcGxpY2F0aW9uIEF1dG8gU2NhbGluZyBBUEkgUmVmZXJlbmNlLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9hcHBsaWNhdGlvbi9BUElSZWZlcmVuY2UvQVBJX1JlZ2lzdGVyU2NhbGFibGVUYXJnZXQuaHRtbFxuICAgKi9cbiAgcmVhZG9ubHkgc2VydmljZU5hbWVzcGFjZTogU2VydmljZU5hbWVzcGFjZTtcbn1cblxuLyoqXG4gKiBEZWZpbmUgYSBzY2FsYWJsZSB0YXJnZXRcbiAqL1xuZXhwb3J0IGNsYXNzIFNjYWxhYmxlVGFyZ2V0IGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJU2NhbGFibGVUYXJnZXQge1xuXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVNjYWxhYmxlVGFyZ2V0SWQoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgc2NhbGFibGVUYXJnZXRJZDogc3RyaW5nKTogSVNjYWxhYmxlVGFyZ2V0IHtcbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElTY2FsYWJsZVRhcmdldCB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgc2NhbGFibGVUYXJnZXRJZCA9IHNjYWxhYmxlVGFyZ2V0SWQ7XG4gICAgfVxuICAgIHJldHVybiBuZXcgSW1wb3J0KHNjb3BlLCBpZCk7XG4gIH1cblxuICAvKipcbiAgICogSUQgb2YgdGhlIFNjYWxhYmxlIFRhcmdldFxuICAgKlxuICAgKiBFeGFtcGxlIHZhbHVlOiBgc2VydmljZS9lY3NTdGFjay1NeUVDU0NsdXN0ZXItQUIxMkNERTNGNEdIL2Vjc1N0YWNrLU15RUNTU2VydmljZS1BQjEyQ0RFM0Y0R0h8ZWNzOnNlcnZpY2U6RGVzaXJlZENvdW50fGVjc2BcbiAgICpcbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHNjYWxhYmxlVGFyZ2V0SWQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHJvbGUgdXNlZCB0byBnaXZlIEF1dG9TY2FsaW5nIHBlcm1pc3Npb25zIHRvIHlvdXIgcmVzb3VyY2VcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSByb2xlOiBpYW0uSVJvbGU7XG5cbiAgcHJpdmF0ZSByZWFkb25seSBhY3Rpb25zID0gbmV3IEFycmF5PENmblNjYWxhYmxlVGFyZ2V0LlNjaGVkdWxlZEFjdGlvblByb3BlcnR5PigpO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTY2FsYWJsZVRhcmdldFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHdpdGhSZXNvbHZlZChwcm9wcy5tYXhDYXBhY2l0eSwgbWF4ID0+IHtcbiAgICAgIGlmIChtYXggPCAwKSB7XG4gICAgICAgIHRocm93IG5ldyBSYW5nZUVycm9yKGBtYXhDYXBhY2l0eSBjYW5ub3QgYmUgbmVnYXRpdmUsIGdvdDogJHtwcm9wcy5tYXhDYXBhY2l0eX1gKTtcbiAgICAgIH1cbiAgICB9KTtcblxuICAgIHdpdGhSZXNvbHZlZChwcm9wcy5taW5DYXBhY2l0eSwgbWluID0+IHtcbiAgICAgIGlmIChtaW4gPCAwKSB7XG4gICAgICAgIHRocm93IG5ldyBSYW5nZUVycm9yKGBtaW5DYXBhY2l0eSBjYW5ub3QgYmUgbmVnYXRpdmUsIGdvdDogJHtwcm9wcy5taW5DYXBhY2l0eX1gKTtcbiAgICAgIH1cbiAgICB9KTtcblxuICAgIHdpdGhSZXNvbHZlZChwcm9wcy5taW5DYXBhY2l0eSwgcHJvcHMubWF4Q2FwYWNpdHksIChtaW4sIG1heCkgPT4ge1xuICAgICAgaWYgKG1heCA8IG1pbikge1xuICAgICAgICB0aHJvdyBuZXcgUmFuZ2VFcnJvcihgbWluQ2FwYWNpdHkgKCR7cHJvcHMubWluQ2FwYWNpdHl9KSBzaG91bGQgYmUgbG93ZXIgdGhhbiBtYXhDYXBhY2l0eSAoJHtwcm9wcy5tYXhDYXBhY2l0eX0pYCk7XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICB0aGlzLnJvbGUgPSBwcm9wcy5yb2xlIHx8IG5ldyBpYW0uUm9sZSh0aGlzLCAnUm9sZScsIHtcbiAgICAgIGFzc3VtZWRCeTogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdhcHBsaWNhdGlvbi1hdXRvc2NhbGluZy5hbWF6b25hd3MuY29tJyksXG4gICAgfSk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5TY2FsYWJsZVRhcmdldCh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBtYXhDYXBhY2l0eTogcHJvcHMubWF4Q2FwYWNpdHksXG4gICAgICBtaW5DYXBhY2l0eTogcHJvcHMubWluQ2FwYWNpdHksXG4gICAgICByZXNvdXJjZUlkOiBwcm9wcy5yZXNvdXJjZUlkLFxuICAgICAgcm9sZUFybjogdGhpcy5yb2xlLnJvbGVBcm4sXG4gICAgICBzY2FsYWJsZURpbWVuc2lvbjogcHJvcHMuc2NhbGFibGVEaW1lbnNpb24sXG4gICAgICBzY2hlZHVsZWRBY3Rpb25zOiBMYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMuYWN0aW9ucyB9LCB7IG9taXRFbXB0eUFycmF5OiB0cnVlIH0pLFxuICAgICAgc2VydmljZU5hbWVzcGFjZTogcHJvcHMuc2VydmljZU5hbWVzcGFjZSxcbiAgICB9KTtcblxuICAgIHRoaXMuc2NhbGFibGVUYXJnZXRJZCA9IHJlc291cmNlLnJlZjtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGQgYSBwb2xpY3kgc3RhdGVtZW50IHRvIHRoZSByb2xlJ3MgcG9saWN5XG4gICAqL1xuICBwdWJsaWMgYWRkVG9Sb2xlUG9saWN5KHN0YXRlbWVudDogaWFtLlBvbGljeVN0YXRlbWVudCkge1xuICAgIHRoaXMucm9sZS5hZGRUb1ByaW5jaXBhbFBvbGljeShzdGF0ZW1lbnQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFNjYWxlIG91dCBvciBpbiBiYXNlZCBvbiB0aW1lXG4gICAqL1xuICBwdWJsaWMgc2NhbGVPblNjaGVkdWxlKGlkOiBzdHJpbmcsIGFjdGlvbjogU2NhbGluZ1NjaGVkdWxlKSB7XG4gICAgaWYgKGFjdGlvbi5taW5DYXBhY2l0eSA9PT0gdW5kZWZpbmVkICYmIGFjdGlvbi5tYXhDYXBhY2l0eSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYFlvdSBtdXN0IHN1cHBseSBhdCBsZWFzdCBvbmUgb2YgbWluQ2FwYWNpdHkgb3IgbWF4Q2FwYWNpdHksIGdvdCAke0pTT04uc3RyaW5naWZ5KGFjdGlvbil9YCk7XG4gICAgfVxuXG4gICAgLy8gYWRkIGEgd2FybmluZyBvbiBzeW50aCB3aGVuIG1pbnV0ZSBpcyBub3QgZGVmaW5lZCBpbiBhIGNyb24gc2NoZWR1bGVcbiAgICBhY3Rpb24uc2NoZWR1bGUuX2JpbmQodGhpcyk7XG5cbiAgICB0aGlzLmFjdGlvbnMucHVzaCh7XG4gICAgICBzY2hlZHVsZWRBY3Rpb25OYW1lOiBpZCxcbiAgICAgIHNjaGVkdWxlOiBhY3Rpb24uc2NoZWR1bGUuZXhwcmVzc2lvblN0cmluZyxcbiAgICAgIHN0YXJ0VGltZTogYWN0aW9uLnN0YXJ0VGltZSxcbiAgICAgIGVuZFRpbWU6IGFjdGlvbi5lbmRUaW1lLFxuICAgICAgc2NhbGFibGVUYXJnZXRBY3Rpb246IHtcbiAgICAgICAgbWF4Q2FwYWNpdHk6IGFjdGlvbi5tYXhDYXBhY2l0eSxcbiAgICAgICAgbWluQ2FwYWNpdHk6IGFjdGlvbi5taW5DYXBhY2l0eSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogU2NhbGUgb3V0IG9yIGluLCBpbiByZXNwb25zZSB0byBhIG1ldHJpY1xuICAgKi9cbiAgcHVibGljIHNjYWxlT25NZXRyaWMoaWQ6IHN0cmluZywgcHJvcHM6IEJhc2ljU3RlcFNjYWxpbmdQb2xpY3lQcm9wcykge1xuICAgIHJldHVybiBuZXcgU3RlcFNjYWxpbmdQb2xpY3kodGhpcywgaWQsIHsgLi4ucHJvcHMsIHNjYWxpbmdUYXJnZXQ6IHRoaXMgfSk7XG4gIH1cblxuICAvKipcbiAgICogU2NhbGUgb3V0IG9yIGluIGluIG9yZGVyIHRvIGtlZXAgYSBtZXRyaWMgYXJvdW5kIGEgdGFyZ2V0IHZhbHVlXG4gICAqL1xuICBwdWJsaWMgc2NhbGVUb1RyYWNrTWV0cmljKGlkOiBzdHJpbmcsIHByb3BzOiBCYXNpY1RhcmdldFRyYWNraW5nU2NhbGluZ1BvbGljeVByb3BzKSB7XG4gICAgcmV0dXJuIG5ldyBUYXJnZXRUcmFja2luZ1NjYWxpbmdQb2xpY3kodGhpcywgaWQsIHsgLi4ucHJvcHMsIHNjYWxpbmdUYXJnZXQ6IHRoaXMgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBBIHNjaGVkdWxlZCBzY2FsaW5nIGFjdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNjYWxpbmdTY2hlZHVsZSB7XG4gIC8qKlxuICAgKiBXaGVuIHRvIHBlcmZvcm0gdGhpcyBhY3Rpb24uXG4gICAqL1xuICByZWFkb25seSBzY2hlZHVsZTogU2NoZWR1bGU7XG5cbiAgLyoqXG4gICAqIFdoZW4gdGhpcyBzY2hlZHVsZWQgYWN0aW9uIGJlY29tZXMgYWN0aXZlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBUaGUgcnVsZSBpcyBhY3RpdmF0ZSBpbW1lZGlhdGVseVxuICAgKi9cbiAgcmVhZG9ubHkgc3RhcnRUaW1lPzogRGF0ZVxuXG4gIC8qKlxuICAgKiBXaGVuIHRoaXMgc2NoZWR1bGVkIGFjdGlvbiBleHBpcmVzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBUaGUgcnVsZSBuZXZlciBleHBpcmVzLlxuICAgKi9cbiAgcmVhZG9ubHkgZW5kVGltZT86IERhdGU7XG5cbiAgLyoqXG4gICAqIFRoZSBuZXcgbWluaW11bSBjYXBhY2l0eS5cbiAgICpcbiAgICogRHVyaW5nIHRoZSBzY2hlZHVsZWQgdGltZSwgaWYgdGhlIGN1cnJlbnQgY2FwYWNpdHkgaXMgYmVsb3cgdGhlIG1pbmltdW1cbiAgICogY2FwYWNpdHksIEFwcGxpY2F0aW9uIEF1dG8gU2NhbGluZyBzY2FsZXMgb3V0IHRvIHRoZSBtaW5pbXVtIGNhcGFjaXR5LlxuICAgKlxuICAgKiBBdCBsZWFzdCBvbmUgb2YgbWF4Q2FwYWNpdHkgYW5kIG1pbkNhcGFjaXR5IG11c3QgYmUgc3VwcGxpZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IE5vIG5ldyBtaW5pbXVtIGNhcGFjaXR5XG4gICAqL1xuICByZWFkb25seSBtaW5DYXBhY2l0eT86IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIG5ldyBtYXhpbXVtIGNhcGFjaXR5LlxuICAgKlxuICAgKiBEdXJpbmcgdGhlIHNjaGVkdWxlZCB0aW1lLCB0aGUgY3VycmVudCBjYXBhY2l0eSBpcyBhYm92ZSB0aGUgbWF4aW11bVxuICAgKiBjYXBhY2l0eSwgQXBwbGljYXRpb24gQXV0byBTY2FsaW5nIHNjYWxlcyBpbiB0byB0aGUgbWF4aW11bSBjYXBhY2l0eS5cbiAgICpcbiAgICogQXQgbGVhc3Qgb25lIG9mIG1heENhcGFjaXR5IGFuZCBtaW5DYXBhY2l0eSBtdXN0IGJlIHN1cHBsaWVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCBObyBuZXcgbWF4aW11bSBjYXBhY2l0eVxuICAgKi9cbiAgcmVhZG9ubHkgbWF4Q2FwYWNpdHk/OiBudW1iZXI7XG59XG5cbi8qKlxuICogVGhlIHNlcnZpY2UgdGhhdCBzdXBwb3J0cyBBcHBsaWNhdGlvbiBBdXRvU2NhbGluZ1xuICovXG5leHBvcnQgZW51bSBTZXJ2aWNlTmFtZXNwYWNlIHtcbiAgLyoqXG4gICAqIEVsYXN0aWMgQ29udGFpbmVyIFNlcnZpY2VcbiAgICovXG4gIEVDUyA9ICdlY3MnLFxuXG4gIC8qKlxuICAgKiBFbGFzdGljIE1hcCBSZWR1Y2VcbiAgICovXG4gIEVMQVNUSUNfTUFQX1JFRFVDRSA9ICdlbGFzdGljbWFwcmVkdWNlJyxcblxuICAvKipcbiAgICogRWxhc3RpYyBDb21wdXRlIENsb3VkXG4gICAqL1xuICBFQzIgPSAnZWMyJyxcblxuICAvKipcbiAgICogQXBwIFN0cmVhbVxuICAgKi9cbiAgQVBQU1RSRUFNID0gJ2FwcHN0cmVhbScsXG5cbiAgLyoqXG4gICAqIER5bmFtbyBEQlxuICAgKi9cbiAgRFlOQU1PREIgPSAnZHluYW1vZGInLFxuXG4gIC8qKlxuICAgKiBSZWxhdGlvbmFsIERhdGFiYXNlIFNlcnZpY2VcbiAgICovXG4gIFJEUyA9ICdyZHMnLFxuXG4gIC8qKlxuICAgKiBTYWdlTWFrZXJcbiAgICovXG4gIFNBR0VNQUtFUiA9ICdzYWdlbWFrZXInLFxuXG4gIC8qKlxuICAgKiBDdXN0b20gUmVzb3VyY2VcbiAgICovXG4gIENVU1RPTV9SRVNPVVJDRSA9ICdjdXN0b20tcmVzb3VyY2UnLFxuXG4gIC8qKlxuICAgKiBMYW1iZGFcbiAgICovXG4gIExBTUJEQSA9ICdsYW1iZGEnLFxuXG4gIC8qKlxuICAgKiBDb21wcmVoZW5kXG4gICAqL1xuICBDT01QUkVIRU5EID0gJ2NvbXByZWhlbmQnLFxuXG4gIC8qKlxuICAgKiBLYWZrYVxuICAgKi9cbiAgS0FGS0EgPSAna2Fma2EnLFxuXG4gIC8qKlxuICAgKiBFbGFzdGlDYWNoZVxuICAgKi9cbiAgRUxBU1RJQ0FDSEUgPSAnZWxhc3RpY2FjaGUnLFxufVxuIl19