"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRouteIntegration = exports.WebSocketIntegration = exports.WebSocketIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * WebSocket Integration Types
 */
var WebSocketIntegrationType;
(function (WebSocketIntegrationType) {
    /**
     * AWS Proxy Integration Type
     */
    WebSocketIntegrationType["AWS_PROXY"] = "AWS_PROXY";
    /**
     * Mock Integration Type
     */
    WebSocketIntegrationType["MOCK"] = "MOCK";
})(WebSocketIntegrationType = exports.WebSocketIntegrationType || (exports.WebSocketIntegrationType = {}));
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class WebSocketIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketIntegrationProps(props);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
        });
        this.integrationId = integ.ref;
        this.webSocketApi = props.webSocketApi;
    }
}
exports.WebSocketIntegration = WebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2.WebSocketIntegration", version: "1.149.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class WebSocketRouteIntegration {
    /**
     * Initialize an integration for a route on websocket api.
     * @param id id of the underlying `WebSocketIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.webSocketApi.node.addr !== options.route.webSocketApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new WebSocketIntegration(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                integrationType: config.type,
                integrationUri: config.uri,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.WebSocketRouteIntegration = WebSocketRouteIntegration;
_b = JSII_RTTI_SYMBOL_1;
WebSocketRouteIntegration[_b] = { fqn: "monocdk.aws_apigatewayv2.WebSocketRouteIntegration", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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