"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = exports.WebSocketApiKeySelectionExpression = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("../../../aws-iam");
const core_1 = require("../../../core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
const route_1 = require("./route");
/**
 * Represents the currently available API Key Selection Expressions
 */
class WebSocketApiKeySelectionExpression {
    /**
     * @param customApiKeySelector The expression used by API Gateway
     */
    constructor(customApiKeySelector) {
        this.customApiKeySelector = customApiKeySelector;
    }
}
exports.WebSocketApiKeySelectionExpression = WebSocketApiKeySelectionExpression;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApiKeySelectionExpression[_a] = { fqn: "monocdk.aws_apigatewayv2.WebSocketApiKeySelectionExpression", version: "1.149.0" };
/**
 * The API will extract the key value from the `x-api-key` header in the user request.
 */
WebSocketApiKeySelectionExpression.HEADER_X_API_KEY = new WebSocketApiKeySelectionExpression('$request.header.x-api-key');
/**
  * The API will extract the key value from the `usageIdentifierKey` attribute in the `context` map,
  * returned by the Lambda Authorizer.
  * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
  */
WebSocketApiKeySelectionExpression.AUTHORIZER_USAGE_IDENTIFIER_KEY = new WebSocketApiKeySelectionExpression('$context.authorizer.usageIdentifierKey');
/**
 * Create a new API Gateway WebSocket API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketApiProps(props);
        this.webSocketApiName = (_c = props === null || props === void 0 ? void 0 : props.apiName) !== null && _c !== void 0 ? _c : id;
        const resource = new apigatewayv2_generated_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            apiKeySelectionExpression: (_d = props === null || props === void 0 ? void 0 : props.apiKeySelectionExpression) === null || _d === void 0 ? void 0 : _d.customApiKeySelector,
            protocolType: 'WEBSOCKET',
            description: props === null || props === void 0 ? void 0 : props.description,
            routeSelectionExpression: (_e = props === null || props === void 0 ? void 0 : props.routeSelectionExpression) !== null && _e !== void 0 ? _e : '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props === null || props === void 0 ? void 0 : props.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * Import an existing WebSocket API into this CDK app.
     */
    static fromWebSocketApiAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketApiAttributes(attrs);
        class Import extends base_1.ApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.webSocketId;
                this.websocketApiId = attrs.webSocketId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported WebSocketApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add a new route
     */
    addRoute(routeKey, options) {
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketRouteOptions(options);
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManageConnections(identity) {
        jsiiDeprecationWarnings.monocdk_aws_iam_IGrantable(identity);
        const arn = core_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: this.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/*/*/@connections/*`],
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_b = JSII_RTTI_SYMBOL_1;
WebSocketApi[_b] = { fqn: "monocdk.aws_apigatewayv2.WebSocketApi", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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