"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcLink = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../../aws-ec2");
const core_1 = require("../../../core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a HTTP API to access resources in an Amazon Virtual Private Cloud (VPC).
 */
class VpcLink extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.subnets = new Array();
        this.securityGroups = new Array();
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_VpcLinkProps(props);
        this.vpc = props.vpc;
        const cfnResource = new apigatewayv2_generated_1.CfnVpcLink(this, 'Resource', {
            name: props.vpcLinkName || core_1.Lazy.string({ produce: () => core_1.Names.uniqueId(this) }),
            subnetIds: core_1.Lazy.list({ produce: () => this.renderSubnets() }),
            securityGroupIds: core_1.Lazy.list({ produce: () => this.renderSecurityGroups() }),
        });
        this.vpcLinkId = cfnResource.ref;
        const { subnets } = props.vpc.selectSubnets((_b = props.subnets) !== null && _b !== void 0 ? _b : { subnetType: ec2.SubnetType.PRIVATE });
        this.addSubnets(...subnets);
        if (props.securityGroups) {
            this.addSecurityGroups(...props.securityGroups);
        }
    }
    /**
     * Import a VPC Link by specifying its attributes.
     */
    static fromVpcLinkAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_VpcLinkAttributes(attrs);
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcLinkId = attrs.vpcLinkId;
                this.vpc = attrs.vpc;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds the provided subnets to the vpc link
     *
     * @param subnets
     */
    addSubnets(...subnets) {
        jsiiDeprecationWarnings.monocdk_aws_ec2_ISubnet(subnets);
        this.subnets.push(...subnets);
    }
    /**
     * Adds the provided security groups to the vpc link
     *
     * @param groups
     */
    addSecurityGroups(...groups) {
        jsiiDeprecationWarnings.monocdk_aws_ec2_ISecurityGroup(groups);
        this.securityGroups.push(...groups);
    }
    renderSubnets() {
        return this.subnets.map(subnet => subnet.subnetId);
    }
    renderSecurityGroups() {
        return this.securityGroups.map(sg => sg.securityGroupId);
    }
}
exports.VpcLink = VpcLink;
_a = JSII_RTTI_SYMBOL_1;
VpcLink[_a] = { fqn: "monocdk.aws_apigatewayv2.VpcLink", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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