"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2");
const aws_iam_1 = require("../../../aws-iam");
const core_1 = require("../../../core");
/**
 * Lambda WebSocket Integration
 */
class WebSocketLambdaIntegration extends aws_apigatewayv2_1.WebSocketRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda function handler
     * @param props properties to configure the integration
     */
    constructor(id, handler) {
        super(id);
        this.handler = handler;
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(handler);
        this._id = id;
    }
    bind(options) {
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketRouteIntegrationBindOptions(options);
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.webSocketApi.apiId,
                resourceName: `*/*${route.routeKey}`,
            }),
        });
        const integrationUri = core_1.Stack.of(route).formatArn({
            service: 'apigateway',
            account: 'lambda',
            resource: 'path/2015-03-31/functions',
            resourceName: `${this.handler.functionArn}/invocations`,
        });
        return {
            type: aws_apigatewayv2_1.WebSocketIntegrationType.AWS_PROXY,
            uri: integrationUri,
        };
    }
}
exports.WebSocketLambdaIntegration = WebSocketLambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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