"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNlbIntegration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../../aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * The Network Load Balancer integration resource for HTTP API
 */
class HttpNlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param listener the ELB network listener
     * @param props properties to configure the integration
     */
    constructor(id, listener, props = {}) {
        super(id);
        this.listener = listener;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_INetworkListener(listener);
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_integrations_HttpNlbIntegrationProps(props);
    }
    bind(options) {
        var _b, _c;
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_HttpRouteIntegrationBindOptions(options);
        let vpc = (_b = this.props.vpcLink) === null || _b === void 0 ? void 0 : _b.vpc;
        if (!vpc && (this.listener instanceof elbv2.NetworkListener)) {
            vpc = this.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Network Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: (_c = this.props.method) !== null && _c !== void 0 ? _c : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.listener.listenerArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpNlbIntegration = HttpNlbIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpNlbIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2_integrations.HttpNlbIntegration", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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