"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2");
const aws_iam_1 = require("../../../aws-iam");
const core_1 = require("../../../core");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class HttpLambdaIntegration extends aws_apigatewayv2_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda handler to integrate with
     * @param props properties to configure the integration
     */
    constructor(id, handler, props = {}) {
        super(id);
        this.handler = handler;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(handler);
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_integrations_HttpLambdaIntegrationProps(props);
        this._id = id;
    }
    completeBind(options) {
        var _b;
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_HttpRouteIntegrationBindOptions(options);
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.apiId,
                resourceName: `*/*${(_b = route.path) !== null && _b !== void 0 ? _b : ''}`,
            }),
        });
    }
    bind(_) {
        var _b;
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_HttpRouteIntegrationBindOptions(_);
        return {
            type: aws_apigatewayv2_1.HttpIntegrationType.AWS_PROXY,
            uri: this.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : aws_apigatewayv2_1.PayloadFormatVersion.VERSION_2_0,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpLambdaIntegration = HttpLambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2_integrations.HttpLambdaIntegration", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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