"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpJwtAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2");
/**
 * Authorize Http Api routes on whether the requester is registered as part of
 * an AWS Cognito user pool.
 */
class HttpJwtAuthorizer {
    /**
     * Initialize a JWT authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param jwtIssuer The base domain of the identity provider that issues JWT
     * @param props Properties to configure the authorizer
     */
    constructor(id, jwtIssuer, props) {
        this.id = id;
        this.jwtIssuer = jwtIssuer;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_authorizers_HttpJwtAuthorizerProps(props);
    }
    bind(options) {
        var _b, _c;
        jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_HttpRouteAuthorizerBindOptions(options);
        if (!this.authorizer) {
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: (_c = this.props.authorizerName) !== null && _c !== void 0 ? _c : this.id,
                jwtAudience: this.props.jwtAudience,
                jwtIssuer: this.jwtIssuer,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpJwtAuthorizer = HttpJwtAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpJwtAuthorizer[_a] = { fqn: "monocdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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