"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const path = require("path");
const lambda = require("../../../aws-lambda");
const core_1 = require("../../../core");
const lib_1 = require("../../lib");
const authorizers_1 = require("../../lib/authorizers");
const identity_source_1 = require("../../lib/authorizers/identity-source");
// Against the RestApi endpoint from the stack output, run
// `curl -s -o /dev/null -w "%{http_code}" <url>` should return 401
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' <url>?allow=yes` should return 403
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' <url>?allow=yes` should return 200
const app = new core_1.App();
const stack = new core_1.Stack(app, 'RequestAuthorizerInteg');
const authorizerFn = new lambda.Function(stack, 'MyAuthorizerFunction', {
    runtime: lambda.Runtime.NODEJS_14_X,
    handler: 'index.handler',
    code: lambda.AssetCode.fromAsset(path.join(__dirname, 'integ.request-authorizer.handler')),
});
const restapi = new lib_1.RestApi(stack, 'MyRestApi');
const authorizer = new authorizers_1.RequestAuthorizer(stack, 'MyAuthorizer', {
    handler: authorizerFn,
    identitySources: [identity_source_1.IdentitySource.header('Authorization'), identity_source_1.IdentitySource.queryString('allow')],
});
restapi.root.addMethod('ANY', new lib_1.MockIntegration({
    integrationResponses: [
        { statusCode: '200' },
    ],
    passthroughBehavior: lib_1.PassthroughBehavior.NEVER,
    requestTemplates: {
        'application/json': '{ "statusCode": 200 }',
    },
}), {
    methodResponses: [
        { statusCode: '200' },
    ],
    authorizer,
});
//# sourceMappingURL=data:application/json;base64,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