"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockIntegration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_1 = require("../integration");
/**
 * This type of integration lets API Gateway return a response without sending
 * the request further to the backend. This is useful for API testing because it
 * can be used to test the integration set up without incurring charges for
 * using the backend and to enable collaborative development of an API. In
 * collaborative development, a team can isolate their development effort by
 * setting up simulations of API components owned by other teams by using the
 * MOCK integrations. It is also used to return CORS-related headers to ensure
 * that the API method permits CORS access. In fact, the API Gateway console
 * integrates the OPTIONS method to support CORS with a mock integration.
 * Gateway responses are other examples of mock integrations.
 */
class MockIntegration extends integration_1.Integration {
    constructor(options) {
        super({
            type: integration_1.IntegrationType.MOCK,
            options,
        });
        jsiiDeprecationWarnings.monocdk_aws_apigateway_IntegrationOptions(options);
    }
}
exports.MockIntegration = MockIntegration;
_a = JSII_RTTI_SYMBOL_1;
MockIntegration[_a] = { fqn: "monocdk.aws_apigateway.MockIntegration", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9jay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1vY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsZ0RBQWtGO0FBRWxGOzs7Ozs7Ozs7OztHQVdHO0FBQ0gsTUFBYSxlQUFnQixTQUFRLHlCQUFXO0lBQzlDLFlBQVksT0FBNEI7UUFDdEMsS0FBSyxDQUFDO1lBQ0osSUFBSSxFQUFFLDZCQUFlLENBQUMsSUFBSTtZQUMxQixPQUFPO1NBQ1IsQ0FBQyxDQUFDOztLQUNKOztBQU5ILDBDQU9DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW50ZWdyYXRpb24sIEludGVncmF0aW9uT3B0aW9ucywgSW50ZWdyYXRpb25UeXBlIH0gZnJvbSAnLi4vaW50ZWdyYXRpb24nO1xuXG4vKipcbiAqIFRoaXMgdHlwZSBvZiBpbnRlZ3JhdGlvbiBsZXRzIEFQSSBHYXRld2F5IHJldHVybiBhIHJlc3BvbnNlIHdpdGhvdXQgc2VuZGluZ1xuICogdGhlIHJlcXVlc3QgZnVydGhlciB0byB0aGUgYmFja2VuZC4gVGhpcyBpcyB1c2VmdWwgZm9yIEFQSSB0ZXN0aW5nIGJlY2F1c2UgaXRcbiAqIGNhbiBiZSB1c2VkIHRvIHRlc3QgdGhlIGludGVncmF0aW9uIHNldCB1cCB3aXRob3V0IGluY3VycmluZyBjaGFyZ2VzIGZvclxuICogdXNpbmcgdGhlIGJhY2tlbmQgYW5kIHRvIGVuYWJsZSBjb2xsYWJvcmF0aXZlIGRldmVsb3BtZW50IG9mIGFuIEFQSS4gSW5cbiAqIGNvbGxhYm9yYXRpdmUgZGV2ZWxvcG1lbnQsIGEgdGVhbSBjYW4gaXNvbGF0ZSB0aGVpciBkZXZlbG9wbWVudCBlZmZvcnQgYnlcbiAqIHNldHRpbmcgdXAgc2ltdWxhdGlvbnMgb2YgQVBJIGNvbXBvbmVudHMgb3duZWQgYnkgb3RoZXIgdGVhbXMgYnkgdXNpbmcgdGhlXG4gKiBNT0NLIGludGVncmF0aW9ucy4gSXQgaXMgYWxzbyB1c2VkIHRvIHJldHVybiBDT1JTLXJlbGF0ZWQgaGVhZGVycyB0byBlbnN1cmVcbiAqIHRoYXQgdGhlIEFQSSBtZXRob2QgcGVybWl0cyBDT1JTIGFjY2Vzcy4gSW4gZmFjdCwgdGhlIEFQSSBHYXRld2F5IGNvbnNvbGVcbiAqIGludGVncmF0ZXMgdGhlIE9QVElPTlMgbWV0aG9kIHRvIHN1cHBvcnQgQ09SUyB3aXRoIGEgbW9jayBpbnRlZ3JhdGlvbi5cbiAqIEdhdGV3YXkgcmVzcG9uc2VzIGFyZSBvdGhlciBleGFtcGxlcyBvZiBtb2NrIGludGVncmF0aW9ucy5cbiAqL1xuZXhwb3J0IGNsYXNzIE1vY2tJbnRlZ3JhdGlvbiBleHRlbmRzIEludGVncmF0aW9uIHtcbiAgY29uc3RydWN0b3Iob3B0aW9ucz86IEludGVncmF0aW9uT3B0aW9ucykge1xuICAgIHN1cGVyKHtcbiAgICAgIHR5cGU6IEludGVncmF0aW9uVHlwZS5NT0NLLFxuICAgICAgb3B0aW9ucyxcbiAgICB9KTtcbiAgfVxufVxuIl19