"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePathMapping = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in
 * the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_apigateway_BasePathMappingProps(props);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-zA-Z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = (_b = props.stage) !== null && _b !== void 0 ? _b : (props.restApi instanceof restapi_1.RestApiBase
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
_a = JSII_RTTI_SYMBOL_1;
BasePathMapping[_a] = { fqn: "monocdk.aws_apigateway.BasePathMapping", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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