"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const amplify_generated_1 = require("./amplify.generated");
/**
 * An Amplify Console domain
 */
class Domain extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_amplify_DomainProps(props);
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new amplify_generated_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: core_1.Lazy.any({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
            enableAutoSubDomain: !!props.enableAutoSubdomain,
            autoSubDomainCreationPatterns: props.autoSubdomainCreationPatterns || ['*', 'pr*'],
            autoSubDomainIamRole: (_b = props.autoSubDomainIamRole) === null || _b === void 0 ? void 0 : _b.roleArn,
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
    }
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch, prefix) {
        jsiiDeprecationWarnings.monocdk_aws_amplify_IBranch(branch);
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch) {
        jsiiDeprecationWarnings.monocdk_aws_amplify_IBranch(branch);
        return this.mapSubDomain(branch, '');
    }
    validate() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => {
            var _b;
            return ({
                branchName: s.branch.branchName,
                prefix: (_b = s.prefix) !== null && _b !== void 0 ? _b : s.branch.branchName,
            });
        });
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "monocdk.aws_amplify.Domain", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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