import * as cdk from '../../core';
import * as cfn_parse from '../../core/lib/cfn-parse';
/**
 * Properties for defining a `CfnSkill`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html
 */
export interface CfnSkillProps {
    /**
     * `Alexa::ASK::Skill.AuthenticationConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-authenticationconfiguration
     */
    readonly authenticationConfiguration: CfnSkill.AuthenticationConfigurationProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.SkillPackage`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-skillpackage
     */
    readonly skillPackage: CfnSkill.SkillPackageProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.VendorId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-vendorid
     */
    readonly vendorId: string;
}
/**
 * A CloudFormation `Alexa::ASK::Skill`
 *
 *
 *
 * @cloudformationResource Alexa::ASK::Skill
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html
 */
export declare class CfnSkill extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Alexa::ASK::Skill";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSkill;
    /**
     * `Alexa::ASK::Skill.AuthenticationConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-authenticationconfiguration
     */
    authenticationConfiguration: CfnSkill.AuthenticationConfigurationProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.SkillPackage`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-skillpackage
     */
    skillPackage: CfnSkill.SkillPackageProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.VendorId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-vendorid
     */
    vendorId: string;
    /**
     * Create a new `Alexa::ASK::Skill`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSkillProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSkill {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html
     */
    interface AuthenticationConfigurationProperty {
        /**
         * `CfnSkill.AuthenticationConfigurationProperty.ClientId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html#cfn-ask-skill-authenticationconfiguration-clientid
         */
        readonly clientId: string;
        /**
         * `CfnSkill.AuthenticationConfigurationProperty.ClientSecret`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html#cfn-ask-skill-authenticationconfiguration-clientsecret
         */
        readonly clientSecret: string;
        /**
         * `CfnSkill.AuthenticationConfigurationProperty.RefreshToken`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html#cfn-ask-skill-authenticationconfiguration-refreshtoken
         */
        readonly refreshToken: string;
    }
}
export declare namespace CfnSkill {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-overrides.html
     */
    interface OverridesProperty {
        /**
         * `CfnSkill.OverridesProperty.Manifest`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-overrides.html#cfn-ask-skill-overrides-manifest
         */
        readonly manifest?: any | cdk.IResolvable;
    }
}
export declare namespace CfnSkill {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html
     */
    interface SkillPackageProperty {
        /**
         * `CfnSkill.SkillPackageProperty.Overrides`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-overrides
         */
        readonly overrides?: CfnSkill.OverridesProperty | cdk.IResolvable;
        /**
         * `CfnSkill.SkillPackageProperty.S3Bucket`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3bucket
         */
        readonly s3Bucket: string;
        /**
         * `CfnSkill.SkillPackageProperty.S3BucketRole`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3bucketrole
         */
        readonly s3BucketRole?: string;
        /**
         * `CfnSkill.SkillPackageProperty.S3Key`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3key
         */
        readonly s3Key: string;
        /**
         * `CfnSkill.SkillPackageProperty.S3ObjectVersion`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3objectversion
         */
        readonly s3ObjectVersion?: string;
    }
}
