# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ree_connector']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'ree-connector',
    'version': '0.1.2',
    'description': 'Lightweight package to consume data from REE (Red Eléctrica de España)',
    'long_description': '# Ree-connector\n\nA lightweight Python package to consume data from REE (Red Eléctrica de España)\n\n## Intro\n\nThe development of this package is motivated by the change in the regulated tariff PVPC (Voluntary Price for Small Consumers) of the Spanish electricity market. This allowed small consumers to choose the tariff that best suited their consumption according to their schedules or needs.\n\nFollowing this change, the three sections into which it was previously divided (general, night, electric vehicle) disappeared. From this moment on, each hourly time slot has a different price, and can be very different from the price of its neighbours. This eliminates the possibility of adjusting your consumption to certain hours, where you know for sure that the price of electricity is cheaper.\n\nTherefore, this package is designed to obtain information about the market and contains a series of methods that will help you to know the best hours to make your heavy consumption, among other things, and of course, integrate it with your Python application to manage home automation systems based on this data.\n\n------------------------------------------------------------------------------\n\nEl desarrollo de este paquete está motivado por el cambio producido en la tarifa regulada PVPC (Precio Voluntario para el Pequeño Consumidor) del mercado eléctrico español. Esto permitía a los pequeños consumidores escoger la tarifa que mas se adaptaba a su consumo en función de sus horarios o necesidades.\n\nTras este cambio, desaparecieron los tres tramos en los que se dividía anteriormente (general, noche, vehículo eléctrico). A partir de este momento, cada tramo de una hora tiene un precio distinto, y puede ser muy diferente al precio de sus vecinos. Esto elimina la posibilidad de ajustar tu consumo a unos horarios determinados, donde sabes seguro que el precio de la luz es mas barato.\n\nPor ello, este paquete está pensado para obtener la información sobre el mercado y contiene una serie de métodos que te ayudarán a conocer las mejores horas para realizar tu consumo pesado, entre otras cosas, y como no, integrarlo con tu aplicación Python para poder gestionar sistemas domoticos en base a estos datos.\n\n------------------------------------------------------------------------------\n## First Steps / Primeros Pasos\n\n#### Access Token Request / Solicitud Token Acceso\n\nTo use this package you need an access token.\nTo request it you must send an email to consultasios@ree.es to ask REE (Red Eléctrica de España) for your access token. They usually reply in less than 24h, in the subject you can put "API access token request".\n\n-----------------------------------------------------------------------------\n\nPara utilizar este paquete necesitas un token de acceso.\nPara solicitarlo debes enviar un email a consultasios@ree.es para solicitar a REE (Red Eléctrica de España) tu token de acceso. Normalmente suelen responder en menos de 24h, en el asunto puedes poner "Solicitud token acceso API".\n\n-----------------------------------------------------------------------------\n\n#### Quick Start / Inicio Rápido\n\n```` \n```\nfrom datetime import datetime\nfrom ree_connector import markets\n\n# We generate a date as a string with format \'dd-mm-yyyy\ndate = datetime.now().strftime("%d-%m-%Y")\n\n\n# We generate a date as a string with format \'dd-mm-yyyy\'\n# You can do some tests without api key, for production environments\n# must request your API token.\n\nmarket = markets.PvpcMarket(date,"XXXXXXXXXXXXXXXXXXXXXXXXXXXX","PEN")\n\n# Returns all prices for market session\nmarket.get_session_prices()\n\n# Returns min price for market session\nmarket.get_session_min_price()\n\n# Returns max price for market session\nmarket.get_session_max_price()\n\n# Returns avg price for market session\nmarket.get_session_avg_price()\n\n# Returns if price is under session average price or not\nmarket.get_session_prices()[10].is_under_avg()\n\n# Setter method to under_avg attribute\nmarket.get_session_prices()[10].set_under_avg(True)\n\n# Returns the n cheapest prices for market session\nmarket.get_n_cheapest_hours(3)\n\n# Returns if price is cheap or not\nmarket.get_session_prices()[10].is_cheap()\n\n# Setter method to cheap attribute\nmarket.get_session_prices()[10].set_cheap(True)\n\n# Returns the price for Iberian Peninsula and Balearic Islands.\nmarket.get_session_prices()[10].get_pen_price()\n\n# Returns the price for Canary Island and Melilla\nmarket.get_session_prices()[10].get_can_price()\n\n# Returns the session interval\nmarket.get_session_prices()[10].get_raw_hour()\n\n# Atribute with left-hand side datetime\nmarket.get_session_prices()[10].left_hour\n\n# Atribute with right-hand side datetime\nmarket.get_session_prices()[10].right_hour\n```\n```` \n\n## Docs\n\n[Documentation](https://jorgemarin.gitlab.io/ree-connector/)\n\n\n## License / Licencia\n\n\nMIT License\n\nCopyright (c) 2021 Jorge Marín\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\nContributors:\n    Jorge Marín - initial Package version \n\n',
    'author': 'Jorge Marín',
    'author_email': 'jormarcor@alum.us.es',
    'maintainer': None,
    'maintainer_email': None,
    'url': '',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
