"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const aws_events_1 = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
class CompliantDynamoDb extends dynamodb.Table {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id, props);
        this.dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_b = props.partitionKey) !== null && _b !== void 0 ? _b : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            sortKey: props.sortKey,
            pointInTimeRecovery: true,
            encryption: dynamodb.TableEncryption.CUSTOMER_MANAGED,
            encryptionKey: props.encryptionKey,
            contributorInsightsEnabled: props.contributorInsightsEnabled,
            kinesisStream: props.kinesisStream,
            replicationRegions: props.replicationRegions,
            replicationTimeout: props.replicationTimeout,
            timeToLiveAttribute: props.timeToLiveAttribute,
        });
        this.backupVault = new backup.BackupVault(this, 'BackupVault', {
            backupVaultName: (_c = props.backupVaultName) !== null && _c !== void 0 ? _c : `${props.tableName}-backup-vault`,
            accessPolicy: new iam.PolicyDocument({
                statements: [
                    new iam.PolicyStatement({
                        sid: 'backup-recovery-point-manual-deletion-disabled',
                        effect: iam.Effect.DENY,
                        principals: [new iam.AnyPrincipal()],
                        actions: [
                            'backup:DeleteRecoveryPoint',
                            'backup:PutBackupVaultAccessPolicy',
                            'backup:UpdateRecoveryPointLifecycle',
                        ],
                        resources: ['*'],
                    }),
                ],
            }),
        });
        this.backupPlan = new backup.BackupPlan(this, 'DynamoDbBackupPlan', {
            backupPlanName: `${this.dynamodbTable.tableName}-backup-plan`,
            backupVault: this.backupVault,
            backupPlanRules: [
                new backup.BackupPlanRule({
                    ruleName: 'daily-dynamodb-backup',
                    scheduleExpression: (_d = props.backupPlanStartTime) !== null && _d !== void 0 ? _d : aws_events_1.Schedule.cron({
                        hour: '21',
                        minute: '0',
                    }),
                    deleteAfter: cdk.Duration.days(35),
                }),
            ],
        });
        this.backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(this.dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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