# API Reference <a name="API Reference"></a>

## Constructs <a name="Constructs"></a>

### CompliantDynamoDb <a name="compliantdynamodb.CompliantDynamoDb"></a>

Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.

#### Initializers <a name="compliantdynamodb.CompliantDynamoDb.Initializer"></a>

```typescript
import { CompliantDynamoDb } from 'compliantdynamodb'

new CompliantDynamoDb(scope: Construct, id: string, props: CompliantDynamoDbProps)
```

##### `scope`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.parameter.scope"></a>

- *Type:* [`@aws-cdk/core.Construct`](#@aws-cdk/core.Construct)

---

##### `id`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.parameter.id"></a>

- *Type:* `string`

---

##### `props`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.parameter.props"></a>

- *Type:* [`compliantdynamodb.CompliantDynamoDbProps`](#compliantdynamodb.CompliantDynamoDbProps)

---



#### Properties <a name="Properties"></a>

##### `backupPlan`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.property.backupPlan"></a>

```typescript
public readonly backupPlan: BackupPlan;
```

- *Type:* [`@aws-cdk/aws-backup.BackupPlan`](#@aws-cdk/aws-backup.BackupPlan)

---

##### `backupVault`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.property.backupVault"></a>

```typescript
public readonly backupVault: BackupVault;
```

- *Type:* [`@aws-cdk/aws-backup.BackupVault`](#@aws-cdk/aws-backup.BackupVault)

---

##### `dynamodbTable`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDb.property.dynamodbTable"></a>

```typescript
public readonly dynamodbTable: Table;
```

- *Type:* [`@aws-cdk/aws-dynamodb.Table`](#@aws-cdk/aws-dynamodb.Table)

---


## Structs <a name="Structs"></a>

### CompliantDynamoDbProps <a name="compliantdynamodb.CompliantDynamoDbProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { CompliantDynamoDbProps } from 'compliantdynamodb'

const compliantDynamoDbProps: CompliantDynamoDbProps = { ... }
```

##### `partitionKey`<sup>Required</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.partitionKey"></a>

```typescript
public readonly partitionKey: Attribute;
```

- *Type:* [`@aws-cdk/aws-dynamodb.Attribute`](#@aws-cdk/aws-dynamodb.Attribute)

Partition key attribute definition.

---

##### `sortKey`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.sortKey"></a>

```typescript
public readonly sortKey: Attribute;
```

- *Type:* [`@aws-cdk/aws-dynamodb.Attribute`](#@aws-cdk/aws-dynamodb.Attribute)
- *Default:* no sort key

Sort key attribute definition.

---

##### `billingMode`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.billingMode"></a>

```typescript
public readonly billingMode: BillingMode;
```

- *Type:* [`@aws-cdk/aws-dynamodb.BillingMode`](#@aws-cdk/aws-dynamodb.BillingMode)
- *Default:* PROVISIONED if `replicationRegions` is not specified, PAY_PER_REQUEST otherwise

Specify how you are charged for read and write throughput and how you manage capacity.

---

##### `contributorInsightsEnabled`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.contributorInsightsEnabled"></a>

```typescript
public readonly contributorInsightsEnabled: boolean;
```

- *Type:* `boolean`
- *Default:* false

Whether CloudWatch contributor insights is enabled.

---

##### `encryption`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.encryption"></a>

```typescript
public readonly encryption: TableEncryption;
```

- *Type:* [`@aws-cdk/aws-dynamodb.TableEncryption`](#@aws-cdk/aws-dynamodb.TableEncryption)
- *Default:* server-side encryption is enabled with an AWS owned customer master key

Whether server-side encryption with an AWS managed customer master key is enabled.

This property cannot be set if `serverSideEncryption` is set.

---

##### `encryptionKey`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* [`@aws-cdk/aws-kms.IKey`](#@aws-cdk/aws-kms.IKey)
- *Default:* If `encryption` is set to `TableEncryption.CUSTOMER_MANAGED` and this
property is undefined, a new KMS key will be created and associated with this table.

External KMS key to use for table encryption.

This property can only be set if `encryption` is set to `TableEncryption.CUSTOMER_MANAGED`.

---

##### `pointInTimeRecovery`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.pointInTimeRecovery"></a>

```typescript
public readonly pointInTimeRecovery: boolean;
```

- *Type:* `boolean`
- *Default:* point-in-time recovery is disabled

Whether point-in-time recovery is enabled.

---

##### `readCapacity`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.readCapacity"></a>

```typescript
public readonly readCapacity: number;
```

- *Type:* `number`
- *Default:* 5

The read capacity for the table.

Careful if you add Global Secondary Indexes, as
those will share the table's provisioned throughput.

Can only be provided if billingMode is Provisioned.

---

##### `removalPolicy`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.removalPolicy"></a>

```typescript
public readonly removalPolicy: RemovalPolicy;
```

- *Type:* [`@aws-cdk/core.RemovalPolicy`](#@aws-cdk/core.RemovalPolicy)
- *Default:* RemovalPolicy.RETAIN

The removal policy to apply to the DynamoDB Table.

---

##### `replicationRegions`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.replicationRegions"></a>

```typescript
public readonly replicationRegions: string[];
```

- *Type:* `string`[]
- *Default:* no replica tables are created

Regions where replica tables will be created.

---

##### `replicationTimeout`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.replicationTimeout"></a>

```typescript
public readonly replicationTimeout: Duration;
```

- *Type:* [`@aws-cdk/core.Duration`](#@aws-cdk/core.Duration)
- *Default:* Duration.minutes(30)

The timeout for a table replication operation in a single region.

---

##### ~~`serverSideEncryption`~~<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.serverSideEncryption"></a>

- *Deprecated:* This property is deprecated. In order to obtain the same behavior as
enabling this, set the `encryption` property to `TableEncryption.AWS_MANAGED` instead.

```typescript
public readonly serverSideEncryption: boolean;
```

- *Type:* `boolean`
- *Default:* server-side encryption is enabled with an AWS owned customer master key

Whether server-side encryption with an AWS managed customer master key is enabled.

This property cannot be set if `encryption` and/or `encryptionKey` is set.

---

##### `stream`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.stream"></a>

```typescript
public readonly stream: StreamViewType;
```

- *Type:* [`@aws-cdk/aws-dynamodb.StreamViewType`](#@aws-cdk/aws-dynamodb.StreamViewType)
- *Default:* streams are disabled unless `replicationRegions` is specified

When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.

---

##### `timeToLiveAttribute`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.timeToLiveAttribute"></a>

```typescript
public readonly timeToLiveAttribute: string;
```

- *Type:* `string`
- *Default:* TTL is disabled

The name of TTL attribute.

---

##### `waitForReplicationToFinish`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.waitForReplicationToFinish"></a>

```typescript
public readonly waitForReplicationToFinish: boolean;
```

- *Type:* `boolean`
- *Default:* true

Indicates whether CloudFormation stack waits for replication to finish.

If set to false, the CloudFormation resource will mark the resource as
created and replication will be completed asynchronously. This property is
ignored if replicationRegions property is not set.

DO NOT UNSET this property if adding/removing multiple replicationRegions
in one deployment, as CloudFormation only supports one region replication
at a time. CDK overcomes this limitation by waiting for replication to
finish before starting new replicationRegion.

> https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas

---

##### `writeCapacity`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.writeCapacity"></a>

```typescript
public readonly writeCapacity: number;
```

- *Type:* `number`
- *Default:* 5

The write capacity for the table.

Careful if you add Global Secondary Indexes, as
those will share the table's provisioned throughput.

Can only be provided if billingMode is Provisioned.

---

##### `kinesisStream`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.kinesisStream"></a>

```typescript
public readonly kinesisStream: IStream;
```

- *Type:* [`@aws-cdk/aws-kinesis.IStream`](#@aws-cdk/aws-kinesis.IStream)
- *Default:* no Kinesis Data Stream

Kinesis Data Stream to capture item-level changes for the table.

---

##### `tableName`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* `string`
- *Default:* <generated>

Enforces a particular physical table name.

---

##### `backupPlanStartTime`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.backupPlanStartTime"></a>

```typescript
public readonly backupPlanStartTime: Schedule;
```

- *Type:* [`@aws-cdk/aws-events.Schedule`](#@aws-cdk/aws-events.Schedule)

---

##### `backupVaultName`<sup>Optional</sup> <a name="compliantdynamodb.CompliantDynamoDbProps.property.backupVaultName"></a>

```typescript
public readonly backupVaultName: string;
```

- *Type:* `string`

---



