from rest_framework.response import Response
from rest_framework import status
from bluedot_rest_framework.utils.viewsets import CustomModelViewSet, user_perform_create, AllView
from bluedot_rest_framework.settings import api_settings
from django.utils.module_loading import import_string
from bluedot_rest_framework.utils.jwt_token import jwt_create_token_wechat
from .frontend_views import FrontendView


User = import_string(api_settings.USER['models'])
UserSerializer = import_string(api_settings.USER['serializers'])


class UserView(CustomModelViewSet, FrontendView):
    model_class = User
    serializer_class = UserSerializer

    filterset_fields = {
        'wechat_profile__nick_name': ['contains'],
        'level': ['exact'],
    }

    def perform_create(self, serializer):
        user_perform_create(self.request.auth, serializer)
        user_data = serializer.data
        user_data['token'] = jwt_create_token_wechat(
            openid=user_data['openid'], unionid=user_data['unionid'], userid=user_data['id'], wechat_id=user_data['wechat_id'])
        return Response(user_data, status=status.HTTP_201_CREATED)
