# PDF Generation & Recognition via Python

Aspose.PDF for Python via Java is a robust and reliable pdf generation and recognition component, written in Python and Java. It allows developers to quickly and easily add pdf creation and scanning functionality to their Python applications.

## General PDF Features

- Supports most established pdf standards and pdf specifications.
- Ability to read & export pdfs in multiple image formats including BMP, GIF, JPEG & PNG.  
- Set basic information (e.g. author, creator) of the PDF document.
- Configure PDF Page properties (e.g. width, height, cropbox, bleedbox etc.).
- Set page numbering, bookmark level, page sizes etc.
- Apply document open action, open mode as well as appearance.
- Document can have different page transition effects such as dissolve or box.
- Create PDF documents via XML, API or XML and API combined.
- Ability to work with text, paragraphs, headings, hyperlinks, graphs, attachments etc.

## PDF Security Features

- PDF documents can be encrypted up to 128 bits.
- Master and user passwords can be set for PDF encryption.
- Apply rescriptions on content modification, copying, printing and other operations.

## Conversion Features

- Convert an existing XML file (.XML) or XmlDocument to a new PDF document or a PDF file stream.
- Convert conventional Image formats into PDF file.
- Convert PCL files into PDF file.
- Convert PDF in any PDF version including /A/X and PDF 2.0 standards.

## Package Features

- Supports 14 core fonts.
- Support for Type 1, TrueType, Type 3, CJK fonts.
- Unicode support is available.
- Add, search, extract and replace text in PDF files.
- Add/delete, extract and replace images.
- Insert, delete, split PDF pages.
- Support for Linearization (optimization for the web).
- Set and get XMP metadata.
- Validate (PDF/A-1a, PDF/A-1b).
- Work with bookmarks, annotations, PDF forms, stamps, watermarks and more.

## Read PDF

- Fixed Layout: PDF, XPS
- Microsoft Office: DOC, DOCX, XLS, XLSX, PPTX
- Books: EPUB
- Web: HTML Other: TEX, XML, SVG, MD, MHT
- Others: PS, PCL, CGM, XSLFO/XML

## Save PDF Documents As

- Microsoft Office: DOC, DOCX, XLS, XLSX, PPTX
- Images: JPEG, PNG, BMP, TIFF, EMF
- Other: MobiXML, XML, TEXT

[Product](https://products.aspose.com/pdf/java) | [Documentation](https://docs.aspose.com/pdf/java/) | [Blog](https://blog.aspose.com/category/pdf/) | [API Reference](https://apireference.aspose.com/pdf/java) | [Free Support](https://forum.aspose.com/c/pdf) | [Temporary License](https://purchase.aspose.com/temporary-license)


