from typing import Dict, Any, Optional
import pandas as pd
from sqlalchemy import Engine

class DatabaseError(Exception): ...
class TableNotFoundError(DatabaseError): ...
class ColumnNotFoundError(DatabaseError): ...

def manage_db(database_url: str, table_name: str, operation: str, data: Optional[pd.DataFrame] = None, column_name: Optional[str] = None, row_identifier: Optional[Dict[str, Any]] = None) -> Optional[pd.DataFrame]: ...
def delete_table(engine: Engine, table_name: str) -> None: ...
def delete_row(engine: Engine, table_name: str, row_identifier: Dict[str, Any]) -> None: ...
def delete_column(engine: Engine, table_name: str, column_name: str) -> None: ...

class DatabaseManager:
    def __init__(self, database_url: str) -> None: ...
    def read_db(self, table_name: str) -> pd.DataFrame: ...
    def write_db(self, table_name: str, data: pd.DataFrame) -> None: ...
    def create_db(self, table_name: str, data: pd.DataFrame) -> None: ...
    def delete_table(self, table_name: str) -> None: ...
    def delete_column(self, table_name: str, column_name: str) -> None: ...
    def delete_row(self, table_name: str, row_identifier: Dict[str, Any]) -> None: ...
