class SeleniumLibrary:
    def __init__(
        self,
        timeout=5.0,
        implicit_wait=0.0,
        run_on_failure="Capture Page Screenshot",
        screenshot_root_directory=None,
        plugins=None,
        event_firing_webdriver=None,
    ): ...
    def add_cookie(
        self, name, value, path=None, domain=None, secure=None, expiry=None
    ): ...
    def add_location_strategy(self, strategy_name, strategy_keyword, persist=False): ...
    def alert_should_be_present(self, text="", action="ACCEPT", timeout=None): ...
    def alert_should_not_be_present(self, action="ACCEPT", timeout=0): ...
    def assign_id_to_element(self, locator, id): ...
    def capture_element_screenshot(
        self, locator, filename="selenium-element-screenshot-{index}.png"
    ): ...
    def capture_page_screenshot(self, filename="selenium-screenshot-{index}.png"): ...
    def checkbox_should_be_selected(self, locator): ...
    def checkbox_should_not_be_selected(self, locator): ...
    def choose_file(self, locator, file_path): ...
    def clear_element_text(self, locator): ...
    def click_button(self, locator, modifier=False): ...
    def click_element(self, locator, modifier=False, action_chain=False): ...
    def click_element_at_coordinates(self, locator, xoffset, yoffset): ...
    def click_image(self, locator, modifier=False): ...
    def click_link(self, locator, modifier=False): ...
    def close_all_browsers(self): ...
    def close_browser(self): ...
    def close_window(self): ...
    def cover_element(self, locator): ...
    def create_webdriver(self, driver_name, alias=None, kwargs={}, **init_kwargs): ...
    def current_frame_should_contain(self, text, loglevel="TRACE"): ...
    def current_frame_should_not_contain(self, text, loglevel="TRACE"): ...
    def delete_all_cookies(self): ...
    def delete_cookie(self, name): ...
    def double_click_element(self, locator): ...
    def drag_and_drop(self, locator, target): ...
    def drag_and_drop_by_offset(self, locator, xoffset, yoffset): ...
    def element_attribute_value_should_be(
        self, locator, attribute, expected, message=None
    ): ...
    def element_should_be_disabled(self, locator): ...
    def element_should_be_enabled(self, locator): ...
    def element_should_be_focused(self, locator): ...
    def element_should_be_visible(self, locator, message=None): ...
    def element_should_contain(
        self, locator, expected, message=None, ignore_case=False
    ): ...
    def element_should_not_be_visible(self, locator, message=None): ...
    def element_should_not_contain(
        self, locator, expected, message=None, ignore_case=False
    ): ...
    def element_text_should_be(
        self, locator, expected, message=None, ignore_case=False
    ): ...
    def element_text_should_not_be(
        self, locator, not_expected, message=None, ignore_case=False
    ): ...
    def execute_async_javascript(self, *code): ...
    def execute_javascript(self, *code): ...
    def frame_should_contain(self, locator, text, loglevel="TRACE"): ...
    def get_all_links(self): ...
    def get_browser_aliases(self): ...
    def get_browser_ids(self): ...
    def get_cookie(self, name): ...
    def get_cookies(self, as_dict=False): ...
    def get_element_attribute(self, locator, attribute): ...
    def get_element_count(self, locator): ...
    def get_element_size(self, locator): ...
    def get_horizontal_position(self, locator): ...
    def get_list_items(self, locator, values=False): ...
    def get_location(self): ...
    def get_locations(self, browser="CURRENT"): ...
    def get_selected_list_label(self, locator): ...
    def get_selected_list_labels(self, locator): ...
    def get_selected_list_value(self, locator): ...
    def get_selected_list_values(self, locator): ...
    def get_selenium_implicit_wait(self): ...
    def get_selenium_speed(self): ...
    def get_selenium_timeout(self): ...
    def get_session_id(self): ...
    def get_source(self): ...
    def get_table_cell(self, locator, row, column, loglevel="TRACE"): ...
    def get_text(self, locator): ...
    def get_title(self): ...
    def get_value(self, locator): ...
    def get_vertical_position(self, locator): ...
    def get_webelement(self, locator): ...
    def get_webelements(self, locator): ...
    def get_window_handles(self, browser="CURRENT"): ...
    def get_window_identifiers(self, browser="CURRENT"): ...
    def get_window_names(self, browser="CURRENT"): ...
    def get_window_position(self): ...
    def get_window_size(self, inner=False): ...
    def get_window_titles(self, browser="CURRENT"): ...
    def go_back(self): ...
    def go_to(self, url): ...
    def handle_alert(self, action="ACCEPT", timeout=None): ...
    def input_password(self, locator, password, clear=True): ...
    def input_text(self, locator, text, clear=True): ...
    def input_text_into_alert(self, text, action="ACCEPT", timeout=None): ...
    def list_selection_should_be(self, locator, *expected): ...
    def list_should_have_no_selections(self, locator): ...
    def location_should_be(self, url, message=None): ...
    def location_should_contain(self, expected, message=None): ...
    def locator_should_match_x_times(
        self, locator, x, message=None, loglevel="TRACE"
    ): ...
    def log_location(self): ...
    def log_source(self, loglevel="INFO"): ...
    def log_title(self): ...
    def maximize_browser_window(self): ...
    def mouse_down(self, locator): ...
    def mouse_down_on_image(self, locator): ...
    def mouse_down_on_link(self, locator): ...
    def mouse_out(self, locator): ...
    def mouse_over(self, locator): ...
    def mouse_up(self, locator): ...
    def open_browser(
        self,
        url=None,
        browser="firefox",
        alias=None,
        remote_url=False,
        desired_capabilities=None,
        ff_profile_dir=None,
        options=None,
        service_log_path=None,
        executable_path=None,
    ): ...
    def open_context_menu(self, locator): ...
    def page_should_contain(self, text, loglevel="TRACE"): ...
    def page_should_contain_button(self, locator, message=None, loglevel="TRACE"): ...
    def page_should_contain_checkbox(self, locator, message=None, loglevel="TRACE"): ...
    def page_should_contain_element(
        self, locator, message=None, loglevel="TRACE", limit=None
    ): ...
    def page_should_contain_image(self, locator, message=None, loglevel="TRACE"): ...
    def page_should_contain_link(self, locator, message=None, loglevel="TRACE"): ...
    def page_should_contain_list(self, locator, message=None, loglevel="TRACE"): ...
    def page_should_contain_radio_button(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def page_should_contain_textfield(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def page_should_not_contain(self, text, loglevel="TRACE"): ...
    def page_should_not_contain_button(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def page_should_not_contain_checkbox(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def page_should_not_contain_element(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def page_should_not_contain_image(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def page_should_not_contain_link(self, locator, message=None, loglevel="TRACE"): ...
    def page_should_not_contain_list(self, locator, message=None, loglevel="TRACE"): ...
    def page_should_not_contain_radio_button(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def page_should_not_contain_textfield(
        self, locator, message=None, loglevel="TRACE"
    ): ...
    def press_key(self, locator, key): ...
    def press_keys(self, locator=None, *keys): ...
    def radio_button_should_be_set_to(self, group_name, value): ...
    def radio_button_should_not_be_selected(self, group_name): ...
    def register_keyword_to_run_on_failure(self, keyword): ...
    def reload_page(self): ...
    def remove_location_strategy(self, strategy_name): ...
    def scroll_element_into_view(self, locator): ...
    def select_all_from_list(self, locator): ...
    def select_checkbox(self, locator): ...
    def select_frame(self, locator): ...
    def select_from_list_by_index(self, locator, *indexes): ...
    def select_from_list_by_label(self, locator, *labels): ...
    def select_from_list_by_value(self, locator, *values): ...
    def select_radio_button(self, group_name, value): ...
    def select_window(self, locator="MAIN", timeout=None): ...
    def set_browser_implicit_wait(self, value): ...
    def set_focus_to_element(self, locator): ...
    def set_screenshot_directory(self, path): ...
    def set_selenium_implicit_wait(self, value): ...
    def set_selenium_speed(self, value): ...
    def set_selenium_timeout(self, value): ...
    def set_window_position(self, x, y): ...
    def set_window_size(self, width, height, inner=False): ...
    def simulate_event(self, locator, event): ...
    def submit_form(self, locator=None): ...
    def switch_browser(self, index_or_alias): ...
    def switch_window(self, locator="MAIN", timeout=None, browser="CURRENT"): ...
    def table_cell_should_contain(
        self, locator, row, column, expected, loglevel="TRACE"
    ): ...
    def table_column_should_contain(
        self, locator, column, expected, loglevel="TRACE"
    ): ...
    def table_footer_should_contain(self, locator, expected, loglevel="TRACE"): ...
    def table_header_should_contain(self, locator, expected, loglevel="TRACE"): ...
    def table_row_should_contain(self, locator, row, expected, loglevel="TRACE"): ...
    def table_should_contain(self, locator, expected, loglevel="TRACE"): ...
    def textarea_should_contain(self, locator, expected, message=None): ...
    def textarea_value_should_be(self, locator, expected, message=None): ...
    def textfield_should_contain(self, locator, expected, message=None): ...
    def textfield_value_should_be(self, locator, expected, message=None): ...
    def title_should_be(self, title, message=None): ...
    def unselect_all_from_list(self, locator): ...
    def unselect_checkbox(self, locator): ...
    def unselect_frame(self): ...
    def unselect_from_list_by_index(self, locator, *indexes): ...
    def unselect_from_list_by_label(self, locator, *labels): ...
    def unselect_from_list_by_value(self, locator, *values): ...
    def wait_for_condition(self, condition, timeout=None, error=None): ...
    def wait_until_element_contains(self, locator, text, timeout=None, error=None): ...
    def wait_until_element_does_not_contain(
        self, locator, text, timeout=None, error=None
    ): ...
    def wait_until_element_is_enabled(self, locator, timeout=None, error=None): ...
    def wait_until_element_is_not_visible(self, locator, timeout=None, error=None): ...
    def wait_until_element_is_visible(self, locator, timeout=None, error=None): ...
    def wait_until_location_contains(self, expected, timeout=None, message=None): ...
    def wait_until_location_does_not_contain(
        self, location, timeout=None, message=None
    ): ...
    def wait_until_location_is(self, expected, timeout=None, message=None): ...
    def wait_until_location_is_not(self, location, timeout=None, message=None): ...
    def wait_until_page_contains(self, text, timeout=None, error=None): ...
    def wait_until_page_contains_element(
        self, locator, timeout=None, error=None, limit=None
    ): ...
    def wait_until_page_does_not_contain(self, text, timeout=None, error=None): ...
    def wait_until_page_does_not_contain_element(
        self, locator, timeout=None, error=None, limit=None
    ): ...
    # methods from PythonLibCore
    def add_library_components(self, library_components): ...
    def get_keyword_names(self): ...
    def run_keyword(self, name, args, kwargs=None): ...
    def get_keyword_arguments(self, name): ...
    def get_keyword_tags(self, name): ...
    def get_keyword_documentation(self, name): ...
    def get_keyword_types(self, name): ...
    def get_keyword_source(self, keyword_name): ...
