# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['quart', 'quart.flask_patch', 'quart.json', 'quart.testing', 'quart.wrappers']

package_data = \
{'': ['*']}

install_requires = \
['aiofiles',
 'blinker<1.6',
 'click>=8.0.0',
 'hypercorn>=0.11.2',
 'itsdangerous',
 'jinja2',
 'markupsafe',
 'werkzeug>=2.2.0']

extras_require = \
{':python_version < "3.10"': ['importlib_metadata'],
 ':python_version < "3.8"': ['typing_extensions'],
 'docs': ['pydata_sphinx_theme'],
 'dotenv': ['python-dotenv']}

entry_points = \
{'console_scripts': ['quart = quart.cli:main']}

setup_kwargs = {
    'name': 'quart',
    'version': '0.18.4',
    'description': 'A Python ASGI web microframework with the same API as Flask',
    'long_description': 'Quart\n=====\n\n.. image:: https://raw.githubusercontent.com/pallets/quart/main/artwork/logo.png\n   :alt: Quart logo\n\n|Build Status| |docs| |pypi| |python| |license| |chat|\n\nQuart is an async Python web microframework. Using Quart you can,\n\n* render and serve HTML templates,\n* write (RESTful) JSON APIs,\n* serve WebSockets,\n* stream request and response data,\n* do pretty much anything over the HTTP or WebSocket protocols.\n\nQuickstart\n----------\n\nQuart can be installed via `pip\n<https://docs.python.org/3/installing/index.html>`_,\n\n.. code-block:: console\n\n    $ pip install quart\n\nand requires Python 3.7.0 or higher (see `python version support\n<https://quart.palletsprojects.com/en/latest/discussion/python_versions.html>`_\nfor reasoning).\n\nA minimal Quart example is,\n\n.. code-block:: python\n\n    from quart import Quart, render_template, websocket\n\n    app = Quart(__name__)\n\n    @app.route("/")\n    async def hello():\n        return await render_template("index.html")\n\n    @app.route("/api")\n    async def json():\n        return {"hello": "world"}\n\n    @app.websocket("/ws")\n    async def ws():\n        while True:\n            await websocket.send("hello")\n            await websocket.send_json({"hello": "world"})\n\n    if __name__ == "__main__":\n        app.run()\n\nif the above is in a file called ``app.py`` it can be run as,\n\n.. code-block:: console\n\n    $ python app.py\n\nTo deploy this app in a production setting see the `deployment\n<https://quart.palletsprojects.com/en/latest/tutorials/deployment.html>`_\ndocumentation.\n\nContributing\n------------\n\nQuart is developed on `GitHub <https://github.com/pallets/quart>`_. If\nyou come across an issue, or have a feature request please open an\n`issue <https://github.com/pallets/quart/issues>`_. If you want to\ncontribute a fix or the feature-implementation please do (typo fixes\nwelcome), by proposing a `merge request\n<https://github.com/pallets/quart/pulls>`_.\n\nTesting\n^^^^^^^\n\nThe best way to test Quart is with `Tox\n<https://tox.readthedocs.io>`_,\n\n.. code-block:: console\n\n    $ pip install tox\n    $ tox\n\nthis will check the code style and run the tests.\n\nHelp\n----\n\nThe Quart `documentation <https://quart.palletsprojects.com>`_ or\n`cheatsheet\n<https://quart.palletsprojects.com/en/latest/reference/cheatsheet.html>`_\nare the best places to start, after that try searching `stack overflow\n<https://stackoverflow.com/questions/tagged/quart>`_ or ask for help\n`on discord <https://discord.gg/pallets>`_. If you still\ncan\'t find an answer please `open an issue\n<https://github.com/pallets/quart/issues>`_.\n\nRelationship with Flask\n-----------------------\n\nQuart is an asyncio reimplementation of the popular `Flask\n<http://flask.pocoo.org/>`_ microframework API. This means that if you\nunderstand Flask you understand Quart.\n\nLike Flask Quart has an ecosystem of extensions for more specific\nneeds. In addition a number of the Flask extensions work with Quart.\n\nMigrating from Flask\n^^^^^^^^^^^^^^^^^^^^\n\nIt should be possible to migrate to Quart from Flask by a find and\nreplace of ``flask`` to ``quart`` and then adding ``async`` and\n``await`` keywords. See the `docs\n<https://quart.palletsprojects.com/en/latest/how_to_guides/flask_migration.html>`_\nfor more help.\n\n\n.. |Build Status| image:: https://github.com/pallets/quart/actions/workflows/tests.yaml/badge.svg\n   :target: https://github.com/pallets/quart/commits/main\n\n.. |docs| image:: https://img.shields.io/badge/docs-passing-brightgreen.svg\n   :target: https://quart.palletsprojects.com\n\n.. |pypi| image:: https://img.shields.io/pypi/v/quart.svg\n   :target: https://pypi.python.org/pypi/Quart/\n\n.. |python| image:: https://img.shields.io/pypi/pyversions/quart.svg\n   :target: https://pypi.python.org/pypi/Quart/\n\n.. |license| image:: https://img.shields.io/badge/license-MIT-blue.svg\n   :target: https://github.com/pallets/quart/blob/main/LICENSE\n\n.. |chat| image:: https://img.shields.io/badge/chat-join_now-brightgreen.svg\n   :target: https://discord.gg/pallets\n',
    'author': 'pgjones',
    'author_email': 'philip.graham.jones@googlemail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/pallets/quart/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
