# Bilibili Live Streaming Recorder (blrec)

这是一个前后端分离的 B 站直播录制工具。前端使用了响应式设计，可适应不同的屏幕尺寸；后端是用 Python 写的，可以跨平台运行。

这个工具是自动化的，会自动完成直播的录制, 在出现未处理异常时会发送通知，空间不足能够自动回收空间，还有详细日志记录，因此可以长期无人值守运行在服务器上。

## 屏幕截图

![webapp](https://user-images.githubusercontent.com/33854576/128959800-451d03e7-c9f9-4732-ac90-97fdb6b88972.png)

![terminal](https://user-images.githubusercontent.com/33854576/128959819-70d72937-65da-4c15-b61c-d2da65bf42be.png)

## 功能

- 自动完成直播录制
- 同步保存弹幕
- 自动修复时间戳问题：跳变、反跳等。
- 直播流参数改变自动分割文件，避免出现花屏等问题。
- 流中断自动拼接且支持 **无缝** 拼接，不会因网络中断而使录播文件片段化。
- `flv` 文件注入关键帧等元数据，定位播放和拖进度条不会卡顿。
- 可选录制的画质
- 可自定义文件保存路径和文件名
- 支持按文件大小或时长分割文件
- 支持转换 `flv` 为 `mp4` 格式（需要安装 `ffmpeg`）
- 硬盘空间检测并支持空间不足自动删除旧录播文件。
- 事件通知（支持邮箱、`ServerChan`、`pushplus`）
- `Webhook`（可配合 `REST API` 实现录制控制，录制完成后压制、上传等自定义需求）

## 先决条件

    Python 3.8+
    ffmpeg (如果需要转换 flv 为 mp4)

## 安装

    pip install blrec

用到的一些库需要 C 编译器，Windows 没 C 编译器会安装出错，使用以下方法安装已编译好的库。

    pip install -r windows-requirements.txt

## 使用方法

### 使用默认设置文件和保存位置

在命令行终端里敲入 `blrec` 并回车运行，然后在浏览器访问 `http://localhost:2233`。

设置文件为 `toml` 文件，默认位置在 `~/.blrec/settings.toml`。默认录播文件保存位置为当前工作目录 `.`。

### 指定设置文件和保存位置

`blrec -c path/to/settings.toml -o dirpath/to/save/files`

如果指定的设置文件不存在会自动创建。通过命令行参数指定保存位置会覆盖掉设置文件的设置。

### 绑定主机和端口

`blrec --host 0.0.0.0 --port 8000`

默认主机 `127.0.0.1`，默认端口 `2233`.

### 安全保障

`blrec --key-file path/to/key-file --cert-file path/to/cert-file --api-key ********`

可以使用 `api key` 防止被恶意访问和泄漏设置里的敏感信息

## 作为 ASGI 应用运行

    uvicorn blrec.web:app

或者

    hypercorn blrec.web:app

作为 ASGI 应用运行，参数通过环境变量指定。

- `config` 指定设置文件
- `out_dir` 指定保存位置
- `api_key` 指定 `api key`

### bash

    config=path/to/settings.toml out_dir=path/to/dir api_key=******** uvicorn blrec.web:app --host 0.0.0.0 --port 8000

### cmd

    set config=D:\\path\\to\\config.toml & set out_dir=D:\\path\\to\\dir & set api_key=******** uvicorn blrec.web:app --host 0.0.0.0 --port 8000

## Webhook

程序在运行过程中会触发一些事件，如果是支持 `webhook` 的事件，就会给所设置的 `webhook` 网络地址发送 POST 请求。

关于支持的事件和 `POST` 请求所发送的数据，详见 wiki。

## REST API

后端 `web` 框架用的是 `FastApi` , 要查看自动生成的交互式 `API` 文档，访问 `http://localhost:2233/docs` （默认主机和端口绑定）。

## Progressive Web App（PWA）

前端其实是一个渐进式网络应用，可以通过地址栏右侧的图标安装，然后像原生应用一样从桌面启动运行。

**注意：PWA 要在本地访问或者在 `https` 下才支持。**

---

## 更新日志

[CHANGELOG](CHANGELOG.md)

---

## 常见问题

### 如何终止程序？

`ctrl + c`

### 如何更新程序？

`pip install blrec --upgrade`

### 设置修改后什么时候生效？

设置修改后基本上是即时生效的，但是对于正在录制的任务有些例外。

对保存位置或路径模板的修改，不影响当前正在录制的文件，要下一次创建文件才会生效。

对画质的修改，要下一次获取直播流 `url` 才会生效。如果想立即生效，停止录制再重新开始录制就可以。

### 什么是流拼接和无缝拼接？

流拼接就是在录制的过程中出现网络中断时从中断的位置接续上去，以避免录播文件片段化。
而无缝拼接就是把中断处前后重复的数据丢掉然后再接续上，就好像没中断过一样，不会丢失数据。

**注意：只有网络中断后在短时间内重新连接上，中断处前后有重复数据才有可能进行无缝拼接。**

### 怎么知道是否出现了流中断?

如果流出现了中断，不但日志里有记录，程序还会把流中断的详细信息写入到视频文件的元数据里。

可以用 `ffprob` 查看视频文件元数据的 `Comment` 字段。

有些播放器也可以查看。`VLC` 可以按 `ctrl + i` 后查看注释；`PotPlayer` 可以按两次 tab 键查看评论（mp4 没问题，但是 flv 会因为内容过长而不显示~）。

mp4 还在非无缝拼接的位置添加了章节标记，支持章节标记的播放器应该可以看到。

### 如何避免流中断、漏录？

cpu 使用率过高、网络带宽不足或不稳定、硬盘读写慢都会导致流中断，如果不能及时恢复就无法进行无缝拼接进而导致漏录了。所以，只要运行程序的机器配置足够高且网络带宽充足稳定就可以有效避免录制端导致的流中断、漏录。

主播网络或 B 站服务器问题导致的流中断、漏录是无法避免的~

### 为什么录播文件的时长小于直播持续时间？

- 开播后推流有延迟
- 录制过程出现流中断并且未能无缝拼接，漏录了~
- 主播网络不稳定，流中出现了时间戳跳变、反跳，经过修正后时长可能会变短。

### 为什么录制的画质和所设置的画质不符合？

所设置的画质在开播后不一定存在，如果不存在就会以原画代替。

### 为什么按文件大小或时长分割的文件比设置的值小或短？

分割位置必须在关键帧处才不会丢帧。为了确保文件不会超过指定的限制，会在关键帧将超过所设置的值的前一个关键帧处进行分割，所以文件的大小或时长要比所设置的值小一些。

### 为什么没有设置分割文件还是出现了多个录播文件？

为了避免录播文件出现花屏等问题，在直播流参数改变（主播修改分辨率、码率等）时就会自动分割文件。

有时则是主播网络很不稳定造成多次下播上播导致的。

### 为什么设置了转换为 `mp4` 格式，但却没有进行转换？

请确保正确安装了 `ffmpeg`，可以在终端里正常使用 `ffmpeg`。

### 怎样才算是旧录播文件？

创建时间超过 24 小时才会被当成旧录播文件在空间不足时被删除。

### 空间不足时是怎样删除旧录播文件的？

删除文件是按创建时间的先后进行的，最早创建的最先被删除，直到可用空间不少于所设置的阈值为止。

### 支持录制付费直播吗？

没试过~ 可以尝试在网络请求设置里填写已付费账号登录后的 Cookie

### 为什么要重复造轮子？

因为现有工具大多都是直接下载流或调用 ffmpeg 进行录制，不能很好地解决漏录、数据损坏、录播文件片段化等录播问题。尤其录制的直播很不稳定，结果很不尽如人意。

---

## 赞助 & 支持

如果觉得这个工具好用，对你有所帮助，可以投喂支持亿下哦~

投喂赞助 ☞ <https://afdian.net/@acgnhiki>
