"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnsupportedLanguageError = exports.DocumentationLanguage = void 0;
/**
 * Supported languages to generate documentation in.
 */
class DocumentationLanguage {
    constructor(lang) {
        this.lang = lang;
    }
    /**
     * Transform a literal string to the `DocumentationLanguage` object.
     *
     * Throws an `UnsupportedLanguageError` if the language is not supported.
     */
    static fromString(lang) {
        switch (lang) {
            case DocumentationLanguage.TYPESCRIPT.toString():
                return DocumentationLanguage.TYPESCRIPT;
            case DocumentationLanguage.PYTHON.toString():
                return DocumentationLanguage.PYTHON;
            default:
                throw new UnsupportedLanguageError(lang, [DocumentationLanguage.TYPESCRIPT, DocumentationLanguage.PYTHON]);
        }
    }
    toString() {
        return this.lang;
    }
}
exports.DocumentationLanguage = DocumentationLanguage;
/**
 * TypeScript.
 */
DocumentationLanguage.TYPESCRIPT = new DocumentationLanguage('typescript');
/**
 * Python.
 */
DocumentationLanguage.PYTHON = new DocumentationLanguage('python');
class UnsupportedLanguageError extends Error {
    constructor(lang, supported) {
        super(`Unsupported language: ${lang}. Supported languages are: [${supported}]`);
    }
}
exports.UnsupportedLanguageError = UnsupportedLanguageError;
//# sourceMappingURL=data:application/json;base64,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