import torch
import random

class RandomResizedCrop(torch.nn.Module):
    def __init__(self, n_samples):
        super().__init__()
        self.n_samples = n_samples

    def forward(self, audio):
        max_samples = audio.shape[1]
        start_idx = random.randint(0, max_samples - self.n_samples)
        audio = audio[:, start_idx : start_idx + self.n_samples]
        return audio
