import random
import numpy as np
import torch


class Noise(torch.nn.Module):
    def __init__(self, min_snr=0.001, max_snr=1.0):
        """
        :param min_snr: Minimum signal-to-noise ratio
        :param max_snr: Maximum signal-to-noise ratio
        """
        super().__init__()
        self.min_snr = min_snr
        self.max_snr = max_snr

    def forward(self, audio):
        std = torch.std(audio)
        noise_std = random.uniform(
            self.min_snr * std, self.max_snr * std
        )

        noise = np.random.normal(
            0.0, noise_std, size=audio.shape
        ).astype(np.float32)

        return audio + noise
